#!/bin/bash
source `which my_do_cmd` 

print_help()
{
  echo "
  `basename $0` <dti.mif> <dti_corr.mif> <encoding.b> <encoding_corr.b> [-options]

  Options:
   -help
   -clobber

  Luis Concha
  INB
  Feb 2011			
"
}


if [ $# -lt 4 ] 
then
  echo "  ERROR: Need more arguments..."
  print_help
  exit 1
fi


declare -i i
i=1
clobber=0
for arg in "$@"
do

  case "$arg" in
  -h|-help) 
    print_help
    exit 1
  ;;
  -clobber)
    clobber=1
  ;;
  esac
  i=$[$i+1]
done




mif=$1
mifEC=$2
bvecIN=$3
bvecOUT=$4


if [ -f $mifEC -a $clobber -eq 0 ]
then
  echo "File $mifEC exists. Use -clobber to overwrite. Bye".
  exit 1
fi


FSLOUTPUTTYPE=NIFTI
my_do_cmd mrconvert $mif ${mif%.mif}.nii
my_do_cmd eddy_correct ${mif%.mif}.nii ${mif%.mif}_ec.nii 0
my_do_cmd mrconvert ${mif%.mif}_ec.nii $mifEC

rm ${mif%.mif}.nii ${mif%.mif}_ec.nii


bvecs=bvecs$$
rbvecs=rbvecs$$
ecclog=${mif%.mif}_ec.ecclog
transpose_table.sh $bvecIN | head -n 3 > $bvecs

my_do_cmd rotbvecs $bvecs $rbvecs $ecclog

tmpfile=tmpfile$$
cat $rbvecs > $tmpfile
transpose_table.sh $bvecIN | tail -n 1 >> $tmpfile
transpose_table.sh $tmpfile > $bvecOUT

rm $tmpfile $bvecs $rbvecs $ecclog
