#!/bin/bash

###
# This script creates a CSV file listing the parameters of all
# the Varian MRI images in this directory. Additional tags can
# be specified in the TAGS variable

FILES=(`find . -name procpar`)
TAGS=(tr te nt nv np ns lpe lro thk seqfil)

echo "Image, `echo ${TAGS[*]} | sed -e "s/ /, /g"`"

for fn in ${FILES[*]}
do

  ROW=`echo $fn | sed -e "s|/procpar||"`

  for tag in ${TAGS[*]}
  do

    LINE=(`grep -A 1 -h "^$tag " $fn | tail -n 1`)
    VAL=${LINE[1]}
    
    if [ $tag == "tr" -o $tag == "te" ]; then
      VAL=`python -c "print $VAL * 1000"`
    fi

    if [ $tag == "lpe" -o $tag == "lro" ]; then
      VAL=`python -c "print $VAL * 10"`
    fi

    if [ $tag == "np" ]; then
      VAL=`python -c "print $VAL / 2"`
    fi

    ROW="$ROW, $VAL"

  done
  echo $ROW

done


