function Z = read_multislice(path)
% Reads multi-slice complex data from an fid file, computes
% Fourier transform and returns as a 3D volume
% Usage:
%       Z = read_multislice(path)
% Parameters:
%       path        Directory containing fid and procpar files
% Output:
%       Z           3D complex volume

% Get the dimensions of the image
np = read_procpar(path,'np') / 2;
nv = read_procpar(path,'nv');
ns = read_procpar(path,'ns');

% Get the slice positions
pss = read_procpar(path,'pss');

% Check if pss is sorted and if not sort it
[pss ipss] = sort(pss);

% Read the FID file
[RE,IM]=read_fid(path);

% Allocate data for output
Z = complex(zeros(np,nv,ns));

% Loop over the slices
for i = 1:ns    
    
    % Get the slice of the K-space
    j = ipss(i);
    kslice = complex(RE(:,j:ns:ns*nv),IM(:,j:ns:ns*nv));
    
    % Apply baseline correction to the slice (why?)
    kslice = baseline_correction(kslice, 8);
    
    % Compute the FFT
    Z(:,:,i) = fftshift(fft2(fftshift(kslice)));

end

% Print a message
fprintf('Read (%d x %d x %d) volume %s\n', np, nv, ns, path);
