function val = read_procpar(dir_fid, key)
% Read the a value from the procpar file generated by Varian
% Usage:
%     val = read_procpar(dir_fid)
% Parameters:
%     dir_fid       Directory where the file is located
%     key           Variable whose value to retrieve

% Read the file
f = fopen(fullfile(dir_fid,'procpar'));

% Search the file for the string
while ~feof(f)

  % Get the next line in the file
  ln = fgetl(f);
  
  % Split the line into key and rest
  [lk lr] = strtok(ln);
  
  % Check if the line starts with the word
  if strcmp(lk, key)

    % Read the variable type
    meta = strread(lr);
    type = meta(2);
      
    % Read the next line
    lnext = fgetl(f);
    
    % Read the number of entries
    [lk lr] = strtok(lnext);
    num = strread(lk);
    
    % If the entries are numeric return them
    if type == 1        
        val = strread(lr,'%f',num);
        fclose(f);
        return;
    elseif type == 2
        val = get_procpar_strings(lr);
        return;
    end
  end
end

error('Key %s not found',key);

end


function A = get_procpar_strings(S)

    A = [];
    ind = reshape(strfind(S,'"'),2,[])';
    for i = 1:size(ind,1)
        A = strvcat(A,S(ind(i,1)+1:ind(i,2)-1));
    end
    
end