\mainpage MOE 

  Section of Biomedical Image Analysis <br>
  Department of Radiology <br>
  University of Pennsylvania <br>
  Goddard Building <br>
  3701 Hamilton Walk, 6th Floor <br>
  Philadelphia, PA 19104 <br>

  Web:   http://www.cbica.upenn.edu/sbia/ <br>
  Email: sbia-software at uphs.upenn.edu

  Copyright (c) 2015 University of Pennsylvania. All rights reserved. <br>
  See http://www.cbica.upenn.edu/sbia/software/license.html or COPYING file.

<b> Author: </b>
Harini Eavani
Harini.Eavani@uphs.upenn.edu 
cbica-software@uphs.upenn.edu

===============
1. INTRODUCTION
===============
In MRI studies, linear multi-variate classification methods are often employed to identify connections that can predict diseased state or age of an individual. Such linear models inherently assume that there is a single pattern of change that linearly scales with disease severity or age in all individuals. While kernel-based methods can implicitly model a non-linear effect, and therefore the heterogeneity in the affected group, finding features that contribute to the classification is difficult.The Mixture-Of-Experts (MOE) method explicitly models and captures heterogeneous patterns of change in the affected group relative to a reference group of controls.

For more details, please read UserManual.pdf

===============
2. SOFTWARE & INSTALLATION
===============

This software has been primarily implemented for Linux operating systems. It is implemented in Python.

----------------
 Dependencies
----------------
- Python 2.7.9
- Python library numpy 1.7.2
- Python library scipy 0.15.1
- Python library pandas 0.16.2
- Python library sklearn 0.15

Make sure all dependencies are met before proceeding with install.

1) Within the src/  directory, run makeAll.py  with the location of the install directory as the argument:

./makeAll.py <installDir>

makeAll creates four folders within installDir - bin, libexec, share and doc.
bin/ contains the executible, which is a symlink to MOE.py in libexec/.
libexec/ has all python scripts.
share/ has the test data.
doc/ has the doxygen documentation.

2) Add the install directory to your path by running the following command. 

Replace ${installDir} with the location of the install directory from step 1 above.

export PATH=${PATH}:${installDir}/bin/

==========
3. TEST    
==========
To test the software, we have provided synthetic two dimensional data for four test cases. In each of these cases, data points denoted by circles are the reference (control) samples, while points denoted by triangles are the affected (patient) cases which are made up of heterogeneous sub-groups. These are located in ${installDir}/share/test/Case∗. The image test/All_test_results.png shows the four test cases, it is also shown in Figure 1. To run the software on the synthetic data, run the following command from the ${installDir}/libexec/ folder :

./test.py ${installDir}

This command should return four png images, one for each test case, saved in their corresponding folders:

${installDir}/share/test/Case∗/Case∗_MOEplot.png

along with other output. Was MOE able to correctly identify heterogeneity in all four test cases? You can compare your result to the ground truth for all four cases, shown in the image test/All_test_results.png.


==========
4. Usage
==========

To run this software you will need:

1. An input csv file, with the following mandatory fields:
(a) Subject index in the first column
(b) Header row in the first row
(c) A column containing the binary group labels - the name of the column and the value of the patient group (of whose heterogeneous sub-groups you want to find) needs to be provided in the command line options.

For a csv file ROI_values.csv that looks like below:
    
    Subject_id, ROI_1, ROI_2, ROI_3, ..., Label, ...
    BLSA_0001, 0.234, 0.4545, 0.212,...., 1 , ...
    BLSA_0002, 0.122, 0.1213, 0.3434,..., -1, ...  
    ...
    ...
    
Run the following command:
moe -d ROI_values.csv -p ROI_results -l 1 -n 3 -o ./ -v


In the output directory, the software returns:
1. One python numpy file containing all the results, with file name <prefix>_results_allResults.npz
2. A csv file containing the hyperplanes, indexed against feature name in the first row. Filename <prefix>_results_hyperplanes.csv
3. A csv file containing the memberships, indexed against subject id in the first column. Filename <prefix>_results_memberships.csv
 
 
===========
5. LICENSING
===========

  See http://www.cbica.upenn.edu/sbia/software/license.html or "licences/COPYING" file.
