/*******************************************************

Functions for Constructing the neighorhoods.

last modified : Dec 4, 2010

Contact: Tianhao Zhang(tianhao.zhang@uphs.upenn.edu)

*******************************************************/
#define True  1
#define False 0
#include "cv.h"
#include <iostream>
#include <string>
#include <algorithm>
using namespace std; 

typedef struct ExDatabase
{
	long m;									//m : number of samples
	long n;	
	long nn;	//n : dimensionality of samples
	//CvMat* X;								// database, m*n
	CvMat* NI;								// ID of database, m*1
	CvMat* index;
	int NE; 
	int DS;

}ExDatabase;


bool readDatabase(ExDatabase& database,const char* name1);
int* random(int n);  
int* randperm(int n);
void randperm2(int n, int perm[]);
bool readData(CvMat* X,const char* name);				// read data
bool writeData(CvMat* X,const char* name);	
char ***cc3tensor(long nrh, long nch, long ndh);
float *fvector(long nh);
float ****f4tensor(long nrh, long nch, long ndh, long nth);
void free_f4tensor(float ****t, long nrh, long nch, long ndh, long nth);
void free_cc3tensor(char  ***t, long nrh, long nch, long ndh);
void nrerror(char error_text[]);
 
class FeatureExtraction {
  
 public:
 
  int  _DebugFlag;
  /// Constructor
  FeatureExtraction();
  /// Destructor
  ~FeatureExtraction();
  /// Returns the name of the class
  char *NameOfClass();
  /// Prints debugging messages if debugging is enabled
  void Debug(char *);

 public:
 
  char *_file_sublist;
  char ***_file_name;  
  float *_label;
  int _num_po_subject;
  int _num_ne_subject;
  int _num_subject;
  int  _xdim;
  int  _ydim;
  int  _zdim;
  long _im_size;
  long _num_feature;
  int  _subject_id; // for leave one out test
  float _smooth_size;  // smooth the enhanced score map
  float _p;
  
  long _num_classification_feature;
  char _data_root_dir[200];
  
  float ****_feature_data;  // store the features of all the subjects [sub][x][y][z];
  CvMat* origin_data;
  void ReadData(int feat);
  /// Sets input for the feature selection routine
  void SetInput (char *sublist,int subject_id);
  void GetInput();  
  /// Initial set up for the feature selection
  void Initialize();
  /// Final set up for the feature selection
  void Finalize();
  void Run(); 

};


