##############################################################################
# \file  SbiaSettings.cmake
# \brief Default CMake settings used at SBIA.
#
# This file specifies the common CMake settings such as the common build
# configuration used by projects developed at SBIA. Note that this file is
# included in the root CMake file by the macro sbia_project () prior to the
# invocation of the CMake command project (). Thus, project related
# variables are not available at this point.
#
# DO NOT edit this file. Instead, overwrite the default settings and add
# further project specific settings in the Settings.cmake file located in the
# top directory of the project's source tree.
#
# For copyright information please see Copyright.txt in the root
# directory of the project.
#
# Contact: SBIA Group <sbia-software@uphs.upenn.edu>
##############################################################################

# ============================================================================
# options
# ============================================================================

option (CMAKE_VERBOSE        "Verbose mode" "OFF")
option (OUTPUT_NAME_PREFIXED "Whether target output names should be prefixed by OUTPUT_NAME_PREFIX." "OFF")
option (BUILD_DOC            "Whether to generate the (API) documentation" "ON")
option (MCC_MATLAB_MODE      "Prefer MATLAB mode over standalone mode to invoke MATLAB Compiler." "ON")

mark_as_advanced (OUTPUT_NAME_PREFIXED)
mark_as_advanced (CMAKE_VERBOSE)
mark_as_advanced (MCC_MATLAB_MODE)

# ============================================================================
# output name prefix
# ============================================================================

set (
  OUTPUT_NAME_PREFIX "Sbia"
  CACHE
    STRING
	"If OUTPUT_NAME_PREFIXED is ON, the output name of targets will be prefixed by this string value."
)

mark_as_advanced (OUTPUT_NAME_PREFIX)

# ============================================================================
# directories
# ============================================================================

# ----------------------------------------------------------------------------
# build tree
# ----------------------------------------------------------------------------

set (RUNTIME_OUTPUT_DIRECTORY "bin"
  CACHE PATH "Output directory for runtime libraries (relative to build tree)."
)

set (LIBRARY_OUTPUT_DIRECTORY "lib"
  CACHE PATH "Output directory for static and import libraries (relative to build tree)."
)

set (EXECUTABLE_OUTPUT_PATH "bin"
  CACHE PATH "Output directory for executables (relative to build tree)."
)

set (LIBRARY_OUTPUT_PATH "lib"
  CACHE PATH "Output directory for libraries (relative to build tree)."
)

# make relative paths absolute and make options advanced
foreach(P RUNTIME LIBRARY)
  set(VAR ${P}_OUTPUT_DIRECTORY)
  if(NOT IS_ABSOLUTE "${${VAR}}")
    set(${VAR} "${CMAKE_CURRENT_BINARY_DIR}/${${VAR}}")
  endif()
  mark_as_advanced ("${VAR}")
endforeach()

foreach(P EXECUTABLE LIBRARY)
  set(VAR ${P}_OUTPUT_PATH)
  if(NOT IS_ABSOLUTE "${${VAR}}")
    set(${VAR} "${CMAKE_CURRENT_BINARY_DIR}/${${VAR}}")
  endif()
  mark_as_advanced ("${VAR}")
endforeach()

# ----------------------------------------------------------------------------
# testing tree
# ----------------------------------------------------------------------------

set (TESTING_BIN_DIR      "Testing/bin"           CACHE PATH "Output directory for test executables.")
set (TESTING_INPUT_DIR    "Testing/Data/Input"    CACHE PATH "Directory containing test input data.")
set (TESTING_EXPECTED_DIR "Testing/Data/Expected" CACHE PATH "Directory containing expected output data used for comparison to test outputs.")
set (TESTING_OUTPUT_DIR   "Testing/Output"        CACHE PATH "Directory in which tests output generated data.")

# make relative paths absolute and make options advanced
foreach(P INPUT EXPECTED)
  set(VAR TESTING_${P}_DIR)
  if(NOT IS_ABSOLUTE "${${VAR}}")
    set(${VAR} "${CMAKE_CURRENT_SOURCE_DIR}/${${VAR}}")
  endif()
  mark_as_advanced ("${VAR}")
endforeach()

foreach(P BIN OUTPUT)
  set(VAR TESTING_${P}_DIR)
  if(NOT IS_ABSOLUTE "${${VAR}}")
    set(${VAR} "${CMAKE_CURRENT_BINARY_DIR}/${${VAR}}")
  endif()
  mark_as_advanced ("${VAR}")
endforeach()

# ----------------------------------------------------------------------------
# install tree
# ----------------------------------------------------------------------------

if (WIN32)
  set (INSTALL_LIB_DIR     "Lib"     CACHE PATH "Installation directory for libraries.")
  set (INSTALL_BIN_DIR     "Bin"     CACHE PATH "Installation directory for executables.")
  set (INSTALL_INCLUDE_DIR "Include" CACHE PATH "Installation directory for header files.")
  set (INSTALL_DOC_DIR     "Doc"     CACHE PATH "Installation directory for documentation.")
  set (INSTALL_EXAMPLE_DIR "Example" CACHE PATH "Installation directory for example.")
else ()
  set (INSTALL_LIB_DIR     "lib"     CACHE PATH "Installation directory for libraries.")
  set (INSTALL_BIN_DIR     "bin"     CACHE PATH "Installation directory for executables.")
  set (INSTALL_INCLUDE_DIR "include" CACHE PATH "Installation directory for header files.")
  set (INSTALL_DOC_DIR     "doc"     CACHE PATH "Installation directory for documentation.")
  set (INSTALL_EXAMPLE_DIR "example" CACHE PATH "Installation directory for example.")
endif ()

# make absolute paths relative
foreach(P LIB BIN INCLUDE DOC EXAMPLE)
  set(VAR INSTALL_${P}_DIR)
  if (IS_ABSOLUTE "${${VAR}}")
    file (RELATIVE_PATH "${VAR}" "${CMAKE_INSTALL_PREFIX}" "${${VAR}}")
  endif ()
endforeach()

# make options advanced
foreach(P LIB BIN INCLUDE DOC EXAMPLE)
  set(VAR INSTALL_${P}_DIR)
  mark_as_advanced ("${VAR}")
endforeach()

# ============================================================================
# build configuration(s)
# ============================================================================

# list of all available build configurations
set (
  CMAKE_CONFIGURATION_TYPES
    "Debug"
    "Coverage"
    "Release"
  CACHE STRING "Build configurations." FORCE
)

# list of debug configurations, used by target_link_libraries (), for example,
# to determine whether to link to the optimized or debug libraries
set (DEBUG_CONFIGURATIONS "Debug")

mark_as_advanced (CMAKE_CONFIGURATION_TYPES)
mark_as_advanced (DEBUG_CONFIGURATIONS)

if (NOT CMAKE_BUILD_TYPE MATCHES "Debug|Coverage|Release")
  set (CMAKE_BUILD_TYPE "Release")
endif ()

set (
  CMAKE_BUILD_TYPE
    "${CMAKE_BUILD_TYPE}"
  CACHE STRING
    "Current build configuration. Specify either \"Debug\", \"Coverage\", or \"Release\"."
  FORCE
)

# ----------------------------------------------------------------------------
# common
# ----------------------------------------------------------------------------

# common compiler flags
set (CMAKE_C_FLAGS   "${CMAKE_C_FLAGS}")
set (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}")

# common linker flags
set (CMAKE_EXE_LINKER_FLAGS    "${CMAKE_EXE_LINKER_FLAGS}    -lm")
set (CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} -lm")
set (CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} -lm")

# common MATLAB Compiler flags
set (MCC_FLAGS   "-v -R -singleCompThread" CACHE STRING "Common MATLAB Compiler flags (separated by ' '; use '\\' to mask ' ').")
set (MCC_TIMEOUT "600"                     CACHE STRING "Timeout for MATLAB Compiler execution")

mark_as_advanced (MCC_FLAGS)
mark_as_advanced (MCC_TIMEOUT)

# ----------------------------------------------------------------------------
# MinSizeRel - disabled
# ----------------------------------------------------------------------------

# compiler flags of MinSizeRel configuration
set (CMAKE_C_FLAGS_MINSIZEREL   "" CACHE INTERNAL "" FORCE)
set (CMAKE_CXX_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)

# linker flags of MinSizeRel configuration
set (CMAKE_EXE_LINKER_FLAGS_MINSIZEREL    "" CACHE INTERNAL "" FORCE)
set (CMAKE_MODULE_LINKER_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)
set (CMAKE_SHARED_LINKER_FLAGS_MINSIZEREL "" CACHE INTERNAL "" FORCE)

# ----------------------------------------------------------------------------
# RelWithDebInfo - disabled
# ----------------------------------------------------------------------------

# compiler flags of RelWithDebInfo configuration
set (CMAKE_C_FLAGS_RELWITHDEBINFO   "" CACHE INTERNAL "" FORCE)
set (CMAKE_CXX_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)

# linker flags of RelWithDebInfo configuration
set (CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO    "" CACHE INTERNAL "" FORCE)
set (CMAKE_MODULE_LINKER_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)
set (CMAKE_SHARED_LINKER_FLAGS_RELWITHDEBINFO "" CACHE INTERNAL "" FORCE)

# ----------------------------------------------------------------------------
# Coverage
# ----------------------------------------------------------------------------

# compiler flags for Coverage configuration
set (CMAKE_C_FLAGS_COVERAGE   "-g -O0 -Wall -W -fprofile-arcs -ftest-coverage")
set (CMAKE_CXX_FLAGS_COVERAGE "-g -O0 -Wall -W -fprofile-arcs -ftest-coverage")

# linker flags for Coverage configuration
set (CMAKE_EXE_LINKER_FLAGS_COVERAGE    "-fprofile-arcs -ftest-coverage")
set (CMAKE_MODULE_LINKER_FLAGS_COVERAGE "-fprofile-arcs -ftest-coverage")
set (CMAKE_SHARED_LINKER_FLAGS_COVERAGE "-fprofile-arcs -ftest-coverage")

