\mainpage Main Page

  Section of Biomedical Image Analysis <br>
  Department of Radiology <br>
  University of Pennsylvania <br>
  3600 Market Street, Suite 380 <br>
  Philadelphia, PA 19104 <br>

<pre>
Web  : http://www.cbica.upenn.edu/sbia/
Email: <a href="mailto:sbia-software@uphs.upenn.edu">sbia-software at uphs.upenn.edu</a> 
</pre>

  Copyright (c) 2015 University of Pennsylvania. All rights reserved. <br>
  See http://www.cbica.upenn.edu/sbia/software/license.html or COPYING file.

<b> Authors: </b>
<table border="0" style="width:100%">
  <tr text-align="top">
    <td width="15%">Tianhao Zhang</td>
    <td>Primary developer</td>
  </tr>
  <tr text-align="top">
    <td width="15%">Andreas Schuh</td>
    <td>Revised the software and utilized MPI for a parallel execution using multiple slots available on a cluster</td>		
  </tr>
  <tr text-align="top">
    <td width="15%">Sarthak Pati</td>
    <td>Refined the software by enabling use on local non-HPC machines using OpenMP, improved command line parsing, better documentation generation and improved comments</td>		
  </tr>
</table>

===============
1. INTRODUCTION
===============

  This software package implements ODVBA [1], which is used to determine the
  optimal spatially adaptive smoothing of images, followed by applying a
  voxel-based group analysis.

  Voxel-based Analysis and Statistical Parametric Mapping (VBA-SPM) [2] of
  imaging data have offered the potential to analyze structural and functional
  data in great spatial detail, without the need to define a priori regions of
  interest (ROIs) and assumptions. Gaussian smoothing of images is an important
  step in VBA-SPM; it accounts for registration errors and integrates imaging
  signals from a region around each voxel being analyzed. However, it has also
  become a limitation of VBA-SPM based methods, since it is often chosen
  empirically, non-optimally, and lacks spatial adaptivity to the shape and
  spatial extent of the region of interest.

  ODVBA provides a mathematically rigorous framework for determining the optimal
  spatial smoothing of structural and functional images, prior to applying
  voxel-based group analysis. In order to determine the optimal smoothing kernel,
  a local discriminative analysis, restricted by appropriate nonnegativity
  constraints, is applied to a spatial neighborhood around each voxel, aiming to
  find the direction best highlights the difference between two groups in that
  neighborhood. Since each voxel belongs to a large number of such neighborhoods,
  each centered on one of its neighboring voxels, the group difference at each
  voxel is determined by a composition of all these optimal smoothing directions.
  Permutation tests are used to obtain the statistical significance of the
  resulting Optimally-Discriminative VBM (ODVBA) maps.


===================
2. PACKAGE OVERVIEW
===================

\verbatim
- CMakeLists.txt      Root CMake configuration file.  
- src/                Source code files
- cmake_modules/      CMake module files used internally
- ATLAS/              boost_numeric bindings (see ATLAS/boost-numeric-bindings/LICENSE_1_0.txt for details)
- docs/               Doxygen file to generate documentation for the project
- Testing/            Implementation of software tests and corresponding data
- AUTHORS.txt         A list of the people who contributed to this software  
- COPYING.txt         The copyright and license notices
- INSTALL.txt         Build and installation instructions (these are also illustrated in the section below)
- README.md           This file
\endverbatim


===============
3. INSTALLATION
===============

----------------------
3.1 Build Dependencies
----------------------

The following software has to be installed (if not optional).

- Linux OS

- CMake 2.8.12+

- CXX compiler which supports multi threading (GCC 4.7+)

- ATLAS 3.8.3+

  Web Site: http://math-atlas.sourceforge.net/ <br>
  Download: https://sourceforge.net/projects/math-atlas/files/Stable/ <br>
  Ubuntu:   libatlas-dev

- Boost 1.33+

  Web Site: http://www.boost.org/ <br>
  Download: http://www.boost.org/users/download/ <br>
  Ubuntu:   libboost-dev 

- boost-numeric-bindings 20081116+ (already provided in the <code><b>ATLAS/</b></code> directory - see <code><b>ATLAS/boost-numeric-bindings/LICENSE_1_0.txt</b></code> for details)

  Web Site: http://mathema.tician.de/software/boost-numeric-bindings <br>
  Download: http://mathema.tician.de/dl/software/boost-numeric-bindings 

  In particular, the ATLAS bindings are used by this software.

- nifticlib 1.1+

  Web Site: http://niftilib.sourceforge.net/ <br>
  Download: http://sourceforge.net/projects/niftilib/files/nifticlib/ <br>
  Ubuntu:   libnifti1-dev or nifticlib


An example installation chain (for Ubuntu 14.04) is given below:

\verbatim
sudo add-apt-repository ppa:ubuntu-toolchain-r/test
sudo apt-get update
sudo apt-get install build-essential
sudo apt-get install g++-4.9 cmake # check version using "gcc --version", if mismatch then change the symbolic link /usr/bin/g++ to a target of /usr/bin/g++-4.9
sudo apt-get install libblas-dev libatlas-dev libatlas-base-dev libatlas3-base liblapacke-dev libboost-all-dev libnifti-dev libnifti2 
sudo apt-get install doxygen
\endverbatim


Note for RedHat 7+ distributions (this definitely applies to CentOS 7 and Fedora 22):

The Atlas library has started building a single "master" .so file for Fedora (reference - https://www.centos.org/forums/viewtopic.php?f=47&t=48723). 
To mitigate the FindLapack issue with CMake, create soft links for <code>libatlas.so</code>, <code>libcblas.so</code> and <code>libf77blas.so</code> with <code>/usr/lib64/atlas/libsatlas.so</code>
under <code>/usr/lib64/</code> or to a directory where you have write access and append it to <code>CMAKE_LIBRARY_PATH</code>.


---------------
3.2 Build ODVBA
---------------

The common steps to build, test, and install software based on CMake,
including this software, are as follows:

1. Extract source files.
2. Create build directory change to it.
3. Run CMake to configure the build tree.
4. Build the software using selected build tool.
5. Run the unit tests (optional but recommended).
6. Install the built files (optional).

On Unix-like systems with GNU Make as build tool, these build steps can be
summarized by the following sequence of commands executed in a shell,
where <code>$package</code> and <code>$version</code> are shell variables which represent the name
of this package and the obtained version of the software.

\verbatim
tar xzf $package-$version-source.tar.gz
mkdir $package-$version-build; cd $package-$version-build
cmake -DCMAKE_INSTALL_PREFIX:PATH=$install_path ../
make
make test    #optional but recommended
make install #optional
\endverbatim

Please refer to this guide first if you are uncertain about above steps or
have problems to build, test, or install the software on your system.
If this guide does not help you resolve the issue, please contact us at
<a href="mailto:sbia-software@uphs.upenn.edu">sbia-software at uphs.upenn.edu</a>. 

In case of configuration errors, please attach the following file: <code><b>$build_directory/CMakeCache.txt</b></code>.

In case of compilation errors, please attach the output of the following command in addition to the previous file:

\verbatim
make >& make.log
\endverbatim

In case of failing tests, please attach the output of the following command to your email along of the previous two files:

\verbatim
ctest -V >& test.log
\endverbatim

In the following, only package-specific CMake settings available to
configure the build and installation of this software are documented.


---------------------------------
3.3 CMake Configuration Variables
---------------------------------

\verbatim
ATLAS_CBLAS_INCLUDE_DIR   CBlas header location
ATLAS_CLAPACK_INCLUDE_DIR Lapack header location
CBLAS_LIB                 CBlas install location
ITK_DIR                   ITK install location
CMAKE_INSTALL_PREFIX      Directory to do the installation
NiftiCLib_DIR             Installation directory of the nifticlib library, e.g., /usr/local.
                          
Advanced CMake Options:

BLAS_atlas_LIBRARY        Path of the ATLAS library.
BLAS_cblas_LIBRARY        Path of the C BLAS library.
BLAS_f77blas_LIBRARY      Path of the Fortran BLAS library.
Boost_INCLUDE_DIR         Include directory of the Boost library, e.g., /usr/include.
Boost_LIBRARY_DIRS        Directory where the Boost libraries are installed, e.g., /usr/lib.
\endverbatim

 
================
4. DOCUMENTATION
================

After generating project files, run the following command from the build directory:<BR><br>
<CODE>make doc</CODE><BR>

The HTML and Latex documentation will be generated in the location <code><b>$build_directory/docs/</b></code>.


=============
5. REFERENCES
=============

\verbatim
[1] "Optimally-Discriminative Voxel-Based Analysis"; Zhang, T., Davatzikos, C. Proceeding of International Conference on Medical Image Computing and Computer-Assisted Intervention (2010), vol. 13, no.2, pp: 257-265
[2] "Voxel-based morphometry-the methods"; Ashburner, J., Friston, K.J. Neuroimage (2000), 11(6) 805–821 
[3] "Alzheimer’s Disease Neuroimaging Initiative"; http://www.loni.ucla.edu/ADNI
\endverbatim

============
6. LICENSING
============

See http://www.cbica.upenn.edu/sbia/software/license.html or COPYING file.
