/**
\file  odvba_tests.cxx

\brief File for testing the basic classes.

http://www.cbica.upenn.edu/sbia/software/
sbia-software@uphs.upenn.edu

Copyright (c) 2015 University of Pennsylvania. All rights reserved.
See COPYING file or http://www.cbica.upenn.edu/sbia/software/license.html.

*/
//#include <nifti1_io.h>
#include <iostream>
#include <iterator>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <algorithm>
#include <exception>
#include <typeinfo>
#include <stdexcept>
#include <omp.h>
#include <vector>
#include <sys/stat.h>
#include <cstdlib>
# include <sys/time.h>
#include <sys/types.h>
#include <dirent.h>
#include <nifti1_io.h>

#include "CAlgorithm.h"
#include "cbicaUtilities.h"


int main(int argc, char** argv)
{
  try
  {
    if( (std::string( "-u").compare(argv[1]) == 0) || (std::string( "-h").compare(argv[1]) == 0) || 
        (std::string("--u").compare(argv[1]) == 0) || (std::string("--h").compare(argv[1]) == 0) ||
        (std::string( "-usage").compare(argv[1]) == 0) || (std::string( "-help").compare(argv[1]) == 0) ||
        (std::string("--usage").compare(argv[1]) == 0) || (std::string("--help").compare(argv[1]) == 0)  )
    {
      char buff[100];
      sprintf( buff, "This is a testing scenario.\n");
      buff[0] = '\0';
    }
    
    if( (std::string( "-t").compare(argv[1]) == 0) || (std::string("--threadNumbers").compare(argv[1]) == 0) )
    {
      const unsigned int threadsToTest = std::atoi(argv[2]);
      const unsigned int threadCount = omp_get_max_threads();
      
      if( threadsToTest > threadCount )
      {
        return EXIT_FAILURE;
      }
      
    }
	
    if( (std::string( "-t").compare(argv[1]) == 0) || (std::string("--threadNumbers").compare(argv[1]) == 0) )
    {
      const unsigned int threadsToTest = std::atoi(argv[2]);
      const unsigned int threadCount = omp_get_max_threads();
      
      if( threadsToTest > threadCount )
      {
        return EXIT_FAILURE;
      }
    }
     
    if( (std::string( "-c").compare(argv[1]) == 0) || (std::string("--createIndex").compare(argv[1]) == 0) )
    {

      std::string fn = std::string(argv[2]) + "/Testing/data/subjects_real.txt";
      //string fn ("../../Testing/data/subjects.txt");
      //  char * sublist = cbica::constCharToChar(fn);
      char * sublist = new char [fn.length()+1];
      strcpy (sublist, fn.c_str());

      transferData *trans_testData = new transferData;  
      trans_testData->SetInput (sublist, 2);
      trans_testData->GetInput();
      trans_testData->Read_nifti_Data();
      ublas::matrix<double> index = create_index(trans_testData->origin_data);
      //writeData(index,std::string( std::string(argv[2]) + "index_testing.txt" ).c_str());
      //writeData(index,"index_testing.txt");
      //const unsigned int threadsToTest = std::atoi(argv[2]);
      //const unsigned int threadCount = omp_get_max_threads();

      
      //if( threadsToTest > threadCount )
      //{
        //return EXIT_FAILURE;
      //}
    }
    
    if ((std::string("-n").compare(argv[1]) == 0) || (std::string("--nifti").compare(argv[1]) == 0))
    {
      std::string fileName = std::string(argv[2]) + "/Testing/data/003_S_1059-2006-11-09_RAVENS_GM_us.DS.nii.gz";
      nifti_image* nim1;
      nim1 = nifti_image_read(fileName.c_str(), 0);
      
      if (!nim1)
      {
        return EXIT_FAILURE;
      }
      
      if (nim1->nx == 0)
      {
        return EXIT_FAILURE;
      }

      if (nim1->ny == 0)
      {
        return EXIT_FAILURE;
      }
      
      if (nim1->nz == 0)
      {
        return EXIT_FAILURE;
      }
      
      nifti_image_free(nim1); 
    }
      
  }
  catch( std::exception &e )
  {
    std::cout << "An exception occurred. Number: " << e.what() << "\n";
    return EXIT_FAILURE;
  }

  return EXIT_SUCCESS;
}
