/**
 * @file  CAlgorithm.cpp
 * @brief Common utility functions used by the ODVBA implementations.
 *
http://www.cbica.upenn.edu/sbia/software/ <br>
sbia-software@uphs.upenn.edu

Copyright (c) 2015 University of Pennsylvania. All rights reserved. <br>
See COPYING file or http://www.cbica.upenn.edu/sbia/software/license.html
 */
 
#include "CAlgorithm.h"
#define FREE_ARG char*
#include "cbicaUtilities.h"

//*******************************************************************/
ublas::vector<double> NDP(ublas::matrix<double>& X, Var_matrix mat, double aa)
{
  //testing purposes only
  //itk::Image<unsigned char, 3>::Pointer test = itk::Image<unsigned char, 3>::New();
  //testing purposes only
	const double tauSqrt      = 1.0e-6; // regularization parameter << 1
	mat.A1=ublas::zero_matrix<double>(mat.n,mat.n);
  mat.A2=ublas::zero_matrix<double>(mat.n,mat.n);
  mat.meanCov1=ublas::zero_matrix<double>(mat.n,mat.n);
	for ( int j =  0; j < mat.nSmp1 ; j++ )
	{
		ublas::matrix_column<ublas::matrix<double> > (mat.intraClass1, j)=ublas::matrix_column<ublas::matrix<double> > (X, j);
	}
	 
	atlas::gemv(mat.intraClass1,mat.E1,mat.intraMean1);
	
	for ( int ii = 0 ; ii < mat.n ; ii++ )	
	{	
		for ( int jj = 0 ; jj < mat.nSmp1 ; jj++ )	
	  {  
      mat.intraClass1(ii,jj)-=mat.intraMean1(ii);	
    }	
	}	
	mat.transintraClass1=ublas::trans(mat.intraClass1);
	atlas::gemm(mat.intraClass1,mat.transintraClass1,mat.eintraCov1);

	for ( int j =mat.nSmp1 ; j < mat.nSmp1+mat.nSmp2 ; j++ )
	{
    ublas::matrix_column< ublas::matrix<double> > (mat.intraClass2, j-mat.nSmp1)=ublas::matrix_column<ublas::matrix<double> > (X, j);
	}

	atlas::gemv(mat.intraClass2,mat.E2,mat.intraMean2);
	
	for ( int ii = 0 ; ii < mat.n ; ii++ )	
	{	
		for ( int jj = 0 ; jj < mat.nSmp2 ; jj++ ) 
    {  
      mat.intraClass2(ii,jj)-=mat.intraMean2(ii);	
    }	
	}	
		
	mat.transintraClass2=ublas::trans(mat.intraClass2);
	atlas::gemm(mat.intraClass2,mat.transintraClass2,mat.eintraCov2);

	for ( int ii = 0 ; ii < mat.n ; ii++ )
  {
	  for ( int jj = 0 ; jj < mat.n ; jj++ )
		{
      mat.eintraCov1(ii,jj)+=mat.eintraCov2(ii,jj);
		}
	}

	mat.intraMean1=mat.intraMean1-mat.intraMean2;
 	atlas::ger(mat.intraMean1, mat.intraMean1, mat.meanCov1);	
 
  for (int i = 0; i < mat.n; i++) 
  {
    for (int j = 0; j < mat.n; j++)   
    {    
      mat.A_temp =mat.eintraCov1(i,j)*aa-mat.meanCov1(i,j); 	
      mat.A_rep_lapack(i, j)=  mat.A_temp;            
      mat.AA(i, j)=  mat.A_temp; 			    
    }    
  }  
  
	int N = mat.A_rep_lapack.size1();	
	int lwork = 2 * (1 + 6*N + 2*(N*N));	
	//int lwork = 8*N;	
	int liwork = 3 * (3 + 5*N);	
	// int liwork = 5*N;	
	int info = 0;	
	ublas::vector<float> work( lwork );	
	ublas::vector<int> iwork( liwork );  	
	ublas::matrix<float,ublas::column_major> eigvec(1,1);	
	ublas::vector<float> eigval(N);	
	ublas::vector<int> ifail(N);	
	//double abstol = -0.1,vl=0,vu=0;	
	float abstol = -0.1,vl=0,vu=0;	
	/* Set il, iu to compute NSELECT smallest eigenvalues */	
	int il = 1;	
	int iu = 1;//NSELECT	
	int mm = 1;	
	const char jobz = 'N';	
	const char range = 'I';	
	const char uplo = 'U';	
 	LAPACK_SSYEVX( 
    &jobz, &range, &uplo, &N,	
		static_cast<float*>(traits::matrix_storage(mat.A_rep_lapack)), &N, &vl, &vu, &il, &iu,	
		&abstol, &mm, (float *)&eigval.data()[0], (float *)&eigvec.data()[0], &N,	
		(float *)&work.data()[0], &lwork,	
		(int *)&iwork.data()[0], (int *)&ifail.data()[0], &info
  );	
    
	for (int i = 0; i < mat.n; i++) 
  {  
    mat.AA(i, i) = mat.AA(i, i)+fabs(eigval[0])+tauSqrt;  
  }  
	 
 	for ( int i = 0 ; i < mat.n ; i++ )
	{
	  mat.W(i)=1;
		for ( int j = 0 ; j < mat.n ; j++ )
		{
			mat.A_temp=mat.AA(i,j);
			if (mat.A_temp>0)
			{
				mat.A1(i,j)=mat.A_temp;
			}
			else
			{
				mat.A2(i,j)=-mat.A_temp;
			}
		}		
	}	
	
  for (int i = 0; i <15; i++ )
	{
		atlas::gemv(mat.A1,mat.W,mat.a);
		atlas::gemv(mat.A2,mat.W,mat.c);
		for ( int j = 0 ; j < mat.n ; j++ )
		{
      mat.a(j)=mat.a(j)+0.00000000000000001;
      mat.ad(j)=(mat.b(j)+pow(16*mat.a(j)*mat.c(j)+pow(mat.b(j),2),0.5))/(4*mat.a(j));
		}
		 mat.W=ublas::element_prod(mat.W,mat.ad);
  } 	
	 
	return mat.W;

}


bool writeData(ublas::matrix<double>& X, const char* name)
{
	long i,j/*,ii*/;

  FILE* pFile = fopen(name, "w"); 
  i=0;
  j=0;
  //ii=0;

 	for ( unsigned int k = 0; k < static_cast<unsigned int>(X.size1()*X.size2()); k++ )
	{
		if (j >= static_cast<long>(X.size2()))
		{
			i++;
			j=0;
			fprintf(pFile,"%s","\n");   
		}
		if(i < static_cast<long>(X.size1()))
		{
			fprintf(pFile,"%f ", X(i,j) );
			j++;
		}
	}
	fclose(pFile);
  return true;
}

bool writeimg(ublas::matrix<double>& X,const char* name)
{

	float  pForX;
 
  FILE* fp= fopen(name, "wb");

  for(unsigned int kk = 0; kk < static_cast<unsigned int>(X.size1()); kk++)
  {
    pForX = (float)X(kk,0);
    fwrite(&pForX,sizeof(float),1,fp);
  }

  fclose(fp);
  return true;
}


//read data from file named "name"
//i resume the numbers are stored in rows and columns just 
//like that in the func "writedata"
//!!causion   premise: X must have defined width & height

//!!something to do in future work: using readline to substitute 
//the loop control style
bool readData(ublas::matrix<double>& X, const char* name)
{
	long i,j,ii;

	i = 0;
	j = 0;
	ii = 0;
 
  FILE* pFile = fopen(name, "r"); 
  float* pForX=new float[X.size1()*X.size2()];
  while ( !feof(pFile) && ii!=static_cast<long>(X.size1()*X.size2()) )
  {
    fscanf( pFile, "%e ", &pForX[ii] );   
    ii++;
  }

	for ( unsigned int k = 0 ; k < static_cast<unsigned int>(X.size1()*X.size2()); k++ )
	{
		if (j >= static_cast<long>(X.size2()))
		{
			i++;
			j=0;
		}
		if(i < static_cast<long>(X.size1()))
		{
			X(i,j)=  pForX[k];
			j++;
		}
	}
	
	delete pForX;
	return true;
}
 
void createX(ublas::matrix<double> &X, ublas::matrix<double> data, ublas::matrix<double> &index)   
{   
	for ( unsigned int i = 0; i < static_cast<unsigned int>(X.size1()); i++ )
  {
    int ind=int(index(i,0))-1;
    for ( unsigned int j = 0; j < static_cast<unsigned int>(X.size2()); j++ )
    {
      X(i,j) =data(ind,j);
    }
  }
}
ublas::matrix<double> compMap(mapResults mapW,  ublas::matrix<double>& X,  Options opt, Var_matrix mat,  ExDatabase  MRIdata, ublas::matrix<double> fea,  MapParas mParas)
{
	mat.vot=ublas::zero_vector<double>(opt.nn);
  double aa=opt.g;
	ublas::vector<double> V(opt.nNeighbor);
	ublas::matrix<double> fea2(opt.nSample,opt.nNeighbor);
	mat.nSmp1 = MRIdata.n1;
	mat.nSmp2 = MRIdata.n2; 
	mat.n = opt.nNeighbor; 
	mat.m = opt.nSample;

	for ( int i = 0 ; i < opt.nn; i++)
	{ 
		if (MRIdata.NI(1,i)>0)
    {
      for ( int q = 0 ; q < opt.nSample ; q++)
      {
        for ( int p = 0 ; p < opt.nNeighbor; p++)
        {
          fea(p,q)=X(int(MRIdata.NI(p,i)-1),q);
        }	   
      }
			  
      mParas.sum11=0;
      mParas.sum22=0;
      for ( int ii = 0 ; ii <opt.nNeighbor; ii++)
      {
        for ( int j = 0 ; j < MRIdata.n1 ; j++ ) 
        {
          mParas.sum11+=fea(ii,j);
        }
        for ( int j = MRIdata.n1 ; j < MRIdata.n ; j++ ) 
        {
          mParas.sum22+=fea(ii,j);
        }
      }
			   
      if ((mParas.sum11/MRIdata.n1>mParas.sum22/MRIdata.n2)||(mParas.sum11==0))
      {
        V = ublas::zero_vector<double>(mat.n); 
        mat.weight= ublas::zero_vector<double>(mat.n);
      }
      else
      {
        V =NDP(fea,mat,aa);
        fea2=ublas::trans(fea);
        atlas::gemv(fea2,V,mat.weight);	
      }
      
      //initialization
      mParas.sum1=0;
      mParas.sum2=0;
      mParas.sw1=0;
      mParas.sw2=0;
      for ( int j = 0 ; j < MRIdata.n1 ; j++ ) 
	    {
        mParas.sum1+=mat.weight(j);
		  }
      for ( int j = MRIdata.n1 ; j < MRIdata.n ; j++ ) 
      {
        mParas.sum2+=mat.weight(j);
		  }
      mParas.me1=mParas.sum1/MRIdata.n1;
      mParas.me2=mParas.sum2/MRIdata.n2;
      if (mParas.me1>mParas.me2)
      {
        V = ublas::zero_vector<double>(mat.n);
      }
      for ( int j = 0 ; j < opt.nNeighbor ; j++)
      {
        mapW.W1(j,i)=V(j);
      }

      for ( int j = 0 ; j < MRIdata.n1 ; j++ ) 
	    {
        mParas.sw1+=pow(fabs(mat.weight(j)-mParas.me1),2);
		  }    
		  
      for ( int j = MRIdata.n1 ; j < MRIdata.n ; j++ ) 
      {
        mParas.sw2+=pow(fabs(mat.weight(j)-mParas.me2),2);
		  }    
      mParas.sw=pow(mParas.sw1+mParas.sw2,0.5);
      mParas.diff=mParas.me2-mParas.me1;	  
      mParas.delta=(mParas.diff/mParas.sw)*pow(MRIdata.n-2,0.5);
 
      if (mParas.diff>0)
      {
        if (mParas.sw!=0)
		    {
          mParas.voti=pow(mParas.delta,opt.aa);
		    }
		    else
		    {
          mParas.voti=0;
		    }
      }
      else
      {
        if (mParas.sw!=0)
        {
          mParas.voti=pow (-mParas.delta,opt.aa);
        }
        else
        {
          mParas.voti=0;
        }
      }
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//		  
      mat.vot(i)=mParas.voti;
 }
 }
	for ( int i = 0 ; i < opt.nn; i++)
	{ 
    for ( int j = 0 ; j <opt.nNeighbor; j++)
	  {
      int index=int(MRIdata.NI(j,i))-1;
      if (index>-1)
      {
        mapW.map1(index,0)=mapW.map1(index,0)+mapW.W1(j,i)*mat.vot(i);
      }
    }
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//	
	}
				 
	 //}
	return mapW.map1;
}	   

int* random(int n)   
{
  int *d =  new  int[n];    
  
  //srand( (unsigned)time( NULL ) ); 
  for( int i = 0;  i < n;i++ ) 
  { 
	  *(d+i)=rand(); 
  } 
  return d; 
  delete d; 
    
}

Var_matrix init_mat(Var_matrix matt, int n,int n1, int n2, int m,int N, int type)
{
	
	matt.vot = ublas::vector<double>(N);
	matt.intraMean1 = ublas::vector<double>(n);
	matt.intraMean2 = ublas::vector<double>(n);
	matt.a = ublas::vector<double>(n);
	matt.b = ublas::vector<double>(n);
	matt.c = ublas::vector<double>(n);
	matt.ad = ublas::vector<double>(n);
	matt.W = ublas::vector<double>(n);
	matt.weight = ublas::vector<double>(n);
	matt.E1 = ublas::vector<double>(n1);
	matt.E2 = ublas::vector<double>(n2);	
	matt.intraClass1=ublas::matrix<double> (n,n1);
	matt.transintraClass1=ublas::matrix<double>(n1,n);	
	matt.intraClass2=ublas::matrix<double> (n,n2);
	matt.transintraClass2=ublas::matrix<double>(n2,n);	
	matt.eintraCov1=ublas::matrix<double>(n,n);
	matt.eintraCov2=ublas::matrix<double>(n,n);
	matt.meanCov1=ublas::matrix<double>(n,n);
  matt.A1=ublas::matrix<double>(n,n);
	matt.A2=ublas::matrix<double>(n,n);
	matt.A_rep_lapack=ublas::matrix<float,ublas::column_major>(n,n);
	matt.AA=ublas::matrix<double,ublas::column_major>(n,n);
	matt.A_temp=0;
	
  for ( int i = 0 ; i < n1 ; i++ )
	{
    matt.E1(i)=1/double(n1);
	}
  for ( int i = 0 ; i < n2 ; i++ )
	{
		matt.E2(i)=1/double(n2);
	}
	
	for ( int j = 0 ; j < n ; j++ )
	{
	   matt.b(j)=-0.99;
	}

	return matt;

}

int* randperm(int n)
{
	int  *d =random(n);
 	int  *rep_d=  new  int[n];
	for( int i = 0;  i < n;i++ ) 
	{
    *(rep_d+i)=*(d+i);
	}
		

	sort(d,d+n);
 
	int *ind_sort =  new int[n];
	for( int i = 0;  i < n;i++ ) 
	{
    for( int j = 0;  j < n;j++ ) 
		{
      if (*(rep_d+i)==*(d+j))
      {
        *(ind_sort+j)=i+1;
      }
		}
	}
	return ind_sort;
	delete rep_d;
	delete ind_sort;
}
transferData::transferData()
{
  _DebugFlag = true;
}

transferData::~transferData()
{
}

inline void transferData::Debug(char *message)
{
  if (_DebugFlag == true) printf("\n %s \n", message);
}

void transferData :: SetInput (char *sublist, int subject_id)
{
  _file_sublist = sublist;
  _subject_id   = subject_id;
}

void transferData::GetInput()
{
  FILE *fp;
  if((fp=fopen(_file_sublist,"r"))==NULL)
  {  
    printf("\n cannot open file %s.\n",_file_sublist);  
    exit(1);  
  }  
  
  if(fscanf(fp,"%d %d",&_num_group1,&_num_group2)!=2)
  {  
    printf("\n please check file %s (num_group1).\n",_file_sublist);  
    exit(1);  
  }  

  if(fscanf(fp,"%s",_data_root_dir)!=1)
  {  
    printf("\n please check file %s.(data root)\n",_file_sublist);  
    exit(1);  
  }  
  _file_name = sub_list(_num_group1+_num_group2,1024);
 
  for(int i=0; i<_num_group1+_num_group2; i++)
  {
    for(int j=0; j<1; j++)
    {
      if(fscanf(fp,"%s", _file_name[i])!=1)
	    {
        printf("\n s:      %s",_file_name[i]);
        printf("\n please check file (file_name) %s.\n",_file_sublist);
	      exit(1);
	    }
    }
  }
  
  fclose(fp);
}

void transferData::Read_nifti_Data()
{
  this->Debug(cbica::constCharToChar(std::string("Read_Data")));
  nifti_image* nim1;
  nifti_image* nim = NULL; 
  bool ok  = true; // whether everything is fine yet
  
  char filename[1024];

  for(int i=0; i< _num_group1+_num_group2; i++)
  {
    sprintf(filename, "%s/%s",_data_root_dir,_file_name[i]);
    printf(".");
	
    if (i == 0) 
    {
      nim1 = nifti_image_read(filename, 0);      
      nim = nim1;     
      _xdim=nim1->nx;     
      _ydim=nim1->ny;     
      _zdim=nim1->nz;     
      origin_data=ublas::matrix<double>(_zdim*_ydim*_xdim,_num_group1+_num_group2);     
      printf("\n xdim:      %d",_xdim);
      printf("\n ydim:      %d",_ydim);
      printf("\n zdim:      %d",_zdim);
    } 
    else 
    {
      nim = nifti_image_read(filename, 0);
      if (!nim) 
      {
        fprintf(stderr, "Failed to open image file '%s'\n", filename);
        ok = false;
        continue;
      }
    }

    const char* mode = "rb"; // otherwise, a deprecation warning may be raised due to conversion of string constant to char*
    znzFile fp_data = nifti_image_open(filename, (char*)mode, &nim);

    if (znz_isnull(fp_data)) 
    {
      fprintf(stderr, "Failed to open data file of image '%s'\n", filename);
      ok = false;
    }
    int ioff = 0;

    if (ok) 
    {
      if (nim->iname_offset < 0) 
      {
        if (nifti_is_gzfile(nim->iname)) 
        {
          fprintf(stderr, "Invalid offset for compressed data file of image '%s'\n", filename);
          ok = false;
        } 
        else 
        {
          int ii = nifti_get_filesize(nim->iname);
          if (ii <= 0) 
          {
            fprintf(stderr, "Data file of image '%s' is empty\n", filename);
            ok = false;
          } 
          else 
          {
            int ntot = static_cast<int>(nifti_get_volsize(nim));
            ioff = ((ii > ntot) ? (ii - ntot) : 0);
          }
        }
      } 
      else 
      {
        ioff = nim->iname_offset;
      }
    }

    if (ok && znzseek(fp_data, static_cast<long>(ioff), SEEK_SET) < 0) 
    {
      fprintf(stderr, "Failed to seek to offset %u of data file of image '%s'\n",
        static_cast<unsigned int>(ioff), filename);
      ok = false;
    }
        
    // read image data
    if (nim->datatype == DT_SIGNED_SHORT) 
    {
      short tmp;
      for(int k=0; k<_zdim*_ydim*_xdim; k++)
      {
        if (nifti_read_buffer(fp_data, &tmp, sizeof(short), nim) == sizeof(short)) 
        {
          origin_data(k,i)=static_cast<double>(tmp);
        } 
        else 
        {
          fprintf (stderr, "Failed to read data of image '%s'\n", filename);
          ok = false;
        }
      }
    } 
    else if (nim->datatype == DT_FLOAT) 
    {
      float tmp;
      for(int k=0; k<_zdim*_ydim*_xdim; k++)
      {
        if (nifti_read_buffer(fp_data, &tmp, sizeof(float), nim) == sizeof(float)) 
        {
          origin_data(k,i)=static_cast<double>(tmp);
        } 
        else 
        {
          fprintf(stderr, "Failed to read data of image '%s'\n", filename);
          ok = false;
        }
      }
    } 
    else 
    {
      fprintf(stderr, "Image '%s' has unsupported voxel type. Only DT_SIGNED_SHORT and DT_FLOAT are supported.\n",filename);
      ok = false;
    }

    if (!znz_isnull(fp_data)) 
      znzclose(fp_data);

    if (nim && nim != nim1)
    {
      nifti_image_free(nim);
      nim = NULL;
    }

  }
  hdr = nifti_convert_nim2nhdr(nim1);
  if (ok) norm_data(origin_data, 100);
  nifti_image_free(nim1);
  free_sub_list(_file_name, _num_group1+_num_group2,1024);
}

bool transferData::write_nifti_img(ublas::matrix<double>& X,const char* name)
{
  const int dim[8] = {4, hdr.dim[1], hdr.dim[2], hdr.dim[3], 1, 0, 0, 0};
  // check consistency of matrix dimensions and image dimensions
  if (dim[1] * dim[2] * dim[3] < int(X.size1() * X.size2()))
  {
    fprintf(stderr, "Invalid output image dimensions\n");
    return false;
  }

  // create new image header
  nifti_1_header* hdr1 = nifti_make_new_header(dim, NIFTI_TYPE_FLOAT32);

  if (!hdr1) 
  {
    fprintf(stderr, "Failed to initialize image header\n");    
    return false;    
  }

  // default header values  
  // (write hdr/img files by default; may be overwritten according to prefix filename extension)  
  strcpy(hdr1->magic, "ni1");  
    
  // copy selected header elements  
  hdr1->dim_info    = hdr.dim_info;  
  hdr1->intent_p1   = hdr.intent_p1;  
  hdr1->intent_p2   = hdr.intent_p2;  
  hdr1->intent_p3   = hdr.intent_p3;  
  hdr1->intent_code = hdr.intent_code;  
  hdr1->pixdim[1]   = hdr.pixdim[1];  
  hdr1->pixdim[2]   = hdr.pixdim[2];  
  hdr1->pixdim[3]   = hdr.pixdim[3];  
  hdr1->xyzt_units  = hdr.xyzt_units;  
  hdr1->cal_min     = 0;  
  hdr1->cal_max     = 1;  
  memcpy(hdr1->descrip, hdr.descrip, 80);  
  hdr1->qform_code  = hdr.qform_code;  
  hdr1->sform_code  = hdr.sform_code;  
  hdr1->quatern_b   = hdr.quatern_b;  
  hdr1->quatern_c   = hdr.quatern_c;  
  hdr1->quatern_d   = hdr.quatern_d;  
  hdr1->qoffset_x   = hdr.qoffset_x;  
  hdr1->qoffset_y   = hdr.qoffset_y;  
  hdr1->qoffset_z   = hdr.qoffset_z;  
  memcpy(hdr1->srow_x, hdr.srow_x, 4);  
  memcpy(hdr1->srow_y, hdr.srow_y, 4);  
  memcpy(hdr1->srow_z, hdr.srow_z, 4);  
  memcpy(hdr1->intent_name, hdr.intent_name, 16);  
    
  // convert NIfTI-1 header to nifti_image structure  
  nifti_image* nim = nifti_convert_nhdr2nim(*hdr1, name);  
  
  free (hdr1);  
  hdr1 = NULL;  
  
  if (!nim) 
  {  
    fprintf(stderr, "Failed to create NIfTI-1 image structure\n");  
    return false;  
  }  
  
  // write image header  
  znzFile fp_data = nifti_image_write_hdr_img(nim, 2, "wb");  
  
  // write image data  
  if (znz_isnull(fp_data)) 
  {  
    fprintf(stderr, "Failed to write image data\n");    
    nifti_image_free(nim);    
    return false;    
  }  
  
  float tmp; // temporary voxel data  
  
  if (X.size2() > 1) 
  {  
    for (int j = 0; j < int(X.size2()); j++)   
    {    
      for (int i = 0; i < int(X.size1()); i++)     
      {      
        tmp = static_cast<float>(X(i,j));        
        nifti_write_buffer(fp_data, &tmp, sizeof(float));        
      }      
    }    
  } 
  else 
  {  
    for (int i = 0; i < int(X.size1()); i++)   
    {    
      tmp = static_cast<float>(X(i,0));      
      nifti_write_buffer(fp_data, &tmp, sizeof(float));      
    }    
  }  
  
  nifti_image_free(nim);  
  znzclose(fp_data);  
  return true;
}

void transferData::ReadData()
{
  this->Debug(cbica::constCharToChar(std::string("ReadData")));
  
  FILE *fp;
  short tmp;
  
  char filename[1024];
 
  origin_data=ublas::matrix<double>(_zdim*_ydim*_xdim,_num_group1+_num_group2);
 
  for(int i=0; i< _num_group1+_num_group2; i++)
  {
    sprintf(filename, "%s/%s",_data_root_dir,_file_name[i]);
    if((fp = fopen(filename, "rb"))== NULL)
    {
      printf("\n could not open file1: %s\n",filename);
      exit(1);
    }
    printf(".");

	  for(int kk=0; kk<_zdim*_ydim*_xdim; kk++)
	  {
      fread(&tmp,sizeof(short),1,fp);
      origin_data(kk,i)=tmp;
	  }	  
    fclose(fp);
  }
}

ublas::matrix<double> create_index(ublas::matrix<double> data)
{
  ublas::matrix<double> index1(data.size1(),1);  
  index1=ublas::zero_matrix<double>(data.size1(),1);  
  
  int count = 0;  
  
  for (unsigned int i = 0; i < static_cast<unsigned int>(data.size1()); i++)   
  {  
    double me = 0;    
    for (unsigned int j = 0; j < static_cast<unsigned int>(data.size2()); j++)     
    {    
      me = me + fabs(data(i,j));    
    }    
    me = me / data.size2();    
    
    if (me > 60) 
    {
      index1(i,0)=static_cast<double>(i + 1);
      count++;    
    }    
  }  
  if (count == 0)   
  {
    fprintf(stderr, "No \"non-zero\" voxels found\n");  
  }  
  
  int idx = 0;  
  
  ublas::matrix<double> index2(count, 1);  
  
  
  for (unsigned int i = 0; i < static_cast<unsigned int>(data.size1()); i++)   
  {  
    double ele = index1(i,0);    
    if (ele > 0)     
    {
      index2(idx,0)=ele;
      idx++;    
    }    
  }  
  
  return index2;  
}

ublas::matrix<double> create_ni(ublas::matrix<double> index,
                 const int dim_x, const int dim_y, const int dim_z,
                 const int ni_size_x, const int ni_size_y, const int ni_size_z,
                 const int ni_num, const int vox_num)
{
  const int m = index.size1(); // number of non-zero voxels  
  
  // check arguments  
  if (ni_size_x < 1 || ni_size_y < 1 || ni_size_z < 1) 
  {
    fprintf(stderr, "create_ni(): invalid argument for parameter 'ni_size_*'\n");  
    //return NULL;  
  }  
  
  if (ni_num < 1 || ni_num > m) 
  {  
    fprintf(stderr, "create_ni(): invalid argument for parameter 'ni_num' (0 < ni_num <= %d)\n", m);  
    //return NULL;  
  }  
  
  if (vox_num < 1 || vox_num > ((2 * ni_size_x + 1) * (2 * ni_size_y + 1) * (2 * ni_size_z + 1))) 
  {  
    fprintf(stderr, "create_ni(): invalid argument for parameter 'vox_num' (0 < vox_num < %d)\n",  
      (2 * ni_size_x + 1) * (2 * ni_size_y + 1) * (2 * ni_size_z + 1));  
     //return NULL;  
  }  
  // allocate memory  
  ublas::matrix<double> NI(vox_num,ni_num);       
  ublas::matrix<double> samples (m,1);  
  ublas::matrix<double> x_vector (m,1);  
  ublas::matrix<double> y_vector (m,1);  
  ublas::matrix<double> z_vector (m,1);  
  
  // create mapping from voxel indices to (x, y, z) coordinates  
  for (int i = 0; i < m; i++) 
  {  
    // double idx = cvGetReal1D(index, i);  
    double idx = index(i,0);  
  
    double z_temp = ceil((idx / dim_x) / dim_y);  
    double y_temp = ceil((idx - (z_temp - 1) * dim_x * dim_y) / dim_x);  
    double x_temp = idx - (z_temp - 1) * dim_x * dim_y - (y_temp - 1) * dim_x;  
  
    x_vector(i,0)=x_temp;  
    y_vector(i,0)=y_temp;  
    z_vector(i,0)=z_temp;  
  }  
  
  // randomly select ni_num voxels out of the m non-zero voxels  
  {  
    int* ra = randperm(m);  
  
    for (int i = 0; i < ni_num; i++)   
    {
      samples(i,0)=static_cast <double> (ra [i] - 1);
    }
    
    delete [] ra;  
    ra = NULL;  
  }  
  
  // for each neighborhood, randomly select vox_num voxels  
  int ni1[(2 * ni_size_x + 1) * (2 * ni_size_y + 1) * (2 * ni_size_z + 1)];  
  int ni2[vox_num];  
  
  for (int i = 0; i < ni_num; ++ i) 
  {
    int r  = static_cast<int>(samples(i,0));
    int xi = static_cast<int>(x_vector(r,0));    
    int yi = static_cast<int>(y_vector(r,0));    
    int zi = static_cast<int>(z_vector(r,0));    
    
    // determine boundaries of neighborhood    
    int minx = xi - ni_size_x;    
    if (minx < 1) 
      minx = 1;    
    
    int maxx = xi + ni_size_x;    
    if (maxx > dim_x) 
      maxx = dim_x;    
    
    int miny = yi - ni_size_y;    
    if (miny < 1) 
      miny = 1;    
    
    int maxy = yi + ni_size_y;    
    if (maxy > dim_y) 
      maxy = dim_y;    
    
    int minz = zi - ni_size_z;    
    if (minz < 1) 
      minz = 1;    
    
    int maxz = zi + ni_size_z;    
    if (maxz > dim_z) 
      maxz = dim_z;    
    
    // determine indices of all neighboring non-zero voxels    
    int current_num_ni = 0;    
    
    for (int j = 0; j < m; j++) 
    {    
      int xj = static_cast<int>(x_vector(j,0));      
      int yj = static_cast<int>(y_vector(j,0));      
      int zj = static_cast<int>(z_vector(j,0));      
      
      if ((xj < maxx + 1) && (xj > minx - 1) && 
          (yj < maxy + 1) && (yj > miny - 1) && 
          (zj < maxz + 1) && (zj > minz - 1) ) 
      {      
        ni1[current_num_ni] = j + 1;      
        current_num_ni++;      
      }      
    }    
    
    while (current_num_ni < vox_num) 
    {
      ni1[current_num_ni] = 0; // note: zero indicates an invalid index
      current_num_ni++;    
    }    
    
    // randomly select vox_num voxels of these neighboring voxels    
    {    
      int* ra = randperm(current_num_ni);      
      for (int ss = 0; ss < vox_num; ss++) 
      {
        ni2[ss] = ni1[ra[ss] - 1];      
      }      
      
      delete [] ra;      
      ra = NULL;      
    }    
    
    // set first entry to center of neighborhood    
    int flag = 0;    
    
    for (int tt = 0; tt < vox_num; tt++) 
    {
      if (ni2[tt] == r + 1) 
      {    
        int tmp = ni2[0];        
        ni2[0]  = ni2[tt];        
        ni2[tt] = tmp;        
        
        flag = 1;        
        break;
      }    
    }    
    
    if (flag == 0) ni2[0] = r + 1;    
    
    // copy neighborhood to column i of NI    
    for (int ss = 0; ss < vox_num; ss++) 
    {
      NI(ss,i)=ni2[ss];
    }
  }


  return NI;
}

char **sub_list(long x, long y)
{
  long i,nrow=x, ndep=y;
  char  **t;
  
  /* allocate pointers to pointers to  rows */
  t=(char  **) malloc((size_t)((nrow)*sizeof(char *)));

  if (!t) 
    //nrerror("allocate failure 1 in sub_list()");
    std::cerr << "allocate failure 1 in sub_list()\n";
  
  /* allocate pointers to rows and set pointers to them */
  for (i=0; i<nrow; i++)  
    t[i]=(char *) malloc((size_t)((ndep)*sizeof(char*)));
  
  return t;
}

void free_sub_list(char  **t, long x, long y)
{
  long i;
  for (i=0; i<x; i++)
    free((FREE_ARG)(t[i])); 
  free((FREE_ARG)(t));   
}

void norm_data(ublas::matrix<double> &data, const int meanValue)
{
  // calculate normalization factor  
  double orgvalue =0;  
  for (int i = 0; i < int(data.size1()) ; i++) 
  {  
      for (int j = 0; j < int(data.size2()); j++) 
      {
        orgvalue= orgvalue+data(i,j);  
      }  
  }  
  orgvalue=orgvalue/data.size1();  
  orgvalue=orgvalue/data.size2();  
  double norm = meanValue / orgvalue;  
  
  for (int i = 0; i < int(data.size1()) ; i++) 
  {
    for (int j = 0; j < int(data.size2()); j++) 
    {
      data(i,j)=norm *data(i,j);
    }
  }
}