##############################################################################
# @file  BasisProject.cmake
# @brief Meta-data of this BASIS project.
#
# This file defines project meta-data by calling the basis_project() function.
# This meta-data is used by BASIS to setup the project. Moreover, if the
# project is a module of another BASIS project, the dependencies to other
# modules have to be specified here such that the top-level project can analyze
# the inter-module dependencies.
#
# @sa http://www.rad.upenn.edu/sbia/software/basis/standard/modules/
#
# However, not only dependencies to other modules can be specified here,
# but also dependencies on external packages. A more flexible alternative to
# resolve external dependencies is to add the corresponding basis_find_package()
# statements to the Depends.cmake file. This should, however, only be done
# if specifying the dependencies as arguments to the basis_project() function
# cannot be used to resolve the dependencies properly. If you only need to
# make use of additional variables set by the package configuration file
# of the external package or the corresponding Find<Package>.cmake module,
# add the related CMake code to the Settings.cmake file instead.
#
# Example:
# @code
# basis_project (
#   # ------------------------------------------------------------------------
#   # meta-data
#   NAME             MyProject
#   PROVIDER         PackageProvider
#   VERSION          1.1.5
#   DESCRIPTION      "This is the description of the project named"
#                    " MyProject which follows BASIS."
#   AUTHOR           "Max Muster"
#   COPYRIGHT        "2012, 2013 University of Pennsylvania"
#   LICENSE          "See COPYING file."
#   CONTACT          "SBIA Group <sbia-software at uphs.upenn.edu>"
#   # ------------------------------------------------------------------------
#   # dependencies
#   DEPENDS          NiftiCLib PythonInterp
#   OPTIONAL_DEPENDS MPI
#   TEST_DEPENDS     Perl
# )
# @endcode
#
# Copyright (c) 2012, 2013 University of Pennsylvania.
#
# This file is part of DTI-DROID.
#
# DTI-DROID is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DTI-DROID is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
#
# Contact: SBIA Group <sbia-software at uphs.upenn.edu>
#
# @ingroup BasisSettings
##############################################################################

# Note: The #<*> patterns are required by the basisproject tool and should be
#       kept on a separate line as last commented argument of the corresponding
#       options of the basis_project() command.

basis_project (
  # --------------------------------------------------------------------------
  # meta-data
  NAME        DTIDROID
  PROVIDER    SBIA
  VERSION     1.1.0  # always 0.0.0 in trunk, but should be the current version in braches and tags
  DESCRIPTION "Deformable registration of diffusion tensor images using orientation"
              " and intensity descriptors."
  AUTHORS     "Jinzhong Yang"
  COPYRIGHT   "2008, 2009, 2012, 2013 University of Pennsylvania"
  LICENSE     "GNU General Public License version 3"
  CONTACT     "SBIA Group <sbia-software at uphs.upenn.edu>"
  # --------------------------------------------------------------------------
  # dependencies
  DEPENDS
    GSL
    BASH
    Perl
    PythonInterp
    PythonModules{nifti,numpy}
    #<dependency>
  OPTIONAL_DEPENDS
    #<optional-dependency>
  TEST_DEPENDS
    #<test-dependency>
  OPTIONAL_TEST_DEPENDS
    #<optional-test-dependency>
)
