/**
 * @file  xdr2hammer.cxx
 * @brief Convert HAMMER deformation field.
 *
 * Copyright (c) 2008, 2009, 2012, 2013 University of Pennsylvania.
 *
 * This file is part of DTI-DROID.
 *
 * DTI-DROID is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DTI-DROID is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DTI-DROID.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: SBIA Group <sbia-software at uphs.upenn.edu>
 */

#include <iostream>
#include <fstream>
#include <stdlib.h>

using namespace std;

int main (int argc, char ** argv) {
	if (argc < 6) {
		cerr << "Usage: " << argv[0] << " in_def_fld out_def_fld x y z" << endl;
		//                                     1           2     3 4 5
		return 1;
	}


	int x,y,z;
	x = atoi(argv[3]); y = atoi(argv[4]); z = atoi(argv[5]);
	
	float * A = new float[x*y*z*3];
	float * B = new float[x*y*z*3];

	// read in ....
	ifstream A_in(argv[1]);
	A_in.read((char *)A, x*y*z*3*sizeof(float));
	A_in.close();

	for (int k=0; k<z; k++) {
		cout << "Processing slice " << k << endl;
		for (int j=0; j<y; j++)
		for (int i=0; i<x; i++) { 
			int ii = 3*(k*x*y + j*x + i);
			B[ii+1] = -i + A[ii];
			B[ii] = -j + A[ii+1];
			B[ii+2] = -k + A[ii+2];
		}
	}

	// write out ...
	ofstream out(argv[2]);
	out.write((char *)B, x*y*z*3*sizeof(float));
	out.close();

	delete [] A;
	delete [] B;

	return 0;
}

