#!/bin/sh

if [ $# -lt 3 ]; then 
	echo
	echo "$0"
	echo 'input:  ImgA ImgB Transformed-ImgA  OtherTypeOfImgA(to be transformed by same transformation)  dof(6 for rigid transformation; 12(default) for linear)  Ax Ay Az(voxel size of ImgA; default 0.9375 0.9375 1.5)  Bx By BZ(voxel size of ImgB; default 0.9375 0.9375 0.975)  ImgSizeXY(default 256)'
	echo ''
	echo 'This program will output a file: "GlobalTransformation.Affine"'
	echo ''
	echo ''
	exit 1
fi


# Img A
ImgA="$1"
echo 'ImgA='$ImgA''

# Img B
ImgB="$2"
echo 'ImgB='$ImgB''

# transformed imageA
TransformedImgA="$3"
echo 'TransformedImgA='$TransformedImgA''

# to transform the other type of ImgA
if [ $# -gt 3 ]; then
	OtherTypeOfImgA="$4"
	echo 'OtherTypeOfImgA='$OtherTypeOfImgA''
fi 


# dof
dof="12"
if [ $# -gt 4 ]; then #greater than 4 == greater/equal 5
	dof="$5"
fi 
echo 'dof='$dof''


# parameters for image A
Ax="0.9375"
Ay="0.9375"
Az="1.5"
if [ $# -gt 5 ]; then
	Ax="$6"
	Ay="$7"
	Az="$8"
fi 
echo 'Ax='$Ax''
echo 'Ay='$Ay''
echo 'Az='$Az''

# parameters for image B
Bx="0.9375"
By="0.9375"
Bz="0.975"
if [ $# -gt 8 ]; then
	Bx="$9"
	By="${10}"
	Bz="${11}"
fi 
echo 'Bx='$Bx''
echo 'By='$By''
echo 'Bz='$Bz''

# image sizes for x and y dimensions
ImgSizeXY="256"
if [ "${12}". != . ]; then
	ImgSizeXY="${12}"
fi 
echo 'ImgSizeXY= '${ImgSizeXY}''

# interpolation type
InverT="-I"
# if [ $# -gt 11 ]; 
# then
#  InverT="${12}"
# fi 
# echo 'InverT='$InverT''


# search domain
negV="-10"
posV="+10"



echo "cp $ImgA  AAA.img"
cp $ImgA AAA.img 
#stat --format="%s" AAA.img 
SliceNo=`stat --format="%s" AAA.img `
SliceNo=`expr ${SliceNo} / ${ImgSizeXY} / ${ImgSizeXY} `  #65536
echo "makeavwheader AAA.hdr -d${ImgSizeXY},${ImgSizeXY},${SliceNo} -r$Ax,$Ay,$Az -tCHAR"
makeavwheader AAA.hdr -d${ImgSizeXY},${ImgSizeXY},${SliceNo} -r${Ax},${Ay},${Az} -tCHAR 

cp $ImgB BBB.img 
#stat --format="%s" BBB.img 
SliceNo=`stat --format="%s" BBB.img`
SliceNo=`expr ${SliceNo} / ${ImgSizeXY} / ${ImgSizeXY} `  #65536
makeavwheader BBB.hdr -d${ImgSizeXY},${ImgSizeXY},${SliceNo} -r${Bx},${By},${Bz} -tCHAR 

echo "flirt -in AAA.hdr -ref BBB.hdr -out AtoB.hdr -omat AtoB.mat -bins 256 -cost leastsq -searchrx ${negV} ${posV} -searchry ${negV} ${posV} -searchrz ${negV} ${posV} -dof ${dof} -interp nearestneighbour"
flirt -in AAA.hdr -ref BBB.hdr -out AtoB.hdr -omat AtoB.mat -bins 256 -cost leastsq -searchrx ${negV} ${posV} -searchry ${negV} ${posV} -searchrz ${negV} ${posV} -dof ${dof} -interp nearestneighbour 
fslmat2mymat AtoB.mat GlobalTransformation.Affine -r$Ay,$Ax,$Az -R$Bx,$By,$Bz 
\rm AAA.img AAA.hdr BBB.img BBB.hdr AtoB.*

# The transformed ImgA should have the slice number of ImgB
# get ImgA's slice number
ImgA_SliceNo=`stat --format="%s" $ImgA`
ImgA_SliceNo=`expr ${ImgA_SliceNo} / ${ImgSizeXY} / ${ImgSizeXY} - 1`  #65536
echo 'ImgA_SliceNo='$ImgA_SliceNo''
# get ImgB's slice number
# to see whether file ImgB exists, since 'stat --format="%s"' has bug
if [ -f $ImgB ]; then
	ImgB_SliceNo=`stat --format="%s" $ImgB`
	ImgB_SliceNo=`expr ${ImgB_SliceNo} / ${ImgSizeXY} / ${ImgSizeXY} - 1`  #65536
	echo 'ImgB_SliceNo='$ImgB_SliceNo''                  
else
	echo '*** No file '$ImgB'! ***'
	exit 1
fi
## for ImgA ##########################
if [ 1 -eq `expr $ImgA_SliceNo \<= $ImgB_SliceNo` ]; then
	echo "Crop $ImgA, then transform $ImgA"
	echo "cropslices  $ImgA AAA.Croped -c0,${ImgB_SliceNo} -v${ImgSizeXY}"
	cropslices  $ImgA AAA.Croped -c0,${ImgB_SliceNo} -v${ImgSizeXY}
	echo "transform3dimg AAA.Croped $3 GlobalTransformation.Affine $InverT -v${ImgSizeXY}"
	transform3dimg AAA.Croped "$3" GlobalTransformation.Affine $InverT -v${ImgSizeXY}
	\rm AAA.Croped
fi
if [ 1 -eq `expr $ImgA_SliceNo \> $ImgB_SliceNo` ]; then
	echo 'Transform '$ImgA', then crop '$ImgA''
	transform3dimg ${ImgA} "$3" GlobalTransformation.Affine $InverT -v${ImgSizeXY}
	cropslices  "$3" "$3"  -c0,${ImgB_SliceNo} -v${ImgSizeXY}
fi
## for same type of other ImgA ##########################
if [ $# -gt 3 ]; then
	if [ 1 -eq `expr $ImgA_SliceNo \<= $ImgB_SliceNo` ]; then
		echo 'Crop '$OtherTypeOfImgA', then transform '$OtherTypeOfImgA''
		cropslices  ${OtherTypeOfImgA} ${OtherTypeOfImgA}.Croped -c0,${ImgB_SliceNo} -v${ImgSizeXY} 
		transform3dimg ${OtherTypeOfImgA}.Croped ${OtherTypeOfImgA}.rig GlobalTransformation.Affine $InverT -v${ImgSizeXY}
		\rm ${OtherTypeOfImgA}.Croped
	fi
	if [ 1 -eq `expr $ImgA_SliceNo \> $ImgB_SliceNo` ]; then
		echo 'Transform '$OtherTypeOfImgA', then crop '$OtherTypeOfImgA''
		transform3dimg ${OtherTypeOfImgA} ${OtherTypeOfImgA}.rig GlobalTransformation.Affine $InverT -v${ImgSizeXY}
		cropslices  ${OtherTypeOfImgA}.rig ${OtherTypeOfImgA}.rig  -c0,${ImgB_SliceNo} -v${ImgSizeXY} 
	fi
fi 

exit 0

