#!/bin/bash

if [ $# -lt 2 ]; then
  echo "$0 <Sequent DT file> <Voxel DT file> <Size X> <Size Y> <Size Z>"
  echo "    <SizeX>,<SizeY>,<SizeZ>: default 256,256,128"
  exit
fi

SequentDT=$1
VoxelDT=$2
SizeX=256
SizeY=256
SizeZ=128

if [ $# -ge 5 ]; then
  SizeX=$3
  SizeY=$4
  SizeZ=$5
fi

if [ ${SequentDT##*.} == 'hdr' ]; then
  SizeX=`printavwheader ${SequentDT} | grep -Fa 'dim[1]' | cut -d\< -f2 | cut -d \> -f1 | head -1`
	SizeY=`printavwheader ${SequentDT} | grep -Fa 'dim[2]' | cut -d\< -f2 | cut -d \> -f1 | head -1`
	SizeZ=`printavwheader ${SequentDT} | grep -Fa 'dim[3]' | cut -d\< -f2 | cut -d \> -f1 | head -1`
	xres=`printavwheader ${SequentDT} | grep -Fa 'pixdim[1]' | cut -d\< -f2 | cut -d \> -f1` 
	yres=`printavwheader ${SequentDT} | grep -Fa 'pixdim[2]' | cut -d\< -f2 | cut -d \> -f1` 
  zres=`printavwheader ${SequentDT} | grep -Fa 'pixdim[3]' | cut -d\< -f2 | cut -d \> -f1`
	SequentDT=${SequentDT%.*}.dat
	makeavwheader ${VoxelDT%.*}.hdr -d6,$SizeX,$SizeY -n$SizeZ -r$xres,$yres,$zres -tFLOAT
fi

#extract files
echo extractDTImage $SequentDT _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img -d $SizeX,$SizeY,$SizeZ
extractDTImage $SequentDT _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img -d $SizeX,$SizeY,$SizeZ

#compose interleaved DT
echo createInterleavedDT  _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img $VoxelDT -d $SizeX,$SizeY
createInterleavedDT  _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img $VoxelDT -d $SizeX,$SizeY

echo rm -f _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img
rm -f _Dxx.img _Dyy.img _Dzz.img _Dxy.img _Dxz.img _Dyz.img

exit 0
