#!/bin/sh

if [ $# -lt 3 ]; then
echo ''
echo 'USAGE:' 
echo "$0 <Subj_DT_Img> <Mdl_DT_Img_With_Path> <Warped SubjDT> <DOF> <Subj SizeX> <Subj SizeY> <Subj SizeZ> <Subj ResX> <Subj ResY> <Subj ResZ> <Mdl SizeX> <Mdl SizeY> <Mdl SizeZ> <Mdl ResX> <Mdl ResY> <Mdl ResZ> <useFsl>"
echo ''
echo 'Linearly warp Subj_DT_Img to Mdl_DT_Img using the FA maps. Transformation is saved as GlobalTransform.Affine'
echo '<Subj_DT_Img>            : subject DT image, in *.dt format, in current directory.'
echo '<Mdl_DT_Img_With_Path>   : model DT image, in *.dt format, with specified folder.'
echo '<Warped SubjDT>          : warped subject DT image.'
echo '<DOF>                    : degree of freedom, 6 for rigid, 12 for affine, default 12.'
echo 'Subj SizeX, SizeY, SizeZ : Subj Image size for Subj_DT_Img in X, Y, Z dimension, default 256,256,70'
echo 'Subj ResX, ResY, ResZ    : Subj Image resolution for both image A and B, default 1,1,1.'
echo 'Mdl SizeX, SizeY, SizeZ  : Mdl Image size for Subj_DT_Img in X, Y, Z dimension, default 256,256,70'
echo 'Mdl ResX, ResY, ResZ     : Mdl Image resolution for both image A and B, default 1,1,1.'
echo 'useFsl Y or N            : should i Use fsl or Not, default to Y.'
echo ''
exit
fi


#### Input Parameters####
SubjImg=$1
MdlImg=$2
WarpedImg=$3

SubjSizeX=256
SubjSizeY=256
SubjSizeZ=70

dof=12
if [ $# -ge 4 ]; then
dof=$4
fi

if [ $# -ge 7 ]; then
SubjSizeX=$5
SubjSizeY=$6
SubjSizeZ=$7
fi

SubjVoxelX=1
SubjVoxelY=1
SubjVoxelZ=1

if [ $# -ge 10 ]; then
SubjVoxelX=$8
SubjVoxelY=$9
SubjVoxelZ=${10}
fi

MdlSizeX=256
MdlSizeY=256
MdlSizeZ=70

if [ $# -ge 13 ]; then
MdlSizeX=${11}
MdlSizeY=${12}
MdlSizeZ=${13}
fi

MdlVoxelX=1
MdlVoxelY=1
MdlVoxelZ=1

if [ $# -ge 16 ]; then
MdlVoxelX=${14}
MdlVoxelY=${15}
MdlVoxelZ=${16}
fi

useFsl=1
if [ $# -ge 17 ]; then
  if [ "${17}" = "N" ]; then
    useFsl=0
  fi
fi

################

echo dtiFA $SubjSizeX $SubjSizeY $SubjSizeZ $SubjImg _subj.temp.fa.img 0
dtiFA $SubjSizeX $SubjSizeY $SubjSizeZ $SubjImg _subj.temp.fa.img 0
echo FloatFA2Byte _subj.temp.fa.img _subj.temp.fa.img
FloatFA2Byte _subj.temp.fa.img _subj.temp.fa.img
echo extractventricle _subj.temp.fa.img _subj.temp.fa.img -x$SubjSizeX,$SubjSizeY -b 1
extractventricle _subj.temp.fa.img _subj.temp.fa.img -x$SubjSizeX,$SubjSizeY -b 1 > NoUse

echo dtiFA $MdlSizeX $MdlSizeY $MdlSizeZ $MdlImg _mdl.temp.fa.img 0
dtiFA $MdlSizeX $MdlSizeY $MdlSizeZ $MdlImg _mdl.temp.fa.img 0
echo FloatFA2Byte _mdl.temp.fa.img _mdl.temp.fa.img
FloatFA2Byte _mdl.temp.fa.img _mdl.temp.fa.img
echo extractventricle _mdl.temp.fa.img _mdl.temp.fa.img  -x$MdlSizeX,$MdlSizeY -b 1
extractventricle _mdl.temp.fa.img _mdl.temp.fa.img -x$MdlSizeX,$MdlSizeY -b 1 > NoUse


# histogram transformation
#echo LinuxMatchHistogramsOfImgA2ImgB _subj.temp.fa.img _mdl.temp.fa.img _subj.temp.fa.histo -a$SubjSizeX,$SubjSizeY -b$MdlSizeX,$MdlSizeY -s2.5
#LinuxMatchHistogramsOfImgA2ImgB _subj.temp.fa.img _mdl.temp.fa.img _subj.temp.fa.histo -a$SubjSizeX,$SubjSizeY -b$MdlSizeX,$MdlSizeY -s2.5 > NoUse


# affine transformation: for upsample MdlFile
#echo LinuxRigidTransformImgA2ImgB_AnySize _subj.temp.fa.histo _mdl.temp.fa.img _subj.temp.fa.rig -x $MdlSizeX,$MdlSizeY
#LinuxRigidTransformImgA2ImgB_AnySize _subj.temp.fa.histo _mdl.temp.fa.img _subj.temp.fa.rig -x $MdlSizeX,$MdlSizeY

if [ $useFsl = 1 ]; then
  echo linearlyregisterbyfsl.sh _subj.temp.fa.img _mdl.temp.fa.img _subj.temp.fa.rig _subj.temp.fa.img $dof $SubjVoxelX $SubjVoxelY $SubjVoxelZ $MdlVoxelX $MdlVoxelY $MdlVoxelZ $MdlSizeX
  linearlyregisterbyfsl.sh _subj.temp.fa.img _mdl.temp.fa.img _subj.temp.fa.rig _subj.temp.fa.img $dof $SubjVoxelX $SubjVoxelY $SubjVoxelZ $MdlVoxelX $MdlVoxelY $MdlVoxelZ $MdlSizeX

  \rm -f _subj.temp.fa.img
  \rm -f _mdl.temp.fa.img
  \rm -f _subj.temp.fa.rig
  \rm -f _subj.temp.fa.img.rig
else
  echo makeavwheader _subj.temp.fa.hdr -d$SubjSizeX,$SubjSizeY,$SubjSizeZ -r$SubjVoxelX,$SubjVoxelY,$SubjVoxelZ -tCHAR
  makeavwheader _subj.temp.fa.hdr -d$SubjSizeX,$SubjSizeY,$SubjSizeZ -r$SubjVoxelX,$SubjVoxelY,$SubjVoxelZ -tCHAR
  echo makeavwheader _mdl.temp.fa.hdr -d$MdlSizeX,$MdlSizeY,$MdlSizeZ -r$MdlVoxelX,$MdlVoxelY,$MdlVoxelZ -tCHAR
  makeavwheader _mdl.temp.fa.hdr -d$MdlSizeX,$MdlSizeY,$MdlSizeZ -r$MdlVoxelX,$MdlVoxelY,$MdlVoxelZ -tCHAR
  echo rigidtransform _subj.temp.fa.img _mdl.temp.fa.img _subj.temp.fa.rig GlobalTransformation.Affine -X $MdlSizeX
  rigidtransform _subj.temp.fa.img _mdl.temp.fa.img _subj.temp.fa.rig GlobalTransformation.Affine -X $MdlSizeX
  #echo fslmat2mymat affine GlobalTransformation.Affine -r$MdlVoxelX,$MdlVoxelY,$MdlVoxelZ -R$SubjVoxelX,$SubjVoxelY,$SubjVoxelZ 
  #fslmat2mymat affine GlobalTransformation.Affine -r$MdlVoxelX,$MdlVoxelY,$MdlVoxelZ -R$SubjVoxelX,$SubjVoxelY,$SubjVoxelZ 

  \rm -f _mdl.temp.fa.hdr
  \rm -f _subj.temp.fa.hdr
  \rm -f _subj.temp.fa.img
  \rm -f _mdl.temp.fa.img
  #\rm -f _subj.temp.fa.rig.hdr
  #\rm -f _subj.temp.fa.rig.img
  \rm -f _subj.temp.fa.rig
  #\rm -f affine
fi

###### Warp DT images #####
echo LnWarpDT $SubjImg GlobalTransform.Affine -O $WarpedImg -X $SubjSizeX -Z $SubjSizeZ -R $SubjVoxelX,$SubjVoxelY,$SubjVoxelZ
LnWarpDT $SubjImg GlobalTransformation.Affine -O $WarpedImg -X $SubjSizeX -Z $SubjSizeZ -R $SubjVoxelX,$SubjVoxelY,$SubjVoxelZ > NoUse

\rm -f NoUse
