/*
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania
*/

#include  "matrix.h"
#include "mex.h"
#include "math.h"

#include <iostream>
#include <ctime>
#include <cstdlib>

using namespace std;


double grpNorm(double *x,double *g,double *val, double *grpVals,int numGrp,unsigned long int n)
{
   unsigned long int cnt = 0 ;
   *val = 0 ;
   double GrpMembers[numGrp] ;

   //cout << "before filling group members" << endl ;
   for (cnt=0;cnt<numGrp;cnt++)
   {
      GrpMembers[cnt] = 0 ;
   }    


   //cout << "before computing group values" << endl ;
   for (cnt=0;cnt<n;cnt++)
   {
      unsigned long int index = (unsigned long int)g[cnt] ;
      grpVals[index-1] = grpVals[index-1] + x[cnt]*x[cnt] ;    // group index starts from one
      GrpMembers[index-1] = GrpMembers[index-1] + 1 ;  
   }

  //cout << "before computing actual norm" << endl ;
  for (cnt=0;cnt<numGrp;cnt++)
  {
      grpVals[cnt] = sqrt(1.0/GrpMembers[cnt]*grpVals[cnt]) ;
      *val = *val +  grpVals[cnt] ;
  }
   
}

// This function should be called as follows:
//       [val, grpVals] = grpNorm(x,G)
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[])
{
    if(nrhs!=2)
        mexErrMsgTxt("two inputs are required.");
    if(nlhs!=2)
        mexErrMsgTxt("two output is required.");
    
    //cout << "function just started    ----------------" << endl ;
    //assign inputs
    double  *x ;
    double  *g ;
    double  *val ;
    double  *grpVals ;
    unsigned long int n = (unsigned long int)( mxGetM(prhs[0])) ;
    unsigned long int m = (unsigned long int)( mxGetM(prhs[1])) ;
    if (n!=m )
    {    mexErrMsgTxt("the x vector and group vector should have the same size!");}

    //cout << "n : " << n << ", m : " << m << endl ;
    if ((mxGetClassID(prhs[0])!=mxDOUBLE_CLASS) || (mxGetClassID(prhs[1])!=mxDOUBLE_CLASS))
    {  
          mexErrMsgTxt("both inputs must be double, other types are not supported !!! ") ;
    }

    x = mxGetPr(prhs[0]) ;
    g = mxGetPr(prhs[1]) ;
   
    // compute the group norm 
    int numGrp = 0 ;
    //cout << "before for loop--------------" << endl ;
    for (unsigned long int cnt=0; cnt<n ;cnt++)
    {
     //  cout << g[cnt] << endl ;
        if (numGrp< g[cnt])
        {
          numGrp++ ;
        }
    }
    //cout << "after zeroing out group, numGroups:" << numGrp << endl ;
    // allocate memory for output
    plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);
    plhs[1] = mxCreateDoubleMatrix(numGrp,1, mxREAL);
    val =  mxGetPr(plhs[0]) ;
    grpVals =  mxGetPr(plhs[1]) ;
    //cout << "before calling function " << endl ;
    grpNorm(x,g,val,grpVals,numGrp,n) ;
    
    
}

