% This function read the config file into MATLAB
%
%       Written by  Kayhan  Batmanghelich
%                   March 2012
%                   Section of Biomedical Image Analysis (SBIA)
%                   University of Pennsylvania


function parameters=readConfigFile(fileName, delimiters, commentStyle)

%set of delimiters
if (nargin==1)
    delimiters='=';
    commentStyle='//';
elseif (nargin==2)
    commentStyle='//';
end

%read the shit

%open file
fid = fopen(fileName);

%check existence
if (fid == -1)
    error(['Probleeeeeem: ' fileName ' not found or worse!']);
end


%open
fileContent = textscan(fid, '%s%s', ...
                'delimiter', delimiters, ...
                'commentStyle', commentStyle);

%%%%%%%%%%%%%%%%%%
% parsing

%for all lines
for lineNum=1:length(fileContent{1})      
    %split line
    argName = strtrim(fileContent{1}{lineNum});
    
    %check if argname exists and deactivate if so 
    
    argString = fileContent{2}{lineNum};
    
    %check parameter type
    [argNumber,ok]=str2num(argString) ;
    
    if(ok)
        %number
        parameters.(argName) = argNumber ;
    else
        %string
        if strcmpi(strtrim(argString),'true') 
            parameters.(argName) = true ;
        elseif strcmpi(strtrim(argString),'false')
            parameters.(argName) = false ;
        else
            parameters.(argName) = argString ;
        end
                
    end

end  

%close file    
fclose(fid);


