///////////////////////////////////////////////////////////////////////////////////////
// CBICAMedicalImageAnalysisTool.cpp
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////

#include "fMainWindow.h"
#include "CBICA_Viewer.h"
//#include <QtPlugin>
//#include <QtSvg>

//Q_IMPORT_PLUGIN(QSvg)

#ifdef _WIN32
// ensures no console pops up when launching the program
int CALLBACK WinMain(HINSTANCE hInstance, HINSTANCE prevInstance, LPSTR lpCmdLine, int nShowCmd)
{
  int argc = __argc;
  char **argv = __argv;
#else
int main(int argc, char** argv)
{
#endif
  if (argc > 1) 
  {
    if (strcmp(argv[1], "-rt") == 0 || strcmp(argv[1], "--run_test") == 0) 
    {
      // a FAR more meaningful test series needs to be added
      exit(EXIT_SUCCESS);
    }
    else
    {
      std::cerr << "This program has a graphical interface. Please don't try to use any command line parameters.\n";
      return EXIT_FAILURE;
    }
  }

	QApplication app(argc, argv);

#ifndef _WIN32
	std::string old_locale = setlocale(LC_NUMERIC, NULL);
	setlocale(LC_NUMERIC, "POSIX");
#endif

#if defined(_WIN32) || defined(_WIN64) || defined(__APPLE__)
#else
	QFont AppFont = app.font();
	AppFont.setPointSize(8);
	app.setFont(AppFont);
#endif

	fMainWindow window;

	int runningmode = RUNNING_MODE_NORMAL;
	if (runningmode == RUNNING_MODE_NORMAL)
	{
		window.showMaximized();
		window.show();
	}
	else
	{
		window.RunInClusterMode();
	}
	int ret = app.exec();
#ifndef _WIN32
	setlocale(LC_NUMERIC, old_locale.c_str());
#endif

	return ret;
}

