#include "itkListSample.h"
#include "EGFRStatusPredictor.h"
#include "vnl_cholesky.h"
#include "itkCSVNumericObjectFileWriter.h"
#include "itkCovarianceSampleFilter.h"
#include "itkMeanSampleFilter.h"

EGFRStatusPredictor::EGFRStatusPredictor()
{
}
EGFRStatusPredictor::~EGFRStatusPredictor()
{
}
void EGFRStatusPredictor::CalculateAveragePerfusionSignal(VectorVectorDouble PerfusionIntensities, std::vector<double> &avgSignal)
{
  for (unsigned int index = 0; index < PerfusionIntensities[0].size(); index++)
  {
    double temp = 0.0;
    for (unsigned int samples = 0; samples < PerfusionIntensities.size(); samples++)
      temp = temp + PerfusionIntensities[samples][index];
    avgSignal.push_back(temp / PerfusionIntensities.size());
  }
}

double EGFRStatusPredictor::CalculateMaximumDrop(std::vector<double> avgSignal)
{
  double temp = 0.0;
  double mean = 0.0;
  for (int index = 0; index < 10; index++)
    temp = temp + avgSignal[index];
  mean = temp / 10;

  double min = avgSignal[0];
  for (unsigned int index = 1; index < avgSignal.size(); index++)
    if (avgSignal[index] < min)
      min = avgSignal[index];

  return (mean - min);
}


void EGFRStatusPredictor::CalculateQualifiedIndices(VectorVectorDouble &rpNearIntensities, VectorVectorDouble &rpFarIntensities,double & percentageNear, double & percentageFar)
{
  VectorVectorDouble revisedNearIntensities;
  VectorVectorDouble revisedFarIntensities;

  double originalNear = rpNearIntensities.size();
  double originalFar = rpFarIntensities.size();

  for (unsigned int index = 0; index < rpNearIntensities.size(); index++)
  {
    double mNearMean = 0.0;
    double mNearStd = 0.0;
    double temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpNearIntensities[index].size(); featureNo++)
      temp = temp + rpNearIntensities[index][featureNo];
    mNearMean = temp / rpNearIntensities[index].size();

    temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpNearIntensities[index].size(); featureNo++)
      temp = temp + (rpNearIntensities[index][featureNo] - mNearMean)*(rpNearIntensities[index][featureNo] - mNearMean);
    mNearStd = std::sqrt(temp / (rpNearIntensities[index].size() - 1));
    if (mNearStd != 0)
      revisedNearIntensities.push_back(rpNearIntensities[index]);
  }
  for (unsigned int index = 0; index < rpFarIntensities.size(); index++)
  {
    double mFarMean = 0.0;
    double mFarStd = 0.0;
    double temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpFarIntensities[index].size(); featureNo++)
      temp = temp + rpFarIntensities[index][featureNo];
    mFarMean = temp / rpFarIntensities[index].size();

    temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpFarIntensities[index].size(); featureNo++)
      temp = temp + (rpFarIntensities[index][featureNo] - mFarMean)*(rpFarIntensities[index][featureNo] - mFarMean);
    mFarStd = std::sqrt(temp / (rpFarIntensities[index].size() - 1));
    if (mFarStd != 0)
      revisedFarIntensities.push_back(rpFarIntensities[index]);
  }
  rpNearIntensities.clear();
  rpFarIntensities.clear();
  rpNearIntensities = revisedNearIntensities;
  rpFarIntensities = revisedFarIntensities;

  percentageNear = (revisedNearIntensities.size() * 100) / originalNear;
  percentageFar = (revisedFarIntensities.size() * 100) / originalFar;
}

void EGFRStatusPredictor::CalculateQualifiedIndicesForSaving(VectorVectorDouble &rpNearIntensities, VectorVectorDouble &rpFarIntensities, std::vector<double> & revisedNearIndices, std::vector<double> & revisedFarIndices)
{
  VectorVectorDouble revisedNearIntensities;
  VectorVectorDouble revisedFarIntensities;

  //double originalNear = rpNearIntensities.size();
  //double originalFar = rpFarIntensities.size();

  for (unsigned int index = 0; index < rpNearIntensities.size(); index++)
  {
    double mNearMean = 0.0;
    double mNearStd = 0.0;
    double temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpNearIntensities[index].size(); featureNo++)
      temp = temp + rpNearIntensities[index][featureNo];
    mNearMean = temp / rpNearIntensities[index].size();

    temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpNearIntensities[index].size(); featureNo++)
      temp = temp + (rpNearIntensities[index][featureNo] - mNearMean)*(rpNearIntensities[index][featureNo] - mNearMean);
    mNearStd = std::sqrt(temp / (rpNearIntensities[index].size() - 1));
    if (mNearStd != 0)
    {
      revisedNearIntensities.push_back(rpNearIntensities[index]);
      revisedNearIndices.push_back(index);
    }

  }
  for (unsigned int index = 0; index < rpFarIntensities.size(); index++)
  {
    double mFarMean = 0.0;
    double mFarStd = 0.0;
    double temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpFarIntensities[index].size(); featureNo++)
      temp = temp + rpFarIntensities[index][featureNo];
    mFarMean = temp / rpFarIntensities[index].size();

    temp = 0.0;
    for (unsigned int featureNo = 0; featureNo < rpFarIntensities[index].size(); featureNo++)
      temp = temp + (rpFarIntensities[index][featureNo] - mFarMean)*(rpFarIntensities[index][featureNo] - mFarMean);
    mFarStd = std::sqrt(temp / (rpFarIntensities[index].size() - 1));
    if (mFarStd != 0)
    {
      revisedFarIntensities.push_back(rpFarIntensities[index]);
      revisedFarIndices.push_back(index);
    }
  }
  rpNearIntensities.clear();
  rpFarIntensities.clear();
  rpNearIntensities = revisedNearIntensities;
  rpFarIntensities = revisedFarIntensities;

}


VariableSizeMatrixType EGFRStatusPredictor::GetSumOfTwoMatrice(VariableSizeMatrixType &matrix1, VariableSizeMatrixType &matrix2)
{
	VariableSizeMatrixType outputMatrix;
	outputMatrix.SetSize(matrix1.Rows(), matrix1.Cols());
	for (unsigned int i = 0; i < matrix1.Rows(); i++)
		for (unsigned int j = 0; j < matrix1.Cols(); j++)
			outputMatrix(i, j) = (matrix1(i, j) + matrix2(i, j))/2;
	return outputMatrix;
}
VariableSizeMatrixType EGFRStatusPredictor::MatrixTranspose(VariableSizeMatrixType &inputmatrix)
{
	VariableSizeMatrixType output;
	output.SetSize(inputmatrix.Cols(), inputmatrix.Rows());

	for (unsigned int i = 0; i < output.Rows(); i++)
		for (unsigned int j = 0; j < output.Cols(); j++)
			output(i, j) = inputmatrix(j, i);
	return output;
}
VariableSizeMatrixType EGFRStatusPredictor::GetCovarianceMatrix(VectorVectorDouble &inputData)
{
	int NumberOfSamples = inputData.size();
	const unsigned int MeasurementVectorLength = EGFR_PCS;
	typedef itk::Vector< double, MeasurementVectorLength > MeasurementVectorType;
	typedef itk::Statistics::ListSample< MeasurementVectorType > SampleType;
	SampleType::Pointer sample = SampleType::New();
	sample->SetMeasurementVectorSize(MeasurementVectorLength);

	for (int i = 0; i < NumberOfSamples; i++)
	{
		MeasurementVectorType mv;
		mv[0] = inputData[i][0];
		mv[1] = inputData[i][1];
		mv[2] = inputData[i][2];
		sample->PushBack(mv);
	}

	typedef itk::Statistics::CovarianceSampleFilter< SampleType >CovarianceAlgorithmType;
	CovarianceAlgorithmType::Pointer covarianceAlgorithm = CovarianceAlgorithmType::New();
	covarianceAlgorithm->SetInput(sample);
	covarianceAlgorithm->Update();

	VariableSizeMatrixType CovMatrix = covarianceAlgorithm->GetCovarianceMatrix();
	
	return CovMatrix;
}
VariableSizeMatrixType EGFRStatusPredictor::GetCholeskyFactorization(VariableSizeMatrixType &inputData)
{
	inputData[0][1] = 0;
	inputData[0][2] = 0;
	inputData[1][2] = 0;

	inputData[0][0] = std::sqrt(inputData[0][0]);
	inputData[1][0] = inputData[1][0] / inputData[0][0];
	inputData[2][0] = inputData[2][0] / inputData[0][0];

	inputData[1][1] = inputData[1][1] - inputData[1][0] * inputData[1][0];
	inputData[2][1] = inputData[1][2] - inputData[1][0] * inputData[2][0];
	inputData[2][2] = inputData[2][2] - inputData[2][0] * inputData[2][0];

	inputData[1][1] = std::sqrt(inputData[1][1]);
	inputData[2][1] = inputData[2][1] / inputData[1][1];

	inputData[2][2] = std::sqrt(inputData[2][2] - inputData[2][1]);

	return inputData;
}
double EGFRStatusPredictor::CalculateBhattaCharyaCoefficient(VectorVectorDouble &rpNearIntensities, VectorVectorDouble &rpFarIntensities)
{
	double bDistance = 0;
	try
	{
		VariableLengthVectorType nMeanVector;
		VariableLengthVectorType fMeanVector;
		nMeanVector.SetSize(EGFR_PCS);
		fMeanVector.SetSize(EGFR_PCS);

		for (int featureNo = 0; featureNo < EGFR_PCS; featureNo++)
		{
			double temp = 0.0;
			for (unsigned int sampleNo = 0; sampleNo < rpNearIntensities.size(); sampleNo++)
				temp = temp + rpNearIntensities[sampleNo][featureNo];
			nMeanVector[featureNo] = temp / rpNearIntensities.size();

			temp = 0.0;
			for (unsigned int sampleNo = 0; sampleNo < rpFarIntensities.size(); sampleNo++)
				temp = temp + rpFarIntensities[sampleNo][featureNo];
			fMeanVector[featureNo] = temp / rpFarIntensities.size();
		}
		VariableSizeMatrixType nCovMatrix = GetCovarianceMatrix(rpNearIntensities);
		VariableSizeMatrixType fCovMatrix = GetCovarianceMatrix(rpFarIntensities);

		VariableSizeMatrixType sumCovariance = GetSumOfTwoMatrice(nCovMatrix, fCovMatrix);

		VariableSizeMatrixType meanDifference;
		meanDifference.SetSize(1, nMeanVector.Size());
		for (unsigned int i = 0; i < nMeanVector.Size(); i++)
			meanDifference[0][i] = nMeanVector[i] - fMeanVector[i];


		//-------------vnl matrices------------------------
		vnl_matrix<double> covarianceMatrix;
		covarianceMatrix.set_size(3, 3);
		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 3; j++)
				covarianceMatrix(i, j) = sumCovariance(i, j);
		vnl_matrix<double> covMatrix1;
		vnl_matrix<double> covMatrix2;
		covMatrix1.set_size(3, 3);
		covMatrix2.set_size(3, 3);
		for (int i = 0; i < 3; i++)
			for (int j = 0; j < 3; j++)
			{
				covMatrix1(i, j) = nCovMatrix(i, j);
				covMatrix2(i, j) = fCovMatrix(i, j);
			}
		vnl_cholesky covObj(covarianceMatrix);
		vnl_matrix<double> inverse = covObj.inverse();
		vnl_cholesky covObj1(covMatrix1);
		vnl_cholesky covObj2(covMatrix2);


		//-------------------------------------
		//typedef vnl_matrix<double> MatrixType;
		//MatrixType data;
		//data.set_size(4, 3);
		//for (int i = 0; i < rpNearIntensities.size(); i++)
		//	for (int j = 0; j < rpNearIntensities[0].size(); j++)
		//		data(i, j) = rpNearIntensities[i][j];
		//typedef itk::CSVNumericObjectFileWriter<double, 4, 3> WriterType1;
		//WriterType1::Pointer writer = WriterType1::New();
		//writer->SetFileName("nData.csv");
		//writer->SetInput(&data);
		//writer->Write();
		//for (int i = 0; i < rpFarIntensities.size(); i++)
		//	for (int j = 0; j < rpFarIntensities[0].size(); j++)
		//		data(i, j) = rpFarIntensities[i][j];
		//writer->SetFileName("fData.csv");
		//writer->SetInput(&data);
		//writer->Write();


		//data.set_size(3, 3);
		//for (int i = 0; i < nCovMatrix.Rows(); i++)
		//	for (int j = 0; j < nCovMatrix.Cols(); j++)
		//		data(i, j) = covMatrix1(i, j);
		//typedef itk::CSVNumericObjectFileWriter<double, 3, 3> WriterType2;
		//WriterType2::Pointer writer2 = WriterType2::New();
		//writer2->SetFileName("nCov.csv");
		//writer2->SetInput(&data);
		//writer2->Write();
		//for (int i = 0; i < fCovMatrix.Rows(); i++)
		//	for (int j = 0; j < fCovMatrix.Cols(); j++)
		//		data(i, j) = covMatrix2(i, j);
		//writer2->SetFileName("fCov.csv");
		//writer2->SetInput(&data);
		//writer2->Write();
		//for (int i = 0; i < fCovMatrix.Rows(); i++)
		//	for (int j = 0; j < fCovMatrix.Cols(); j++)
		//		data(i, j) = sumCovariance(i, j);
		//writer2->SetFileName("sumCov.csv");
		//writer2->SetInput(&data);
		//writer2->Write();
		//for (int i = 0; i < fCovMatrix.Rows(); i++)
		//	for (int j = 0; j < fCovMatrix.Cols(); j++)
		//		data(i, j) = inverse(i, j);
		//writer2->SetFileName("inverse.csv");
		//writer2->SetInput(&data);
		//writer2->Write();

		//data.set_size(1, 3);
		//for (int i = 0; i < 3; i++)
		//		data(0,i) = meanDifference[0][i];
		//typedef itk::CSVNumericObjectFileWriter<double, 1, 3> WriterType3;
		//WriterType3::Pointer writer3 = WriterType3::New();
		//writer3->SetFileName("meanDifference.csv");
		//writer3->SetInput(&data);
		//writer3->Write();

		//-----------------------------------------
		if (inverse.rows() == 0)
			bDistance = 0;
		else
		{

			std::vector<double> tempmatrix;
			tempmatrix.push_back(meanDifference[0][0] * inverse[0][0] + meanDifference[0][1] * inverse[1][0] + meanDifference[0][2] * inverse[2][0]);
			tempmatrix.push_back(meanDifference[0][0] * inverse[0][1] + meanDifference[0][1] * inverse[1][1] + meanDifference[0][2] * inverse[2][1]);
			tempmatrix.push_back(meanDifference[0][0] * inverse[0][2] + meanDifference[0][1] * inverse[1][2] + meanDifference[0][2] * inverse[2][2]);
			double firstfactor = (tempmatrix[0] * meanDifference[0][0] + tempmatrix[1] * meanDifference[0][1] + tempmatrix[2] * meanDifference[0][2]) / 8;
			double secondfactor = std::log(covObj.determinant() / std::sqrt(covObj1.determinant()*covObj2.determinant())) / 2;
			bDistance = firstfactor + secondfactor;
		}
	}
	catch (itk::ExceptionObject & excp)
  {
    bDistance = 0;
    std::cerr << "Exception detected while trying to Calculate Bhattacharya Coefficient:\n" << excp.what() << "\n";
    exit(EXIT_FAILURE);
	}
	return bDistance;
}

//itk::Image<float, 4>::Pointer EGFRStatusPredictor::Read4DNiftiImage(std::string filename)
//{
//	itk::Image<float, 4>::Pointer image;
//	itk::ImageIOBase::Pointer reader = itk::ImageIOFactory::CreateImageIO(filename.c_str(), itk::ImageIOFactory::ReadMode);
//	if (!reader)
//	{
//		/*	mLastError = "Unable to read file.";
//		return false;*/
//	}
//	reader->SetFileName(filename);
//	reader->ReadImageInformation();
//	std::string InputPixelType = reader->GetComponentTypeAsString(reader->GetComponentType());
//	unsigned int VImageDimension = reader->GetNumberOfDimensions();
//	image = ReadImageWithDim<float, 4>(filename, InputPixelType);
//	return image;
//}


