#ifndef _EGFRStatusPredictor_h_
#define _EGFRStatusPredictor_h_

#include "CBICA_Viewer.h"
#include "FeatureReductionClass.h"
#include "fProgressDialog.h"

class EGFRStatusPredictor
{
public:
	EGFRStatusPredictor();
	~EGFRStatusPredictor();

	template<class ImageType, class PerfusionImageType>
	std::vector<double> PredictEGFRStatus(typename PerfusionImageType::Pointer perfImagePointerNifti, std::vector<typename ImageType::Pointer> &perfImagePointerDicom,
		std::vector<typename ImageType::IndexType> &nearIndices, std::vector<typename ImageType::IndexType> &farIndices, int imagetype);
	
	template<class ImageType, class PerfusionImageType>
	void LoadPerfusionData(typename PerfusionImageType::Pointer perfImagePointerNifti,  std::vector<typename ImageType::Pointer> &perfImagePointerDicom,
		 std::vector<typename ImageType::IndexType> &nearIndices,  std::vector<typename ImageType::IndexType> &farIndices,
		 VectorVectorDouble & pNearIntensities, VectorVectorDouble & pFarIntensities, int imagetype);

  void CalculateQualifiedIndices(VectorVectorDouble &rpNearIntensities, VectorVectorDouble &rpFarIntensities, double & percentageNear, double & percentageFar);
  void CalculateQualifiedIndicesForSaving(VectorVectorDouble &rpNearIntensities, VectorVectorDouble &rpFarIntensities, std::vector<double> & revisedNearIndices, std::vector<double> & revisedFarIndices);

  void CalculateAveragePerfusionSignal(VectorVectorDouble PerfusionIntensities, std::vector<double> &avgSignal);
  double CalculateMaximumDrop(std::vector<double> avgSignal);

  double CalculateBhattaCharyaCoefficient(VectorVectorDouble &rpNearIntensities, VectorVectorDouble &rpFarIntensities);
  VariableSizeMatrixType MatrixTranspose(VariableSizeMatrixType &inputmatrix);
	VariableSizeMatrixType GetCovarianceMatrix(VectorVectorDouble &inputData);
	VariableSizeMatrixType GetCholeskyFactorization(VariableSizeMatrixType &inputData);
	VariableSizeMatrixType GetSumOfTwoMatrice(VariableSizeMatrixType &matrix1, VariableSizeMatrixType &matrix2);
};



template<class ImageType, class PerfusionImageType>
std::vector<double> EGFRStatusPredictor::PredictEGFRStatus(typename PerfusionImageType::Pointer perfImagePointerNifti, std::vector<typename ImageType::Pointer> &perfImagePointerDicom, std::vector<typename ImageType::IndexType> &nearIndices, std::vector<typename ImageType::IndexType> &farIndices, int imagetype)
{
  std::vector<double> EGFRStatusParams;
  EGFRStatusParams.push_back(0);
  EGFRStatusParams.push_back(0);
  EGFRStatusParams.push_back(0);
  EGFRStatusParams.push_back(0);
  EGFRStatusParams.push_back(0);

	VectorVectorDouble pNearIntensities;
	VectorVectorDouble pFarIntensities;
  std::vector<double> avgNearSignal;
  std::vector<double> avgFarSignal;
	
	fProgressDialog progress("EGFRvIII Status Prediction", 1);
	progress.SetProgress(0, 100);
	qApp->processEvents();

	//qSleep(5000);
	progress.SetProgress(10, 100);
	qApp->processEvents();

	//qSleep(5000);

	LoadPerfusionData<ImageType,PerfusionImageType>(perfImagePointerNifti, perfImagePointerDicom, nearIndices, farIndices, pNearIntensities, pFarIntensities, imagetype);
  double nearPercentage = 0;
  double farPercentage = 0;
  CalculateQualifiedIndices(pNearIntensities, pFarIntensities, nearPercentage,farPercentage);

  if (pNearIntensities.size() == 0 || pFarIntensities.size() == 0)
    return EGFRStatusParams;

  CalculateAveragePerfusionSignal(pNearIntensities, avgNearSignal);
  CalculateAveragePerfusionSignal(pFarIntensities, avgFarSignal);

  double maxNearDrop = CalculateMaximumDrop(avgNearSignal);
  double maxFarDrop = CalculateMaximumDrop(avgFarSignal);
  

	progress.SetProgress(20, 100);
	qApp->processEvents();
	//qSleep(5000);
	progress.SetProgress(30, 100);
	qApp->processEvents();
	//typedef vnl_matrix<double> MatrixType;
	//MatrixType data;
	//data.set_size(4,45);
	//for (int i = 0; i < pNearIntensities.size(); i++)
	//	for (int j = 0; j < pNearIntensities[0].size(); j++)
	//		data(i, j) = pNearIntensities[i][j];
	//typedef itk::CSVNumericObjectFileWriter<double, 4, 45> WriterType1;
	//WriterType1::Pointer writer = WriterType1::New();
	//writer->SetFileName("nData.csv");
	//writer->SetInput(&data);
	//writer->Write();
	//for (int i = 0; i < pFarIntensities.size(); i++)
	//	for (int j = 0; j < pFarIntensities[0].size(); j++)
	//		data(i, j) = pFarIntensities[i][j];
	//writer->SetFileName("fData.csv");
	//writer->SetInput(&data);
	//writer->Write();

	FeatureReductionClass * obj = new FeatureReductionClass();
	vtkSmartPointer<vtkTable> rpNear = obj->GetDiscerningPerfusionTimePoints(pNearIntensities);
	vtkSmartPointer<vtkTable> rpFar = obj->GetDiscerningPerfusionTimePoints(pFarIntensities);
	//qSleep(5000); 
	progress.SetProgress(40, 100);
	qApp->processEvents();
	//qSleep(5000);
	progress.SetProgress(50, 100);
	qApp->processEvents();


	VectorVectorDouble rpNearIntensities;
VectorVectorDouble rpFarIntensities;

	for (unsigned int i = 0; i < nearIndices.size(); i++)
	{
		std::vector<double> oneSubjectPCs;
		for (int j = 0; j < EGFR_PCS; j++)
			oneSubjectPCs.push_back(rpNear->GetValue(i, j).ToDouble());
		rpNearIntensities.push_back(oneSubjectPCs);
	}
	//qSleep(5000);
	progress.SetProgress(60, 100);
	qApp->processEvents();
	//qSleep(5000);
	progress.SetProgress(70, 100);
	qApp->processEvents();

	for (unsigned int i = 0; i < farIndices.size(); i++)
	{
		std::vector<double> oneSubjectPCs;
		for (int j = 0; j < EGFR_PCS; j++)
			oneSubjectPCs.push_back(rpFar->GetValue(i, j).ToDouble());
		rpFarIntensities.push_back(oneSubjectPCs);
	}
	//qSleep(5000);
	progress.SetProgress(80, 100);
	qApp->processEvents();
	//qSleep(5000);
	progress.SetProgress(90, 100);
	qApp->processEvents();
	//qSleep(5000);

	double bDistance = CalculateBhattaCharyaCoefficient(rpNearIntensities, rpFarIntensities);
	progress.SetProgress(100, 100);
	qApp->processEvents();
  EGFRStatusParams[0] = bDistance;
  EGFRStatusParams[1] = maxNearDrop;
  EGFRStatusParams[2] = maxFarDrop;
  EGFRStatusParams[3] = pNearIntensities.size();
  EGFRStatusParams[4] = pFarIntensities.size();
	
  return EGFRStatusParams;
}


template<class ImageType,class PerfusionImageType>
void EGFRStatusPredictor::LoadPerfusionData(typename PerfusionImageType::Pointer perfImagePointerNifti,  std::vector<typename ImageType::Pointer> &perfImagePointerDicom,
	 std::vector<typename ImageType::IndexType> &nearIndices,  std::vector<typename ImageType::IndexType> &farIndices,
	 VectorVectorDouble & pNearIntensities, VectorVectorDouble & pFarIntensities, int imagetype)
{
	/*int a = 0;
	int b = 0;
	int c = 0;
	int d = 0;*/

	//typedef itk::Image<float, 4> PerfusionImageType;
	FILE* p;
	p = fopen("p.txt", "w");
	for (unsigned int i = 0; i < nearIndices.size();i++)
		{
			std::vector<double> perfusionIntensitiesPerVoxel;

			if (imagetype == IMAGE_NIFTI)
			{
				typename PerfusionImageType::IndexType perfVoxelIndex;
				perfVoxelIndex[0] = nearIndices[i][0];
				perfVoxelIndex[1] = nearIndices[i][1];
				perfVoxelIndex[2] = nearIndices[i][2];
				for (int j = 0; j < 45; j++)
				{
					perfVoxelIndex[3] = j;
					perfusionIntensitiesPerVoxel.push_back(
            static_cast<double>(
              std::round(perfImagePointerNifti.GetPointer()->GetPixel(perfVoxelIndex))
            )
          );
				}
				//a = perfVoxelIndex[0];
				//b = perfVoxelIndex[1];
				//c = perfVoxelIndex[2];
				//d = perfVoxelIndex[3];

			}
			else
			{
				//a = nearIndices[i][0];
				//b = nearIndices[i][1];
				//c = nearIndices[i][2];
				//d = 0;
				for (int j = 0; j < 45; j++)
					perfusionIntensitiesPerVoxel.push_back(
            static_cast<double>(
              std::round(perfImagePointerDicom[j].GetPointer()->GetPixel(nearIndices[i]))
            )
          );
			}

			//fprintf(p, "%d %d %d %d ---- %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f \n", a,b,c,d, std::round(perfusionIntensitiesPerVoxel[0]), std::round(perfusionIntensitiesPerVoxel[1]), std::round(perfusionIntensitiesPerVoxel[2]),
			//	std::round(perfusionIntensitiesPerVoxel[3]), std::round(perfusionIntensitiesPerVoxel[4]), std::round(perfusionIntensitiesPerVoxel[5]),
			//	std::round(perfusionIntensitiesPerVoxel[6]), std::round(perfusionIntensitiesPerVoxel[7]), std::round(perfusionIntensitiesPerVoxel[8]), std::round(perfusionIntensitiesPerVoxel[9]), std::round(perfusionIntensitiesPerVoxel[10]),
			//	std::round(perfusionIntensitiesPerVoxel[11]), std::round(perfusionIntensitiesPerVoxel[12]), std::round(perfusionIntensitiesPerVoxel[13]), std::round(perfusionIntensitiesPerVoxel[14]), std::round(perfusionIntensitiesPerVoxel[15]),
			//	std::round(perfusionIntensitiesPerVoxel[16]), std::round(perfusionIntensitiesPerVoxel[17]), std::round(perfusionIntensitiesPerVoxel[18]), std::round(perfusionIntensitiesPerVoxel[19]), std::round(perfusionIntensitiesPerVoxel[20]),
			//	std::round(perfusionIntensitiesPerVoxel[21]), std::round(perfusionIntensitiesPerVoxel[22]), std::round(perfusionIntensitiesPerVoxel[23]), std::round(perfusionIntensitiesPerVoxel[24]), std::round(perfusionIntensitiesPerVoxel[25]),
			//	std::round(perfusionIntensitiesPerVoxel[26]), std::round(perfusionIntensitiesPerVoxel[27]), std::round(perfusionIntensitiesPerVoxel[28]), std::round(perfusionIntensitiesPerVoxel[29]), std::round(perfusionIntensitiesPerVoxel[30]),
			//	std::round(perfusionIntensitiesPerVoxel[31]), std::round(perfusionIntensitiesPerVoxel[32]), std::round(perfusionIntensitiesPerVoxel[33]), std::round(perfusionIntensitiesPerVoxel[34]), std::round(perfusionIntensitiesPerVoxel[35]),
			//	std::round(perfusionIntensitiesPerVoxel[36]), std::round(perfusionIntensitiesPerVoxel[37]), std::round(perfusionIntensitiesPerVoxel[38]), std::round(perfusionIntensitiesPerVoxel[39]), std::round(perfusionIntensitiesPerVoxel[40]),
			//	std::round(perfusionIntensitiesPerVoxel[41]), std::round(perfusionIntensitiesPerVoxel[42]), std::round(perfusionIntensitiesPerVoxel[43]), std::round(perfusionIntensitiesPerVoxel[44]));
			//
			pNearIntensities.push_back(perfusionIntensitiesPerVoxel);
		}
	for (unsigned int i = 0; i < farIndices.size(); i++)
	{
		std::vector<double> perfusionIntensitiesPerVoxel;

		if (imagetype == IMAGE_NIFTI)
		{
			typename PerfusionImageType::IndexType perfVoxelIndex;
			perfVoxelIndex[0] = farIndices[i][0];
			perfVoxelIndex[1] = farIndices[i][1];
			perfVoxelIndex[2] = farIndices[i][2];

			for (int j = 0; j < 45; j++)
			{
				perfVoxelIndex[3] = j;
				perfusionIntensitiesPerVoxel.push_back(
          static_cast<double>(
            std::round(perfImagePointerNifti.GetPointer()->GetPixel(perfVoxelIndex))
          )
        );
			}
			//a = perfVoxelIndex[0];
			//b = perfVoxelIndex[1];
			//c = perfVoxelIndex[2];
			//d = perfVoxelIndex[3];
		}
		else
		{
			for (int j = 0; j < 45; j++)
				perfusionIntensitiesPerVoxel.push_back(
          static_cast<double>(
            std::round(perfImagePointerDicom[j].GetPointer()->GetPixel(farIndices[i]))
          )
        );
			//a = farIndices[i][0];
			//b = farIndices[i][1];
			//c = farIndices[i][2];
			//d = 0;
		}
		//fprintf(p, "%d %d %d %d ---- %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f \n", a,b,c,d, std::round(perfusionIntensitiesPerVoxel[0]), std::round(perfusionIntensitiesPerVoxel[1]), std::round(perfusionIntensitiesPerVoxel[2]),
		//	std::round(perfusionIntensitiesPerVoxel[3]), std::round(perfusionIntensitiesPerVoxel[4]), std::round(perfusionIntensitiesPerVoxel[5]),
		//	std::round(perfusionIntensitiesPerVoxel[6]), std::round(perfusionIntensitiesPerVoxel[7]), std::round(perfusionIntensitiesPerVoxel[8]), std::round(perfusionIntensitiesPerVoxel[9]), std::round(perfusionIntensitiesPerVoxel[10]),
		//	std::round(perfusionIntensitiesPerVoxel[11]), std::round(perfusionIntensitiesPerVoxel[12]), std::round(perfusionIntensitiesPerVoxel[13]), std::round(perfusionIntensitiesPerVoxel[14]), std::round(perfusionIntensitiesPerVoxel[15]),
		//	std::round(perfusionIntensitiesPerVoxel[16]), std::round(perfusionIntensitiesPerVoxel[17]), std::round(perfusionIntensitiesPerVoxel[18]), std::round(perfusionIntensitiesPerVoxel[19]), std::round(perfusionIntensitiesPerVoxel[20]),
		//	std::round(perfusionIntensitiesPerVoxel[21]), std::round(perfusionIntensitiesPerVoxel[22]), std::round(perfusionIntensitiesPerVoxel[23]), std::round(perfusionIntensitiesPerVoxel[24]), std::round(perfusionIntensitiesPerVoxel[25]),
		//	std::round(perfusionIntensitiesPerVoxel[26]), std::round(perfusionIntensitiesPerVoxel[27]), std::round(perfusionIntensitiesPerVoxel[28]), std::round(perfusionIntensitiesPerVoxel[29]), std::round(perfusionIntensitiesPerVoxel[30]),
		//	std::round(perfusionIntensitiesPerVoxel[31]), std::round(perfusionIntensitiesPerVoxel[32]), std::round(perfusionIntensitiesPerVoxel[33]), std::round(perfusionIntensitiesPerVoxel[34]), std::round(perfusionIntensitiesPerVoxel[35]),
		//	std::round(perfusionIntensitiesPerVoxel[36]), std::round(perfusionIntensitiesPerVoxel[37]), std::round(perfusionIntensitiesPerVoxel[38]), std::round(perfusionIntensitiesPerVoxel[39]), std::round(perfusionIntensitiesPerVoxel[40]),
		//	std::round(perfusionIntensitiesPerVoxel[41]), std::round(perfusionIntensitiesPerVoxel[42]), std::round(perfusionIntensitiesPerVoxel[43]), std::round(perfusionIntensitiesPerVoxel[44]));


		pFarIntensities.push_back(perfusionIntensitiesPerVoxel);
	}
	fclose(p);
}

#endif
