///////////////////////////////////////////////////////////////////////////////////////
// GeodesicSegmentation.h
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////

#include "iostream"
#include "vtkImageData.h"
#include "itkImage.h"
#include "itkConnectedThresholdImageFilter.h"
#include "itkImageRegionIterator.h"
#include "itkBSplineControlPointImageFilter.h"
#include "itkExpImageFilter.h"
#include "itkImageRegionIterator.h"
#include "itkOtsuThresholdImageFilter.h"
#include "itkShrinkImageFilter.h"
#include "itkMedianImageFunction.h"
#include "itkNeighborhoodIterator.h"
#include "fProgressDialog.h"

#include "PreprocessingPipelineClass.h"

class  GeodesicSegmentation
{

public:
	GeodesicSegmentation();
	~GeodesicSegmentation();

	template<class ImageTypeGeodesic>
	typename ImageTypeGeodesic::Pointer GeodesicSegmentation3D(typename ImageTypeGeodesic::Pointer Inp, VectorVectorDouble &tumorPoints);

};

template<class ImageTypeGeodesic>
typename ImageTypeGeodesic::Pointer GeodesicSegmentation::GeodesicSegmentation3D(typename ImageTypeGeodesic::Pointer Inp, VectorVectorDouble &points)
{
	//--------------copy a few images ------------------------
	fProgressDialog progress("Geodesic Segmentation", 1);
	progress.SetProgress(0, 100);
	qApp->processEvents();


	typename ImageTypeGeodesic::Pointer Init = ImageTypeGeodesic::New();
	Init->CopyInformation(Inp);
	Init->SetRequestedRegion(Inp->GetLargestPossibleRegion());
	Init->SetBufferedRegion(Inp->GetBufferedRegion());
	Init->Allocate();
	Init->FillBuffer(0);

	typename ImageTypeGeodesic::Pointer Geos = ImageTypeGeodesic::New();
	Geos->CopyInformation(Inp);
	Geos->SetRequestedRegion(Inp->GetLargestPossibleRegion());
	Geos->SetBufferedRegion(Inp->GetBufferedRegion());
	Geos->Allocate();
	Geos->FillBuffer(0);

	typename ImageTypeGeodesic::Pointer Gamma = ImageTypeGeodesic::New();
	Gamma->CopyInformation(Inp);
	Gamma->SetRequestedRegion(Inp->GetLargestPossibleRegion());
	Gamma->SetBufferedRegion(Inp->GetBufferedRegion());
	Gamma->Allocate();
	Gamma->FillBuffer(0);

	typename ImageTypeGeodesic::Pointer tumorMask = ImageTypeGeodesic::New();
	tumorMask->CopyInformation(Inp);
	tumorMask->SetRequestedRegion(Inp->GetLargestPossibleRegion());
	tumorMask->SetBufferedRegion(Inp->GetBufferedRegion());
	tumorMask->Allocate();
	tumorMask->FillBuffer(0);

	progress.SetProgress(10,100);
	qApp->processEvents();


	//---------------calculation of initial mask--------------------------
	typedef itk::ImageRegionIteratorWithIndex <ImageTypeGeodesic> IteratorType;
	IteratorType InitIt(Init, Init->GetLargestPossibleRegion());
	InitIt.GoToBegin();
	while (!InitIt.IsAtEnd())
	{
		InitIt.Set(0.0);
		++InitIt;
	}
	progress.SetProgress(20, 100);
	qApp->processEvents();
	for (unsigned int i = 0; i < points.size(); i++)
	{
		typename ImageTypeGeodesic::IndexType index;
		index[0] = points[i][0];
		index[1] = points[i][1];
		index[2] = points[i][2];
		Init->SetPixel(index, 255);
	}
	progress.SetProgress(30, 100);
	qApp->processEvents();

	//---------------------------actual geodesic segmentation--------------------------
	typedef itk::ImageRegionIteratorWithIndex <ImageTypeGeodesic> IteratorType;
	IteratorType InpIt(Inp, Inp->GetLargestPossibleRegion());
	IteratorType InitIt2(Init, Init->GetLargestPossibleRegion());
	IteratorType GeosIt(Geos, Geos->GetLargestPossibleRegion());
	IteratorType GamIt(Gamma, Gamma->GetLargestPossibleRegion());
	//Geodesic code goes here Initialize gamma to fixed value - can be changed in the future to incorporate priors
	GamIt.GoToBegin();
	while (!GamIt.IsAtEnd())
	{
		GamIt.Set(1.0);
		++GamIt;
	}
	progress.SetProgress(40, 100);
	qApp->processEvents();
	//Set initial infinities
	GeosIt.GoToBegin();
	InitIt2.GoToBegin();
	while (!GeosIt.IsAtEnd())
	{
		if (InitIt2.Get() == 255)
		{
			GeosIt.Set(static_cast<typename ImageTypeGeodesic::PixelType>(MAX_VAL));
		}

		++GeosIt;
		++InitIt2;
	}
	progress.SetProgress(50, 100);
	qApp->processEvents();


	//Setting up the neighborhood iterator
	typename ImageTypeGeodesic::SizeType radius;
	radius[0] = 1;
	radius[1] = 1;
	radius[2] = 1;
	itk::NeighborhoodIterator<ImageTypeGeodesic> ResNIt(radius, Geos, Geos->GetLargestPossibleRegion());
	itk::NeighborhoodIterator<ImageTypeGeodesic> InpNIt(radius, Inp, Inp->GetLargestPossibleRegion());

	//The main loops
	std::cout << "Main loops execution: Forward pass" << std::endl;
	ResNIt.GoToBegin();
	InpNIt.GoToBegin();
	GamIt.GoToBegin();
	InpIt.GoToBegin();
	GeosIt.GoToBegin();
	InitIt.GoToBegin();
	while (!InpIt.IsAtEnd())
	{
		double C_f_arr[14];
		C_f_arr[13] = GeosIt.Get();
		C_f_arr[0] = ResNIt.GetPixel(4) + sqrt(1.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(4))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(4))));
		C_f_arr[1] = ResNIt.GetPixel(10) + sqrt(1.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(10))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(10))));
		C_f_arr[2] = ResNIt.GetPixel(12) + sqrt(1.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(12))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(12))));
		C_f_arr[3] = ResNIt.GetPixel(1) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(1))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(1))));
		C_f_arr[4] = ResNIt.GetPixel(3) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(3))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(3))));
		C_f_arr[5] = ResNIt.GetPixel(9) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(9))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(9))));
		C_f_arr[6] = ResNIt.GetPixel(0) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(0))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(0))));
		C_f_arr[7] = ResNIt.GetPixel(7) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(7))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(7))));
		C_f_arr[8] = ResNIt.GetPixel(6) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(6))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(6))));
		C_f_arr[9] = ResNIt.GetPixel(15) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(15))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(15))));
		C_f_arr[10] = ResNIt.GetPixel(24) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(24))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(24))));
		C_f_arr[11] = ResNIt.GetPixel(21) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(21))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(21))));
		C_f_arr[12] = ResNIt.GetPixel(18) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(18))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(18))));
		//std::cout<<InpNIt.GetPixel(13);
		double minval = 20000000;
		for (int i = 0; i<14; ++i)
		{
			if (C_f_arr[i]<minval)
				minval = C_f_arr[i];
		}
		//if(minval>0)
		//{std::cout<<minval<<std::endl;}
		//std::cout<<GeosIt.GetIndex()<<std::endl;
		GeosIt.Set(minval);
		++InpIt;
		++GeosIt;
		++ResNIt;
		++InpNIt;
		++GamIt;
	}
	progress.SetProgress(70, 100);
	qApp->processEvents();
	
	InpIt.GoToReverseBegin();
	GeosIt.GoToReverseBegin();
	GamIt.GoToReverseBegin();
	ResNIt.GoToEnd();
	--ResNIt;
	InpNIt.GoToEnd();
	--InpNIt;
	std::cout << "Main loops execution: Backward pass" << std::endl;
	while (!InpIt.IsAtReverseEnd())
	{
		double C_b_arr[14];
		C_b_arr[13] = GeosIt.Get();
		C_b_arr[0] = ResNIt.GetPixel(22) + sqrt(1.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(22))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(22))));
		C_b_arr[1] = ResNIt.GetPixel(16) + sqrt(1.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(16))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(16))));
		C_b_arr[2] = ResNIt.GetPixel(14) + sqrt(1.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(14))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(14))));
		C_b_arr[3] = ResNIt.GetPixel(25) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(25))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(25))));
		C_b_arr[4] = ResNIt.GetPixel(23) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(23))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(23))));
		C_b_arr[5] = ResNIt.GetPixel(17) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(17))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(17))));
		C_b_arr[6] = ResNIt.GetPixel(26) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(26))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(26))));
		C_b_arr[7] = ResNIt.GetPixel(19) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(19))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(19))));
		C_b_arr[8] = ResNIt.GetPixel(20) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(20))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(20))));
		C_b_arr[9] = ResNIt.GetPixel(11) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(11))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(11))));
		C_b_arr[10] = ResNIt.GetPixel(2) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(2))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(2))));
		C_b_arr[11] = ResNIt.GetPixel(5) + sqrt(2.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(5))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(5))));
		C_b_arr[12] = ResNIt.GetPixel(8) + sqrt(3.0 + GamIt.Get()*((InpNIt.GetPixel(13) - InpNIt.GetPixel(8))*(InpNIt.GetPixel(13) - InpNIt.GetPixel(8))));
		double minval = 20000000;
		for (int i = 0; i<14; ++i)
		{
			if (C_b_arr[i]<minval)
				minval = C_b_arr[i];
		}
		//std::cout<<minval;
		GeosIt.Set(minval);
		--InpIt;
		--GeosIt;
		--ResNIt;
		--InpNIt;
		--GamIt;
	}
	progress.SetProgress(80, 100);
	qApp->processEvents();
	for (GeosIt.GoToBegin(); !GeosIt.IsAtEnd(); ++GeosIt)
	{
		if (GeosIt.Get() >= MAX_VAL)
		{
			GeosIt.Set(0);
		}
	}
	progress.SetProgress(90, 100);
	qApp->processEvents();
	//------------------------------geodesic thresholding-----------------------------
	typedef itk::MinimumMaximumImageCalculator <ImageTypeGeodesic> ImageCalculatorFilterType;
	typename ImageCalculatorFilterType::Pointer imageCalculatorFilter = ImageCalculatorFilterType::New();
	imageCalculatorFilter->SetImage(Geos);
	imageCalculatorFilter->Compute();
	double minValue = imageCalculatorFilter->GetMinimum();
	double lowerLimit = minValue - 100;
	double upperLimit = minValue + 100;

	typedef itk::ImageRegionIteratorWithIndex <ImageTypeGeodesic> IteratorType;
	IteratorType GeosIt2(Geos, Geos->GetLargestPossibleRegion());
	IteratorType MaskIt(tumorMask, tumorMask->GetLargestPossibleRegion());
	MaskIt.GoToBegin();
	GeosIt2.GoToBegin();

	while (!MaskIt.IsAtEnd())
	{
		if (GeosIt2.Get() >= lowerLimit && GeosIt2.Get() <= upperLimit)
			MaskIt.Set(175.0);
		else
			MaskIt.Set(0.0);
		++MaskIt;
		++GeosIt2;
	}
	progress.SetProgress(100, 100);
	qApp->processEvents();

	return tumorMask;
}
