#include "RecurrenceEstimator.h"
#include "fMainWindow.h"



RecurrenceEstimator::~RecurrenceEstimator()
{
}
void RecurrenceEstimator::LoadQualifiedSubjectsFromGivenDirectory(std::string type, std::string directoryname, bool useT1Data, bool useT1CEData, bool useT2Data, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData,
	std::vector<std::string> & qualifiedSubjectNames,
	std::vector<std::string> & t1FileNames,
	std::vector<std::string> & t1ceFileNames,
	std::vector<std::string> & t2FileNames,
	std::vector<std::string> & t2FlairFileNames,
	std::vector<std::string> & axFileNames,
	std::vector<std::string> & faFileNames,
	std::vector<std::string> & radFileNames,
	std::vector<std::string> & trFileNames,
	std::vector<std::string> & perfFileNames,
	std::vector<std::string> & labelNames,
	std::vector<std::string> & nearFileNames,
	std::vector<std::string> & farFileNames,
	std::vector<std::string> & rejectedSubjectNames)
{
  std::vector<std::string> subjectNames = cbica::subdirectoriesInDirectory(directoryname);
	mLastEncounteredError = "";

	for (unsigned int sid = 0; sid < subjectNames.size(); sid++)
	{
		std::string subjectPath = directoryname + "/" + subjectNames[sid];

		std::string t1ceFilePath = "";
		std::string t1FilePath = "";
		std::string t2FilePath = "";
		std::string t2FlairFilePath = "";
		std::string axFilePath = "";
		std::string faFilePath = "";
		std::string radFilePath = "";
		std::string trFilePath = "";
		std::string perfFilePath = "";
		std::string labelPath = "";
		std::string nearFilePath = "";
		std::string farFilePath = "";
    
    std::vector<std::string> files;

    if (cbica::directoryExists(subjectPath + "/DRAWING"))
    {
      files = cbica::filesInDirectory(subjectPath + "/DRAWING");
      for (unsigned int i = 0; i < files.size(); i++)
      {
        std::string filePath = subjectPath + "/DRAWING" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);
        if ((files[i].find("near") != std::string::npos || files[i].find("Infiltrated") != std::string::npos) && (extension == IMG_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
          nearFilePath = subjectPath + "/DRAWING" + "/" + files[i];

        if ((files[i].find("far") != std::string::npos || files[i].find("Pure") != std::string::npos) && (extension == IMG_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
          farFilePath = subjectPath + "/DRAWING" + "/" + files[i];
      }
    }

    if (cbica::directoryExists(subjectPath + "/SEGMENTATION"))
    {
      files = cbica::filesInDirectory(subjectPath + "/SEGMENTATION");
      for (unsigned int i = 0; i < files.size(); i++)
      {
        std::string filePath = subjectPath + "/SEGMENTATION" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);
        if ((files[i].find("label-map") != std::string::npos || files[i].find("label") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
          labelPath = subjectPath + "/SEGMENTATION" + "/" + files[i];
      }
    }

    if (useT1CEData && cbica::directoryExists(subjectPath + "/T1CE"))
		{
			files = cbica::filesInDirectory(subjectPath + "/T1CE");
			for (unsigned int i = 0; i < files.size(); i++)
			{
        std::string filePath = subjectPath + "/T1CE" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);
				if ((files[i].find("t1ce") != std::string::npos || files[i].find("T1CE") != std::string::npos || files[i].find("t1-ce") != std::string::npos || files[i].find("T1-CE") != std::string::npos || files[i].find("t1c") != std::string::npos || files[i].find("T1C") != std::string::npos || files[i].find("T1c") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT|| extension == NII_GZ_EXT))
					t1ceFilePath = subjectPath + "/T1CE" + "/" + files[i];
			}
		}

    if (useT1Data && cbica::directoryExists(subjectPath + "/T1"))
		{
			files = cbica::filesInDirectory(subjectPath + "/T1");
			for (unsigned int i = 0; i < files.size(); i++)
			{
        std::string filePath = subjectPath + "/T1CE" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);
        if ((files[i].find("t1") != std::string::npos || files[i].find("T1") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					t1FilePath = subjectPath + "/T1" + "/" + files[i];
			}
		}

    if (useT2Data && cbica::directoryExists(subjectPath + "/T2"))
		{
			files = cbica::filesInDirectory(subjectPath + "/T2");
			for (unsigned int i = 0; i < files.size(); i++)
			{
        std::string filePath = subjectPath + "/T2" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);
        if ((files[i].find("t2") != std::string::npos || files[i].find("T2") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					t2FilePath = subjectPath + "/T2" + "/" + files[i];
			}
		}

    if (useT2FlairData && cbica::directoryExists(subjectPath + "/FLAIR"))
		{
			files = cbica::filesInDirectory(subjectPath + "/FLAIR");
			for (unsigned int i = 0; i < files.size(); i++)
			{
        std::string filePath = subjectPath + "/FLAIR" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);
        if ((files[i].find("Flair") != std::string::npos || files[i].find("flair") != std::string::npos || files[i].find("FLAIR") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					t2FlairFilePath = subjectPath + "/FLAIR" + "/" + files[i];
			}
		}

    if (usePerfData && cbica::directoryExists(subjectPath + "/PERFUSION"))
		{
			files = cbica::filesInDirectory(subjectPath + "/PERFUSION");
			for (unsigned int i = 0; i < files.size(); i++)
			{
        std::string filePath = subjectPath + "/PERFUSION" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);
        if ((files[i].find("Perf") != std::string::npos || files[i].find("perf") != std::string::npos || files[i].find("PERFUSION") != std::string::npos || files[i].find("perfusion") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					perfFilePath = subjectPath + "/PERFUSION" + "/" + files[i];
			}
		}

    if (useDTIData && cbica::directoryExists(subjectPath + "/DTI"))
		{
			files = cbica::filesInDirectory(subjectPath + "/DTI");
			for (unsigned int i = 0; i < files.size(); i++)
			{
        std::string filePath = subjectPath + "/DTI" + "/" + files[i];
        std::string extension = cbica::getFilenameExtension(filePath);

        if ((files[i].find("AXIAL") != std::string::npos || files[i].find("Axial") != std::string::npos || files[i].find("axial") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					axFilePath = subjectPath + "/DTI" + "/" + files[i];
        else if ((files[i].find("FRACTIONAL") != std::string::npos || files[i].find("Fractional") != std::string::npos || files[i].find("fractional") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					faFilePath = subjectPath + "/DTI" + "/" + files[i];
        else if ((files[i].find("RADIAL") != std::string::npos || files[i].find("Radial") != std::string::npos || files[i].find("radial") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					radFilePath = subjectPath + "/DTI" + "/" + files[i];
        else if ((files[i].find("TRACE") != std::string::npos || files[i].find("Trace") != std::string::npos || files[i].find("trace") != std::string::npos) && (extension == HDR_EXT || extension == NII_EXT || extension == NII_GZ_EXT))
					trFilePath = subjectPath + "/DTI" + "/" + files[i];
			}
		}

		if (labelPath == "")
		{
			rejectedSubjectNames.push_back(subjectNames[sid]);
			continue;
		}
		if ((useT1Data && t1FilePath == "") || (useT2Data && t2FilePath == "") || (useT1CEData && t1ceFilePath == "") || (useT2FlairData && t2FlairFilePath == "") ||
			(usePerfData && perfFilePath == "") || (useDTIData && axFilePath == "") || (useDTIData && faFilePath == "") || (useDTIData && radFilePath == "") || (useDTIData && trFilePath == ""))
		{
			rejectedSubjectNames.push_back(subjectNames[sid]);
			continue;
		}
		if ((nearFilePath == "" || farFilePath == "") && type == "training")
		{
			rejectedSubjectNames.push_back(subjectNames[sid]);
			continue;
		}
		t1ceFileNames.push_back(t1ceFilePath);
		t1FileNames.push_back(t1FilePath);
		t2FileNames.push_back(t2FilePath);
		t2FlairFileNames.push_back(t2FlairFilePath);
		axFileNames.push_back(axFilePath);
		faFileNames.push_back(faFilePath);
		radFileNames.push_back(radFilePath);
		trFileNames.push_back(trFilePath);
		perfFileNames.push_back(perfFilePath);
		labelNames.push_back(labelPath);
		nearFileNames.push_back(nearFilePath);
		farFileNames.push_back(farFilePath);
		qualifiedSubjectNames.push_back(subjectNames[sid]);
	}

}

itk::Image<float, 3>::Pointer RecurrenceEstimator::RescaleImageIntensity(itk::Image<float, 3>::Pointer image)
{
	typedef itk::Image<float, 3> ImageType;
	typedef itk::RescaleIntensityImageFilter< ImageType, ImageType > RescaleFilterType;
	RescaleFilterType::Pointer rescaleFilter = RescaleFilterType::New();
	rescaleFilter->SetInput(image);
	rescaleFilter->SetOutputMinimum(0);
	rescaleFilter->SetOutputMaximum(255);
	rescaleFilter->Update();
	ImageType::Pointer outputimage = rescaleFilter->GetOutput();
	return outputimage;
}


void RecurrenceEstimator::TrainNewModelOnGivenData(std::string directoryname, std::string outputdirectory, bool useT1Data, bool useT1CEData, bool useT2Data, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData)
{
	mOutputLocalPtr->SetOutputDirectoryPath(outputdirectory);
	bool useOtherModalities = false;
	if (useT1CEData || useDTIData || useT1Data || useT2Data || useT2FlairData)
		useOtherModalities = true;

	std::vector<std::string> t1ceFileNames;
	std::vector<std::string> t1FileNames;
	std::vector<std::string> t2FileNames;
	std::vector<std::string> t2FlairFileNames;
	std::vector<std::string> axFileNames;
	std::vector<std::string> faFileNames;
	std::vector<std::string> radFileNames;
	std::vector<std::string> trFileNames;
	std::vector<std::string> perfFileNames;
	std::vector<std::string> labelNames;
	std::vector<std::string> nearFileNames;
	std::vector<std::string> farFileNames;
	std::vector<std::string> rejectedSubjectNames;
	std::vector<std::string> qualifiedSubjectNames;
	LoadQualifiedSubjectsFromGivenDirectory("training", directoryname, useT1Data, useT1CEData, useT2Data, useT2FlairData, useDTIData, usePerfData, useDistData,
		qualifiedSubjectNames, t1FileNames, t1ceFileNames, t2FileNames, t2FlairFileNames, axFileNames, faFileNames, radFileNames, trFileNames, perfFileNames, labelNames, nearFileNames, farFileNames, rejectedSubjectNames);

	std::vector<std::string> vector;
	VectorVectorDouble mNearIntensities;
	VectorVectorDouble mFarIntensities;
	std::vector<double> tNearIntensities;
	std::vector<double> tFarIntensities;
	VectorVectorDouble pNearIntensities;
	VectorVectorDouble pFarIntensities;
	VectorVectorDouble perfusionIntensities;
	VectorVectorDouble otherIntensities;
	std::vector<double> distanceIntensities;


	//std::string subjectPath = directoryname + "/" + subjectNames[sid];
	//std::string dataFolder = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/";
	//std::string t2flairPath = dataFolder + subjectNames[sid].substr(0, subjectNames[sid].length() - 1) + "/" + subjectNames[sid] + "_flair_sus_n3_r_strip.img";
	//std::string t1cePath = dataFolder + subjectNames[sid].substr(0, subjectNames[sid].length() - 1) + "/" + subjectNames[sid] + "_t1ce_sus_n3_strip.img";
	//std::string t1Path = dataFolder + subjectNames[sid].substr(0, subjectNames[sid].length() - 1) + "/" + subjectNames[sid] + "_t1_sus_n3_r_strip.img";
	//std::string t2Path = dataFolder + subjectNames[sid].substr(0, subjectNames[sid].length() - 1) + "/" + subjectNames[sid] + "_t2_sus_n3_r_strip.img";
	//std::string perfPath = "Z:/brain_tumor/human_3T/Recurrence_study/perfusion/perfusion_21/T0/4D/" + subjectNames[sid] + "_perf_4D_r_strip.nii.gz";

	//std::string axPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_AX_to_t1ce_str.nii.gz";
	//std::string faPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_FA_to_t1ce_str.nii.gz";
	//std::string radPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_RAD_to_t1ce_str.nii.gz";
	//std::string trPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_TR_to_t1ce_str.nii.gz";
	//
	//std::string glistrPath;
	//if (subjectNames[sid] == "AAAB0" || subjectNames[sid] == "AAAF0" || subjectNames[sid] == "AALV0")
	//	glistrPath = "Z:/RecurrenceData/gData/" + subjectNames[sid] + "_Label_VP.nii.gz"; 
	//else
	//	glistrPath = "Z:/brain_tumor/human_3T/Recurrence_study/GLISTR_Results/Label_map/" + subjectNames[sid] + "/" + subjectNames[sid] + "_labels.nii.gz";
	//	

	//std::vector<std::string> filePaths;
	//std::string recurPath = subjectPath + "/" + subjectNames[sid] +"_Infiltrated.img";
	//std::string nonrecurPath = subjectPath + "/" + subjectNames[sid] + "_Pure.img";
	fProgressDialog progress("Model Training", 1);
	progress.SetProgress(0, 100);
	qApp->processEvents();

	for (unsigned int i = 0; i < t1ceFileNames.size(); i++)
	{
		progress.SetProgress((i*20)+5, 100);
		qApp->processEvents();

		typedef itk::Image<float, 3> ImageType;
		typedef itk::Image<float, 4> PerfusionImageType;
		ImageType::Pointer recurImagePointer;
		ImageType::Pointer nonrecurImagePointer;
		ImageType::Pointer T1CEImagePointer;
		ImageType::Pointer T2FlairImagePointer;
		ImageType::Pointer T1ImagePointer;
		ImageType::Pointer T2ImagePointer;
		ImageType::Pointer AXImagePointer;
		ImageType::Pointer RADImagePointer;
		ImageType::Pointer FAImagePointer;
		ImageType::Pointer TRImagePointer;
		ImageType::Pointer LabelImagePointer;
		PerfusionImageType::Pointer perfImagePointer;
		std::vector<ImageType::Pointer> perfusionDicomVector;

		LabelImagePointer		= mNiftiLocalPtr->ReadNiftiImage(labelNames[i]);
		recurImagePointer		= mNiftiLocalPtr->ReadNiftiImage(nearFileNames[i]);
		nonrecurImagePointer	= mNiftiLocalPtr->ReadNiftiImage(farFileNames[i]);

		if (usePerfData)
			perfImagePointer	= mNiftiLocalPtr->Read4DNiftiImage(perfFileNames[i]);
		progress.SetProgress((i * 20) +10, 100);
		qApp->processEvents();


		if (useT1CEData)
			T1CEImagePointer	= RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t1ceFileNames[i]));
		if (useT2FlairData)
			T2FlairImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t2FlairFileNames[i]));
		if (useT1Data)
			T1ImagePointer		= RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t1FileNames[i]));
		if (useT2Data)
			T2ImagePointer		= RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t2FileNames[i]));
		if (useDTIData)
		{
			AXImagePointer		= RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(axFileNames[i]));
			RADImagePointer		= RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(radFileNames[i]));
			FAImagePointer		= RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(faFileNames[i]));
			TRImagePointer		= RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(trFileNames[i]));
		}

		int imagetype = IMAGE_NIFTI;
		mNiftiLocalPtr->LoadTrainingData(LabelImagePointer, recurImagePointer, nonrecurImagePointer, T1CEImagePointer, T2FlairImagePointer, T1ImagePointer, T2ImagePointer, perfImagePointer, perfusionDicomVector, AXImagePointer, FAImagePointer, RADImagePointer, TRImagePointer, pNearIntensities, pFarIntensities, mNearIntensities, mFarIntensities, tNearIntensities, tFarIntensities, imagetype,
			useT1Data, useT2Data, useT1CEData, useT2FlairData, useDTIData, usePerfData, useDistData);

		progress.SetProgress((i * 20) + 15, 100);
		qApp->processEvents();
	}
	int nearSamples = 0;
  int farSamples = 0;
  if (mNearIntensities.size() > 0)
  {
    nearSamples = mNearIntensities.size();
    farSamples = mFarIntensities.size();
  }
  else if (pNearIntensities.size() > 0)
  {
    nearSamples = pNearIntensities.size();
    farSamples = pFarIntensities.size();
  }
  else if (tNearIntensities.size() > 0)
  {
    nearSamples = tNearIntensities.size();
    farSamples = tFarIntensities.size();
  }
	int totalSamples = nearSamples + farSamples;

	for (int i = 0; i < nearSamples; i++)
	{
		if (usePerfData)
			perfusionIntensities.push_back(pNearIntensities[i]);
		if (useOtherModalities)
			otherIntensities.push_back(mNearIntensities[i]);
		if (useDistData)
			distanceIntensities.push_back(tNearIntensities[i]);
	}
	for (int i = 0; i < farSamples; i++)
	{
		if (usePerfData)
			perfusionIntensities.push_back(pFarIntensities[i]);
		if (useOtherModalities)
			otherIntensities.push_back(mFarIntensities[i]);
		if (useDistData)
			distanceIntensities.push_back(tFarIntensities[i]);
	}
	VariableLengthVectorType perfMeanVector;
	vtkSmartPointer<vtkTable> reducedPerfusionFeatures;
	//------------------------------------------reduce perfusion intensities------------------------------------------
	if (usePerfData)
	{
		perfMeanVector = mFeatureReductionLocalPtr->ComputeMeanOfGivenFeatureVectors(perfusionIntensities);
		reducedPerfusionFeatures = mFeatureReductionLocalPtr->GetDiscerningPerfusionTimePoints(perfusionIntensities);
	}
	progress.SetProgress(50, 100);
	qApp->processEvents();

	//-----------------------------------develope final near and far vectors------------------------------------------
	VectorVectorDouble fNearIntensities;
	VectorVectorDouble fFarIntensities;
	for (int i = 0; i < nearSamples; i++)
	{
		std::vector<double> cIntensityVectorPerSub;
		if (usePerfData)
			for (int j = 0; j < NO_OF_PCS; j++)
				cIntensityVectorPerSub.push_back(reducedPerfusionFeatures->GetValue(i, j).ToDouble());

		if (useOtherModalities)
			for (unsigned int j = 0; j < otherIntensities[i].size(); j++)
				cIntensityVectorPerSub.push_back(otherIntensities[i][j]);

		if (useDistData)
			cIntensityVectorPerSub.push_back(distanceIntensities[i]);

		fNearIntensities.push_back(cIntensityVectorPerSub);
	}

	for (int i = nearSamples; i < totalSamples; i++)
	{
		std::vector<double> cIntensityVectorPerSub;
		if (usePerfData)
			for (int j = 0; j < NO_OF_PCS; j++)
				cIntensityVectorPerSub.push_back(reducedPerfusionFeatures->GetValue(i, j).ToDouble());

		if (useOtherModalities)
			for (unsigned int j = 0; j < otherIntensities[i].size(); j++)
				cIntensityVectorPerSub.push_back(otherIntensities[i][j]);

		if (useDistData)
			cIntensityVectorPerSub.push_back(distanceIntensities[i]);
		fFarIntensities.push_back(cIntensityVectorPerSub);
	}
	//---------------------training data formulation-----------------------------------
	mFeatureExtractionLocalPtr->FormulateTrainingData(fNearIntensities, fFarIntensities);
	VariableSizeMatrixType TrainingData = mFeatureExtractionLocalPtr->GetTrainingData();
	progress.SetProgress(60, 100);
	qApp->processEvents();

	//typedef vnl_matrix<double> MatrixType;
	//MatrixType data;

	//data.set_size(1404,6);
	//for (int i = 0; i < TrainingData.Rows(); i++)
	//	for (int j = 0; j < TrainingData.Cols(); j++)
	//		data(i, j) = TrainingData[i][j];
	//typedef itk::CSVNumericObjectFileWriter<double, 1404,6> WriterType;
	//WriterType::Pointer writer = WriterType::New();
	//writer->SetFileName("tData.csv");
	//writer->SetInput(&data);
	//writer->Write();



	VariableSizeMatrixType ScaledTrainingData = mFeatureScalingLocalPtr->ScaleGivenTrainingFeatures(TrainingData);
	progress.SetProgress(70, 100);
	qApp->processEvents();
	//MatrixType sdata;
	//sdata.set_size(1404,6);
	//for (int i = 0; i < ScaledTrainingData.Rows(); i++)
	//	for (int j = 0; j < ScaledTrainingData.Cols(); j++)
	//		sdata(i, j) = ScaledTrainingData[i][j];
	//typedef itk::CSVNumericObjectFileWriter<double, 1404,6> WriterTypeS;
	//WriterTypeS::Pointer writerS = WriterTypeS::New();
	//writerS->SetFileName("sData.csv");
	//writerS->SetInput(&sdata);
	//writerS->Write();



	VariableSizeMatrixType ResampledTrainingData = mFeatureExtractionLocalPtr->ResampleTrainingData(ScaledTrainingData, nearSamples, farSamples);
	progress.SetProgress(80, 100);
	qApp->processEvents();
	//------------------------------------------saving model related features---------------------------------------------------

	typedef vnl_matrix<double> MatrixType;
	MatrixType data;
	data.set_size(316,14);
	for (unsigned int i = 0; i < data.rows(); i++)
		for (unsigned int j = 0; j < data.cols(); j++)
			data(i, j) = 0;
		for (unsigned int i = 0; i < ResampledTrainingData.Rows(); i++)
			for (unsigned int j = 0; j < ResampledTrainingData.Cols(); j++)
				data(i, j) = ResampledTrainingData[i][j];

	typedef itk::CSVNumericObjectFileWriter<double, 316,6> WriterTypeR;
	WriterTypeR::Pointer writerR = WriterTypeR::New();
	writerR->SetFileName("rData.csv");
	writerR->SetInput(&data);
	writerR->Write();

	//FILE *t;
	//t = fopen("TrainingData.txt", "w");

	//for (int i = 0; i < ResampledTrainingData.Rows(); i++)
	//{
	//	fprintf(t, "%f ", ResampledTrainingData[i][ResampledTrainingData.Cols() - 1]);
	//	for (int j = 0; j < ResampledTrainingData.Cols() - 1; j++)
	//		fprintf(t, "%d:%lf ", j + 1, ResampledTrainingData[i][j]);
	//	fprintf(t, "\n");
	//}
	//fclose(t);

	int size = GetFeatureVectorSize(useT1Data, useT2Data, useT1CEData, useT2FlairData, useDTIData, usePerfData, useDistData);
	mOutputLocalPtr->SaveModelResults(ScaledTrainingData, mFeatureScalingLocalPtr->GetMeanVector(), mFeatureScalingLocalPtr->GetStdVector(), perfMeanVector, mFeatureReductionLocalPtr->GetPCATransformationMatrix(),
		useT1Data, useT2Data, useT1CEData, useT2FlairData, useDTIData, usePerfData, useDistData, size);

	//------------------------------------------training process---------------------------------------------------
	//QMessageBox box(this);
	//box.setIcon(QMessageBox::Information);
	//box.addButton(QMessageBox::Ok);
	
	if (mClassificationLocalPtr->Training(ResampledTrainingData, outputdirectory) == 0)
		mLastEncounteredError = mClassificationLocalPtr->GetLastEncounteredError();
	else
		mLastEncounteredError = "Training complete.";

	//box.setWindowTitle(tr("Message"));
	//box.setFont(mFont);
	//box.exec();
	//return;
	progress.SetProgress(100, 100);
	qApp->processEvents();
	//-----------------clear all the training parameters-------------------------
	mFeatureReductionLocalPtr->ResetParameters();
	mFeatureScalingLocalPtr->ResetParameters();
}

int RecurrenceEstimator::GetFeatureVectorSize(bool useT1Data, bool useT1CEData, bool useT2FlairData, bool useT2Data, bool useDTIData, bool usePerfData, bool useDistData)
{
	int size = 0;
	if (useT1Data)
		size++;
	if (useT2Data)
		size++;
	if (useT2FlairData)
		size++;
	if (useT1CEData)
		size++;
	if (useDTIData)
		size = size + 4;
	if (usePerfData)
		size = size + 5;
	if (useDistData)
		size = size + 1;
	return size;
}

void RecurrenceEstimator::RecurrenceEstimateOnExistingModel(std::string modeldirectory, std::string inputdirectory, std::string outputdirectory, bool useT1Data, bool useT1CEData, bool useT2Data, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData)
{

	bool useOtherModalities = false;
	if (useT1CEData || useDTIData || useT1Data || useT2Data || useT2FlairData)
		useOtherModalities = true;

	// int size = GetFeatureVectorSize(useT1Data, useT1CEData, useT2FlairData, useT2Data, useDTIData, usePerfData, useDistData);
	int imagetype;

	VariableSizeMatrixType pca_coefficients;
	VariableLengthVectorType pca_mean;
	VariableLengthVectorType mean;
	VariableLengthVectorType stds;

	//check for the presence of model file
	if (!cbica::fileExists(modeldirectory + "/FinalModelFile.model"))
	{
		mLastEncounteredError = "SVM model file is not present in the directory: " + modeldirectory;
		return;
	}
	else
		mClassificationLocalPtr->SetModelFileName(modeldirectory + "/FinalModelFile.model");

	//check for the file having number of modalities
	if (!cbica::fileExists(modeldirectory + "/modalities.csv"))
	{
		mLastEncounteredError = "File having record of modalities is not present in the directory: " + modeldirectory;
		return;
	}
	else
	{
		vnl_matrix<double> modalities = mOutputLocalPtr->ReadNumberOfModalities(modeldirectory + "/modalities.csv");
		std::string message = "Model supports following modalities:\n";
		if (modalities[0][0] == 1)
			message += "T1\n";
		if (modalities[0][1] == 1)
			message += "T1CE\n";
		if (modalities[0][2] == 1)
			message += "T2\n";
		if (modalities[0][3] == 1)
			message += "FLAIR\n";
		if (modalities[0][4] == 1)
			message += "DTI\n";
		if (modalities[0][5] == 1)
			message += "Perfusion\n";
		if (modalities[0][6] == 1)
			message += "Distance trnaform";
		if ((useT1Data == true && modalities[0][0] == 0) || (useT1CEData == true && modalities[0][1] == 0) || (useT2Data == true && modalities[0][2] == 0) ||
			(useT2FlairData == true && modalities[0][3] == 0) || (useDTIData == true && modalities[0][4] == 0) || (usePerfData == true && modalities[0][5] == 0) ||
			(useDistData == true && modalities[0][6] == 0))
		{
			mLastEncounteredError = message;
			return;
		}
	}
	//check for the presence of z-score record
	if (!cbica::fileExists(modeldirectory + "/mean.csv") || !cbica::fileExists(modeldirectory + "/std.csv"))
	{
		mLastEncounteredError = "Z-score record is not present in the directory: " + modeldirectory;
		return;
	}

	//check for the presence of PCA related record
	if (usePerfData)
	{
		if (!cbica::fileExists(modeldirectory + "/pca.csv") || !cbica::fileExists(modeldirectory + "/perfusion.csv"))
		{
			mLastEncounteredError = "PCA parameters are not present in the directory: " + modeldirectory;
			return;
		}
		else
		{
			mOutputLocalPtr->ReadModelParameters(modeldirectory + "/mean.csv", modeldirectory + "/std.csv", modeldirectory + "/pca.csv", modeldirectory + "/perfusion.csv", mean, stds, pca_coefficients, pca_mean);
			mFeatureReductionLocalPtr->SetParameters(pca_coefficients, pca_mean);
		}
	}
	else
	{
		mOutputLocalPtr->ReadModelParameters(modeldirectory + "/mean.csv", modeldirectory + "/std.csv", mean, stds);
		mFeatureScalingLocalPtr->SetParameters(mean, stds);
	}

	//loading subejcts
	std::vector<std::string> t1ceFileNames;
	std::vector<std::string> t1FileNames;
	std::vector<std::string> t2FileNames;
	std::vector<std::string> t2FlairFileNames;
	std::vector<std::string> axFileNames;
	std::vector<std::string> faFileNames;
	std::vector<std::string> radFileNames;
	std::vector<std::string> trFileNames;
	std::vector<std::string> perfFileNames;
	std::vector<std::string> labelNames;
	std::vector<std::string> nearFileNames;
	std::vector<std::string> farFileNames;
	std::vector<std::string> rejectedSubjectNames;
	std::vector<std::string> qualifiedSubjectNames;
	LoadQualifiedSubjectsFromGivenDirectory("testing", inputdirectory, useT1Data, useT1CEData, useT2Data, useT2FlairData, useDTIData, usePerfData, useDistData,
		qualifiedSubjectNames, t1FileNames, t1ceFileNames, t2FileNames, t2FlairFileNames, axFileNames, faFileNames, radFileNames, trFileNames, perfFileNames, labelNames, nearFileNames, farFileNames, rejectedSubjectNames);



	//std::vector<std::string> subjectNames = cbica::subdirectoryInDirectory(modeldirectory + "/Subjects3");
	//for (int sid = 0; sid < subjectNames.size(); sid++)
	//{
	//	std::string perfPath;
	//	std::string radPath;
	//	std::string axPath;
	//	std::string trPath;
	//	std::string faPath;
	//	std::string t1Path;
	//	std::string t1cePath;
	//	std::string t2Path;
	//	std::string t2flairPath;
	//	std::string glistrPath;

	//	t1Path = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "_t1_sus_n3_r_strip.nii.gz";
	//	t1cePath = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "_t1ce_sus_n3_strip.nii.gz";
	//	t2Path = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "_t2_sus_n3_r_strip.nii.gz";
	//	t2flairPath = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "_flair_sus_n3_r_strip.nii.gz";
	//	//std::string glistrPath = "Z:/brain_tumor/human_3T/Recurrence_study/GLISTR_Results/Label_map/" + subjectNames[sid] + "/" + subjectNames[sid] + "_labels.nii.gz";
	//	glistrPath = "Z:/brain_tumor/human_3T/Recurrence_study/GLISTR_Results/Label_map/" + subjectNames[sid] + "/" + subjectNames[sid] + "_labels.nii.gz"; 
	//	perfPath = "Z:/brain_tumor/human_3T/Recurrence_study/perfusion/perfusion_21/T0/4D/" + subjectNames[sid] + "_perf_4D_r_strip.nii.gz";
	//	radPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_RAD_to_t1ce_str.nii.gz";
	//	axPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_AX_to_t1ce_str.nii.gz";
	//	trPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_TR_to_t1ce_str.nii.gz";
	//	faPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "/" + subjectNames[sid] + "_FA_to_t1ce_str.nii.gz";

	//	if (sid >= 2 && sid<=23)
	//	{
	//		t1Path = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "0_t1_sus_n3_r_strip.nii.gz";
	//		t1cePath = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "0_t1ce_sus_n3_strip.nii.gz";
	//		t2Path = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "0_t2_sus_n3_r_strip.nii.gz";
	//		t2flairPath = "Z:/brain_tumor/human_3T/Recurrence_study/postprocessing/" + subjectNames[sid] + "/" + subjectNames[sid] + "0_flair_sus_n3_r_strip.nii.gz";
	//		glistrPath = "Z:/brain_tumor/human_3T/Recurrence_study/GLISTR_Results/Label_map/" + subjectNames[sid] + "0/" + subjectNames[sid] + "0_labels.nii.gz";
	//		//std::string glistrPath = "Z:/RecurrenceTesting/Glistr_revised/" + subjectNames[sid] + "0_Label_HA.nii.gz";
	//		perfPath = "Z:/brain_tumor/human_3T/Recurrence_study/perfusion/perfusion_21/T0/4D/" + subjectNames[sid] + "0_perf_4D_r_strip.nii.gz";
	//		radPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "0/" + subjectNames[sid] + "0_RAD_to_t1ce_str.nii.gz";
	//		axPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "0/" + subjectNames[sid] + "0_AX_to_t1ce_str.nii.gz";
	//		trPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "0/" + subjectNames[sid] + "0_TR_to_t1ce_str.nii.gz";
	//		faPath = "Z:/brain_tumor/human_3T/Recurrence_study/DTI_RCBV_Orig/" + subjectNames[sid] + "0/" + subjectNames[sid] + "0_FA_to_t1ce_str.nii.gz";
	//	}


	//	//std::string t2flairPath = root_directory + "/Subjects/" + subjectNames[i] + "/Flair/";
	//	//std::string t1cePath = root_directory + "/Subjects/" + subjectNames[i] + "/T1ce/";
	//	//std::string t1Path = root_directory + "/Subjects/" + subjectNames[i] + "/T1/";
	//	//std::string t2Path = root_directory + "/Subjects/" + subjectNames[i] + "/T2/";
	//	//std::string perfPath = root_directory + "/Subjects/" + subjectNames[i] + "/Perfusion/";
	//	//std::string dtiPath = root_directory + "/Subjects/" + subjectNames[i] + "/DTI/";
	//	//std::string glistrPath = root_directory + "/Subjects/" + subjectNames[i] + "/Glistr/";

	//	//std::vector<std::string> filenames = cbica::filesInDirectory(t2flairPath);
	//	std::vector<std::string> filenames;
	//	filenames.push_back(t2flairPath);
	//	std::string extension = ".dcm";
	//	if (cbica::getFilenameExtension(filenames[0]) == extension)
	//		imagetype = IMAGE_DICOM;
	//	else
	//		imagetype = IMAGE_NIFTI;

	for (unsigned int sid = 0; sid < qualifiedSubjectNames.size(); sid++)
	{
		VectorVectorDouble perfusionIntensities;
		VectorVectorDouble otherIntensities;
		std::vector<double> distanceIntensities;
		typedef itk::Image<float, 3> ImageType;
		typedef itk::Image<float, 4> PerfusionImageType;
		std::vector<ImageType::Pointer> perfusionDicomVector;
		std::vector<ImageType::IndexType> testindices;

		PerfusionImageType::Pointer perfImagePointer;
		ImageType::Pointer T1CEImagePointer;
		ImageType::Pointer T2FlairImagePointer;
		ImageType::Pointer T1ImagePointer;
		ImageType::Pointer T2ImagePointer;
		ImageType::Pointer AXImagePointer;
		ImageType::Pointer RADImagePointer;
		ImageType::Pointer FAImagePointer;
		ImageType::Pointer TRImagePointer;
		ImageType::Pointer LabelImagePointer;

		/*if (imagetype == IMAGE_NIFTI)
		{*/
		//t2flairPath = t2flairPath + subjectNames[i] + "_flair.img";
		//t1cePath = t1cePath + subjectNames[i] + "_t1ce.img";
		//t1Path = t1Path + subjectNames[i] + "_t1.img";
		//t2Path = t2Path + subjectNames[i] + "_t2.img";
		//perfPath = perfPath + subjectNames[i] + "_perf.nii.gz";
		//glistrPath = glistrPath + subjectNames[i] + "_labels.nii.gz";

		//std::string axPath = dtiPath + subjectNames[i] + "_AX.nii.gz";
		//std::string faPath = dtiPath + subjectNames[i] + "_FA.nii.gz";
		//std::string radPath = dtiPath + subjectNames[i] + "_RAD.nii.gz";
		//std::string trPath = dtiPath + subjectNames[i] + "_TR.nii.gz";


		//const PerfusionImageType::RegionType regionp = perfImagePointer->GetLargestPossibleRegion();
		//int a = regionp.GetSize()[0];
		//int b = regionp.GetSize()[1];
		//int c = regionp.GetSize()[2];
		//int d = regionp.GetSize()[3];


		LabelImagePointer = mNiftiLocalPtr->ReadNiftiImage(labelNames[sid]);
		if (usePerfData)
			perfImagePointer = mNiftiLocalPtr->Read4DNiftiImage(perfFileNames[sid]);
		if (useT1CEData)
			T1CEImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t1ceFileNames[sid]));
		if (useT2FlairData)
			T2FlairImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t2FlairFileNames[sid]));
		if (useT1Data)
			T1ImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t1FileNames[sid]));
		if (useT2Data)
			T2ImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(t2FileNames[sid]));
		if (useDTIData)
		{
			AXImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(axFileNames[sid]));
			RADImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(radFileNames[sid]));
			FAImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(faFileNames[sid]));
			TRImagePointer = RescaleImageIntensity(mNiftiLocalPtr->ReadNiftiImage(trFileNames[sid]));
		}

		typedef itk::Image<float, 3> OutputImageType;
		OutputImageType::Pointer dilatedEdema;
		typedef itk::BinaryBallStructuringElement<ImageType::PixelType, 3> StructuringElementType;
		StructuringElementType structuringElement;
		structuringElement.SetRadius(1);
		structuringElement.CreateStructuringElement();
		typedef itk::BinaryDilateImageFilter <ImageType, ImageType, StructuringElementType> BinaryDilateImageFilterType;
		BinaryDilateImageFilterType::Pointer dilateFilter = BinaryDilateImageFilterType::New();
		dilateFilter->SetInput(LabelImagePointer);
		dilateFilter->SetKernel(structuringElement);
		dilateFilter->SetDilateValue(100);
		dilateFilter->Update();
		dilatedEdema = dilateFilter->GetOutput();

		imagetype = IMAGE_NIFTI;
		testindices = mNiftiLocalPtr->LoadTestData(T1CEImagePointer, T2FlairImagePointer, T1ImagePointer, T2ImagePointer, perfImagePointer, perfusionDicomVector, AXImagePointer, FAImagePointer, RADImagePointer, TRImagePointer, LabelImagePointer, dilatedEdema, perfusionIntensities, otherIntensities, distanceIntensities, imagetype,
			useT1Data, useT2Data, useT1CEData, useT2FlairData, useDTIData, usePerfData, useDistData);


		//perfImagePointer.GetPointer()->Delete();
		//T2FlairImagePointer.GetPointer()->Delete();
		//T1ImagePointer.GetPointer()->Delete();
		//T2ImagePointer.GetPointer()->Delete();
		//AXImagePointer.GetPointer()->Delete();
		//RADImagePointer.GetPointer()->Delete();
		//FAImagePointer.GetPointer()->Delete();
		//TRImagePointer.GetPointer()->Delete();

		VectorVectorDouble reducedPerfusionFeatures;
		if (usePerfData)
			reducedPerfusionFeatures = mFeatureReductionLocalPtr->ApplyPCAOnTestData(perfusionIntensities);

		int NumberOfPCs = 5;
		VectorVectorDouble globaltestintensities;

		for (unsigned int k = 0; k < testindices.size(); k++)
		{
			std::vector<double> inten;

			if (usePerfData)
				for (int j = 0; j < NumberOfPCs; j++)
					inten.push_back(reducedPerfusionFeatures[k][j]);

			if (useOtherModalities)
				for (unsigned int j = 0; j < otherIntensities[0].size(); j++)
					inten.push_back(otherIntensities[k][j]);

			if (useDistData)
				inten.push_back(distanceIntensities[k]);

			if (inten.size()>0)
				globaltestintensities.push_back(inten);
		}
		VariableSizeMatrixType TestingData = mFeatureExtractionLocalPtr->FormulateTestData(globaltestintensities);

		//typedef vnl_matrix<double> MatrixType;
		//MatrixType data;
		//data.set_size(22753, 15);

		//for (int i = 0; i < TestingData.Rows(); i++)
		//	for (int j = 0; j < TestingData.Cols(); j++)
		//		data(i, j) = TestingData[i][j];

		////-----------------mean file writer------------------------
		//typedef itk::CSVNumericObjectFileWriter<double, 22753, 15> WriterType;
		//WriterType::Pointer writer = WriterType::New();
		//writer->SetFileName("testdata.csv");
		//writer->SetInput(&data);
		//try
		//{
		//	writer->Write();
		//}
		//catch (itk::ExceptionObject & excp)
		//{
		//}


		VariableSizeMatrixType ScaledTestingData = mFeatureScalingLocalPtr->ScaleGivenTestingFeatures(TestingData);
		//MatrixType sdata;
		//sdata.set_size(22753, 15);
		//for (int i = 0; i < TestingData.Rows(); i++)
		//	for (int j = 0; j < TestingData.Cols(); j++)
		//		sdata(i, j) = ScaledTestingData[i][j];
		//writer->SetFileName("scaledtestdata.csv");
		//writer->SetInput(&sdata);
		//try
		//{
		//	writer->Write();
		//}
		//catch (itk::ExceptionObject & excp)
		//{
		//}



		ImageType::RegionType region = T1CEImagePointer->GetLargestPossibleRegion();
		ImageType::Pointer RecProbabilityMap = ImageType::New();
		RecProbabilityMap->SetRegions(region);
		RecProbabilityMap->Allocate();
		RecProbabilityMap->SetSpacing(T1CEImagePointer->GetSpacing());
		RecProbabilityMap->SetOrigin(T1CEImagePointer->GetOrigin());
		RecProbabilityMap->SetDirection(T1CEImagePointer->GetDirection());

		ImageType::Pointer NonRecProbabilityMap = ImageType::New();
		//NonRecProbabilityMap->SetRegions(region);
		//NonRecProbabilityMap->Allocate();
		//NonRecProbabilityMap->SetSpacing(T1CEImagePointer->GetSpacing());
		//NonRecProbabilityMap->SetOrigin(T1CEImagePointer->GetOrigin());
		//NonRecProbabilityMap->SetDirection(T1CEImagePointer->GetDirection());

		ImageType::Pointer LabelMap = ImageType::New();
		//LabelMap->SetRegions(region);
		//LabelMap->Allocate();
		//LabelMap->SetSpacing(T1CEImagePointer->GetSpacing());
		//LabelMap->SetOrigin(T1CEImagePointer->GetOrigin());
		//LabelMap->SetDirection(T1CEImagePointer->GetDirection());

		try
		{

			VectorVectorDouble result = mClassificationLocalPtr->Testing(ScaledTestingData, true,mOutputLocalPtr->mOutputDirectoryPath+"/FinalModelFile.model");

			//MatrixType pdata;
			//pdata.set_size(22753,2);
			//for (int r = 0; r < result.size(); r++)
			//{
			//	pdata(r, 0) = result[r][1];
			//	pdata(r, 1) = result[r][2];
			//}
			//typedef itk::CSVNumericObjectFileWriter<double, 22753, 2> PWriterType;
			//PWriterType::Pointer pwriter = PWriterType::New();
			//pwriter->SetFileName("probability.csv");
			//pwriter->SetInput(&pdata);
			//try
			//{
			//	pwriter->Write();
			//}
			//catch (itk::ExceptionObject & excp)
			//{
			//}

			for (unsigned int index = 0; index < result.size(); index++)
				RecProbabilityMap->SetPixel(testindices[index], result[index][1] * 32767);

			typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
			IteratorType EdemaIt(dilatedEdema, dilatedEdema->GetLargestPossibleRegion());
			IteratorType RecIt(RecProbabilityMap, RecProbabilityMap->GetLargestPossibleRegion());
			EdemaIt.GoToBegin(); RecIt.GoToBegin();

			while (!EdemaIt.IsAtEnd())
			{
				if (EdemaIt.Get() == 100)
				{
					++EdemaIt; ++RecIt;
					continue;
				}
				else
				{
					RecIt.Set(0);
					++EdemaIt; ++RecIt;
				}
			}
		}
		catch (itk::ExceptionObject & excp)
		{
      std::cerr << "Error caught during testing:\n" << excp.GetDescription() << "\n";
      exit(EXIT_FAILURE);
		}
		if (imagetype == IMAGE_NIFTI)
			mOutputLocalPtr->WriteRecurrenceOutputInNifti<ImageType>(RecProbabilityMap, NonRecProbabilityMap, LabelMap, outputdirectory + "/" + qualifiedSubjectNames[sid]);
		else
			mOutputLocalPtr->WriteRecurrenceOutputInNifti<ImageType>(RecProbabilityMap, NonRecProbabilityMap, LabelMap, outputdirectory + "/" + qualifiedSubjectNames[sid]);
	}
	mFeatureReductionLocalPtr->ResetParameters();
	mFeatureScalingLocalPtr->ResetParameters();
}
