#ifndef _RecurrenceEstimator_h_
#define _RecurrenceEstimator_h_
#include "CBICA_Viewer.h"
#include "NiftiDataManager.h"
#include "OutputWritingManager.h"
#include "FeatureReductionClass.h"
#include "FeatureScalingClass.h"
#include "FeatureExtractionClass.h"
#include "SVMClassificationClass.h"
#include "fProgressDialog.h"

class RecurrenceEstimator
{
public:
	RecurrenceEstimator(NiftiDataManager * mNPtr, OutputWritingManager * mOPtr, FeatureReductionClass * mRPtr,FeatureScalingClass * mSPtr,FeatureExtractionClass * mEPtr,SVMClassificationClass * mCPtr)
	{
		mNiftiLocalPtr				= mNPtr;
		mOutputLocalPtr				= mOPtr;
		mFeatureReductionLocalPtr	= mRPtr;
		mFeatureScalingLocalPtr		= mSPtr;
		mFeatureExtractionLocalPtr  = mEPtr;
		mClassificationLocalPtr		= mCPtr;
	};
	~RecurrenceEstimator();
	std::string mLastEncounteredError;

	int GetFeatureVectorSize(bool useT1Data, bool useT1CEData, bool useT2FlairData, bool useT2Data, bool useDTIData, bool usePerfData, bool useDistData);
	itk::Image<float, 3>::Pointer RescaleImageIntensity(itk::Image<float, 3>::Pointer image);
	void TrainNewModelOnGivenData(std::string directoryname, std::string outputdirectory, bool useT1Data, bool useT1CEData, bool useT2Data, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData);
	void RecurrenceEstimateOnExistingModel(std::string modeldirectory, std::string inputdirectory, std::string outputdirectory, bool useT1Data, bool useT1CEData, bool useT2Data, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData);

	void LoadQualifiedSubjectsFromGivenDirectory(std::string type, std::string directoryname, bool useT1Data, bool useT1CEData, bool useT2Data, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData,
		std::vector<std::string> & qualifiedSubjectNames,
		std::vector<std::string> & t1FileNames,
		std::vector<std::string> & t1ceFileNames,
		std::vector<std::string> & t2FileNames,
		std::vector<std::string> & t2FlairFileNames,
		std::vector<std::string> & axFileNames,
		std::vector<std::string> & faFileNames,
		std::vector<std::string> & radFileNames,
		std::vector<std::string> & trFileNames,
		std::vector<std::string> & perfFileNames,
		std::vector<std::string> & labelNames,
		std::vector<std::string> & nearFileNames,
		std::vector<std::string> & farFileNames,
		std::vector<std::string> & rejectedSubjectNames);

	template<class ImageType>
	void RecurrenceEstimateOnGivenSubject(typename ImageType::Pointer edemaMask,
  typename ImageType::Pointer tumorMask,
  typename ImageType::Pointer FinalT1CEImagePointer,
  typename ImageType::Pointer FinalT2FlairImagePointer,
  typename ImageType::Pointer FinalT1ImagePointer,
  typename ImageType::Pointer FinalT2ImagePointer,
  std::vector<typename ImageType::Pointer> FinalPerfusionImagePointer,
  std::vector<typename ImageType::Pointer> FinalDTIImagePointer,
  int imagetype, bool t1DataPresent, bool t2DataPresent, bool t1ceDataPresent, bool t2flairDataPresent, bool dtiDataPresent, bool perfusionDataPresent, bool distanceDataPresent,
  bool useOtherModalities, std::string t1cebasefilename,
  VectorVectorDouble nearRegionIndices,
  VectorVectorDouble farRegionIndices);

	NiftiDataManager		* mNiftiLocalPtr;
	OutputWritingManager	* mOutputLocalPtr;
	FeatureReductionClass	* mFeatureReductionLocalPtr;
	FeatureScalingClass		* mFeatureScalingLocalPtr;
	FeatureExtractionClass  * mFeatureExtractionLocalPtr;
	SVMClassificationClass  * mClassificationLocalPtr;
};

template<class ImageType>
void RecurrenceEstimator::RecurrenceEstimateOnGivenSubject(typename ImageType::Pointer edemaMask,
	typename ImageType::Pointer tumorMask,
	typename ImageType::Pointer FinalT1CEImagePointer,
	typename ImageType::Pointer FinalT2FlairImagePointer,
	typename ImageType::Pointer FinalT1ImagePointer,
	typename ImageType::Pointer FinalT2ImagePointer,
	std::vector<typename ImageType::Pointer> FinalPerfusionImagePointer,
	std::vector<typename ImageType::Pointer> FinalDTIImagePointer, 
	int imagetype, bool t1DataPresent, bool t2DataPresent, bool t1ceDataPresent, bool t2flairDataPresent, bool dtiDataPresent, bool perfusionDataPresent, bool distanceDataPresent,
	bool useOtherModalities, std::string t1cebasefilename,
	VectorVectorDouble nearRegionIndices,
	VectorVectorDouble farRegionIndices)
{
	//------------------------------------------training data formulation------------------------------------------
	VectorVectorDouble mNearIntensities;
	VectorVectorDouble mFarIntensities;
	VectorVectorDouble pNearIntensities;
	VectorVectorDouble pFarIntensities;
	std::vector<double> tNearIntensities;
	std::vector<double> tFarIntensities;

	VectorVectorDouble perfusionIntensities;
	VectorVectorDouble otherIntensities;
	std::vector<double> distanceIntensities;
	VectorVectorDouble fNearIntensities;
	VectorVectorDouble fFarIntensities;

	fProgressDialog progress("Recurrence Estimation", 1);
	progress.SetProgress(0, 100);
	qApp->processEvents();

	mNiftiLocalPtr->LoadTrainingData(tumorMask, nearRegionIndices, farRegionIndices, FinalT1CEImagePointer, FinalT2FlairImagePointer, FinalT1ImagePointer, FinalT2ImagePointer, FinalPerfusionImagePointer, FinalDTIImagePointer, pNearIntensities, pFarIntensities, mNearIntensities, mFarIntensities, tNearIntensities, tFarIntensities, IMAGE_NIFTI, t1DataPresent, t2DataPresent, t1ceDataPresent, t2flairDataPresent, dtiDataPresent, perfusionDataPresent, distanceDataPresent);

	for (unsigned int i = 0; i < mNearIntensities.size(); i++)
	{
		if (perfusionDataPresent)
			perfusionIntensities.push_back(pNearIntensities[i]);
		if (useOtherModalities)
			otherIntensities.push_back(mNearIntensities[i]);
		if (distanceDataPresent)
			distanceIntensities.push_back(tNearIntensities[i]);
	}
	for (unsigned int i = 0; i < mFarIntensities.size(); i++)
	{
		if (perfusionDataPresent)
			perfusionIntensities.push_back(pFarIntensities[i]);
		if (useOtherModalities)
			otherIntensities.push_back(mFarIntensities[i]);
		if (distanceDataPresent)
			distanceIntensities.push_back(tFarIntensities[i]);
	}
	progress.SetProgress(10, 100);
	qApp->processEvents();

	VariableLengthVectorType perfMeanVector;
	vtkSmartPointer<vtkTable> reducedPerfusionFeatures;
	//------------------------------------------reduce perfusion intensities------------------------------------------
	if (perfusionDataPresent)
		reducedPerfusionFeatures = mFeatureReductionLocalPtr->GetDiscerningPerfusionTimePoints(perfusionIntensities);
	//-----------------------------------develope final near and far vectors------------------------------------------
	for (unsigned int i = 0; i < mNearIntensities.size(); i++)
	{
		std::vector<double> cIntensityVectorPerSub;
		if (perfusionDataPresent)
			for (int j = 0; j < NO_OF_PCS; j++)
				cIntensityVectorPerSub.push_back(reducedPerfusionFeatures->GetValue(i, j).ToDouble());

		if (useOtherModalities)
			for (unsigned int j = 0; j < otherIntensities[i].size(); j++)
				cIntensityVectorPerSub.push_back(otherIntensities[i][j]);

		if (distanceDataPresent)
			cIntensityVectorPerSub.push_back(distanceIntensities[i]);

		fNearIntensities.push_back(cIntensityVectorPerSub);
	}

	for (unsigned int i = mNearIntensities.size(); i < mNearIntensities.size() + mFarIntensities.size(); i++)
	{
		std::vector<double> cIntensityVectorPerSub;
		if (perfusionDataPresent)
			for (int j = 0; j < NO_OF_PCS; j++)
				cIntensityVectorPerSub.push_back(reducedPerfusionFeatures->GetValue(i, j).ToDouble());

		if (useOtherModalities)
			for (unsigned int j = 0; j < otherIntensities[i].size(); j++)
				cIntensityVectorPerSub.push_back(otherIntensities[i][j]);

		if (distanceDataPresent)
			cIntensityVectorPerSub.push_back(distanceIntensities[i]);
		fFarIntensities.push_back(cIntensityVectorPerSub);
	}
	mFeatureExtractionLocalPtr->FormulateTrainingData(fNearIntensities, fFarIntensities);
	VariableSizeMatrixType TrainingData = mFeatureExtractionLocalPtr->GetTrainingData();

	progress.SetProgress(20, 100);
	qApp->processEvents();

	//typedef vnl_matrix<double> MatrixType;
	//MatrixType data;
	//data.set_size(120, 45);
	//for (int i = 0; i < perfusionIntensities.size(); i++)
	//	for (int j = 0; j < 45; j++)
	//		data(i, j) = perfusionIntensities[i][j];
	//typedef itk::CSVNumericObjectFileWriter<double, 120, 45> WriterType;
	//WriterType::Pointer writer = WriterType::New();
	//writer->SetFileName("perfusionData.csv");
	//writer->SetInput(&data);
	//writer->Write();


	//data.set_size(120,15);
	//for (int i = 0; i < TrainingData.Rows(); i++)
	//	for (int j = 0; j < TrainingData.Cols(); j++)
	//		data(i, j) = TrainingData[i][j];
	//writer->SetFileName("tData.csv");
	//writer->SetInput(&data);
	//writer->Write();


	VariableSizeMatrixType ScaledTrainingData = mFeatureScalingLocalPtr->ScaleGivenTrainingFeatures(TrainingData);

	//data.set_size(120, 15);
	//for (int i = 0; i < ScaledTrainingData.Rows(); i++)
	//	for (int j = 0; j < ScaledTrainingData.Cols(); j++)
	//		data(i, j) = ScaledTrainingData[i][j];
	//writer->SetFileName("sData.csv");
	//writer->SetInput(&data);
	//writer->Write();

	////------------------------------------------training process---------------------------------------------------
	//FILE *t;
	//t = fopen("TrainingData.txt", "w");

	//for (int i = 0; i < ScaledTrainingData.Rows(); i++)
	//{
	//	fprintf(t, "%f ", ScaledTrainingData[i][ScaledTrainingData.Cols() - 1]);
	//	for (int j = 0; j < ScaledTrainingData.Cols() - 1; j++)
	//		fprintf(t, "%d:%lf ", j + 1, ScaledTrainingData[i][j]);
	//	fprintf(t, "\n");
	//}
	//fclose(t);

	int size = GetFeatureVectorSize(t1DataPresent, t2DataPresent, t1ceDataPresent, t2flairDataPresent, dtiDataPresent, perfusionDataPresent, distanceDataPresent);
	mOutputLocalPtr->SaveModelResults(ScaledTrainingData, mFeatureScalingLocalPtr->GetMeanVector(), mFeatureScalingLocalPtr->GetStdVector(), perfMeanVector, mFeatureReductionLocalPtr->GetPCATransformationMatrix(),
		t1DataPresent, t2DataPresent, t1ceDataPresent, t2flairDataPresent, dtiDataPresent, perfusionDataPresent, distanceDataPresent, size);

	progress.SetProgress(30, 100);
	qApp->processEvents();

	mClassificationLocalPtr->Training(ScaledTrainingData,mOutputLocalPtr->mOutputDirectoryPath);
	if (mClassificationLocalPtr->GetLastEncounteredError() != "")
		mLastEncounteredError = mClassificationLocalPtr->GetLastEncounteredError();
	progress.SetProgress(40, 100);
	qApp->processEvents();
	//qSleep(5000);
	////------------------------------------------testing data formulation---------------------------------------------------

	const typename ImageType::RegionType region = FinalT1CEImagePointer->GetLargestPossibleRegion();
	typename ImageType::Pointer RecurrenceProbabilityMap = ImageType::New();
	RecurrenceProbabilityMap->SetRegions(region);
	RecurrenceProbabilityMap->Allocate();
	RecurrenceProbabilityMap->SetSpacing(FinalT1CEImagePointer->GetSpacing());
	RecurrenceProbabilityMap->SetOrigin(FinalT1CEImagePointer->GetOrigin());
	RecurrenceProbabilityMap->SetDirection(FinalT1CEImagePointer->GetDirection());

	perfusionIntensities.clear();
	otherIntensities.clear();
	distanceIntensities.clear();
	std::vector<typename ImageType::IndexType> testindices;
	testindices = mNiftiLocalPtr->LoadTestData(FinalT1CEImagePointer, FinalT2FlairImagePointer, FinalT1ImagePointer, FinalT2ImagePointer, FinalPerfusionImagePointer, FinalDTIImagePointer, tumorMask, edemaMask, perfusionIntensities, otherIntensities, distanceIntensities, IMAGE_DICOM, t1DataPresent, t2DataPresent, t1ceDataPresent, t2flairDataPresent, dtiDataPresent, perfusionDataPresent, distanceDataPresent);


	VectorVectorDouble reducedTestPerfusionFeatures;
	if (perfusionDataPresent)
		reducedTestPerfusionFeatures = mFeatureReductionLocalPtr->ApplyPCAOnTestData(perfusionIntensities);

	int NumberOfPCs = 5;
	VectorVectorDouble globaltestintensities;

	for (unsigned int k = 0; k < testindices.size(); k++)
	{
		std::vector<double> inten;

		if (perfusionDataPresent)
			for (int j = 0; j < NumberOfPCs; j++)
				inten.push_back(reducedTestPerfusionFeatures[k][j]);

		if (useOtherModalities)
			for (unsigned int j = 0; j < otherIntensities[0].size(); j++)
				inten.push_back(otherIntensities[k][j]);

		if (distanceDataPresent)
			inten.push_back(distanceIntensities[k]);

		if (inten.size()>0)
			globaltestintensities.push_back(inten);
	}
	VariableSizeMatrixType TestingData = mFeatureExtractionLocalPtr->FormulateTestData(globaltestintensities);
	VariableSizeMatrixType ScaledTestingData = mFeatureScalingLocalPtr->ScaleGivenTestingFeatures(TestingData);

	progress.SetProgress(60, 100);
	qApp->processEvents();

	//qSleep(5000);
	//typedef vnl_matrix<double> MatrixTypeT;
	//MatrixTypeT dataT;
	//dataT.set_size(1517, 45);
	//for (int ii = 0; ii < perfusionIntensities.size(); ii++)
	//	for (int jj = 0; jj < 45; jj++)
	//		dataT(ii, jj) = reducedTestPerfusionFeatures[ii][jj];
	//typedef itk::CSVNumericObjectFileWriter<double, 1517, 45> WriterTypeT;
	//WriterTypeT::Pointer writerT = WriterTypeT::New();
	//writerT->SetFileName("perfusionDataTest.csv");
	//writerT->SetInput(&dataT);
	//writerT->Write();


	//dataT.set_size(1517, 15);
	//for (int ii = 0; ii < TestingData.Rows(); ii++)
	//	for (int jj = 0; jj < TestingData.Cols(); jj++)
	//		dataT(ii, jj) = TestingData[ii][jj];
	//writerT->SetFileName("tDataTest.csv");
	//writerT->SetInput(&dataT);
	//writerT->Write();

	//dataT.set_size(1517, 15);
	//for (int ii = 0; ii < ScaledTestingData.Rows(); ii++)
	//	for (int jj = 0; jj < ScaledTestingData.Cols(); jj++)
	//		dataT(ii, jj) = ScaledTestingData[ii][jj];
	//writerT->SetFileName("sDataTest.csv");
	//writerT->SetInput(&dataT);
	//writerT->Write();

	try
	{
		mClassificationLocalPtr->SetModelFileName(mOutputLocalPtr->mOutputDirectoryPath + "/FinalModelFile.model");
		VectorVectorDouble result = mClassificationLocalPtr->Testing(ScaledTestingData, false, mOutputLocalPtr->mOutputDirectoryPath + "/FinalModelFile.model");
		//qSleep(5000);
		progress.SetProgress(70, 100);
		qApp->processEvents();

		for (unsigned int x = 0; x < result.size(); x++)
			RecurrenceProbabilityMap->SetPixel(testindices[x], result[x][1]);

		progress.SetProgress(80, 100);
		qApp->processEvents();
		typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
		IteratorType RecIt(RecurrenceProbabilityMap, RecurrenceProbabilityMap->GetLargestPossibleRegion());
		IteratorType EdeIt(edemaMask, edemaMask->GetLargestPossibleRegion());
		RecIt.GoToBegin();
		EdeIt.GoToBegin();
		while (!RecIt.IsAtEnd())
		{
			typename ImageType::IndexType index = RecIt.GetIndex();
			if (EdeIt.Get() != 255)
				RecIt.Set(0);
			++RecIt;
			++EdeIt;
		}
		//if (x_index >= mBorderStartX && x_index <= mBorderEndX && y_index >= mBorderStartY && y_index <= mBorderEndY && z_index >= 80 && z_index <= 120)
	}
	catch (itk::ExceptionObject & excp)
	{
		std::string str(excp.GetDescription());
	}
	progress.SetProgress(90, 100);
	qApp->processEvents();

	//------------------------------------------Writing final output--------------------------------------------------
	mOutputLocalPtr->WriteRecurrenceOutput<ImageType>(RecurrenceProbabilityMap, t1cebasefilename);
	progress.SetProgress(100, 100);
	qApp->processEvents();
}

#endif
