///////////////////////////////////////////////////////////////////////////////////////
// FeatureExtractionClass.cpp
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////


#include "FeatureExtractionClass.h"
#include "itkVariableSizeMatrix.h"
#include "itkVariableLengthVector.h"
#include "CBICA_Viewer.h"

FeatureExtractionClass::FeatureExtractionClass()
{

}

VariableSizeMatrixType FeatureExtractionClass::ResampleTrainingData(VariableSizeMatrixType &trainingdata, int NumberOfNearSamples, int NumberOfFarSamples)
{
	VariableSizeMatrixType sampledTrainingData;
	int NumberOfFeatures = trainingdata.Cols()-1;
	int Fraction = 8;// NumberOfFarSamples / NumberOfNearSamples;
	int NumberOfSampledFarSamples = 0;
	int TotalSamples = NumberOfFarSamples + NumberOfNearSamples;

	for (int i = 0; i < NumberOfFarSamples; i = i + Fraction)
			NumberOfSampledFarSamples++;
	sampledTrainingData.SetSize(NumberOfNearSamples + NumberOfSampledFarSamples, NumberOfFeatures + 1);

	for (int i = 0; i < NumberOfNearSamples; i++)
	{
		for (unsigned int j = 0; j < trainingdata.Cols(); j++)
			sampledTrainingData(i, j) = trainingdata(i,j);
	}
	int counter = NumberOfNearSamples;

	for (int i = NumberOfNearSamples; i < TotalSamples; i = i + Fraction)
	{
		for (unsigned int j = 0; j < trainingdata.Cols(); j++)
			sampledTrainingData(counter, j) = trainingdata(i, j);
		counter = counter + 1;
	}
	return sampledTrainingData;
}


void FeatureExtractionClass::FormulateTrainingData(std::vector< std::vector< double > > &nearintensitities, std::vector< std::vector< double > > &farintensitities)
{
	int NumberOfNearSamples = nearintensitities.size();
	int NumberOfFarSamples = farintensitities.size();
	int NumberOfFeatures = nearintensitities[0].size();
	
	mTrainingData.SetSize(NumberOfNearSamples + NumberOfFarSamples, NumberOfFeatures + 1);
	for (int i = 0; i < NumberOfNearSamples; i++)
	{
		for (int j = 0; j < NumberOfFeatures; j++)
			mTrainingData(i, j) = nearintensitities[i][j];
		mTrainingData(i, NumberOfFeatures) = TRAINING_LABEL_NEAR;
	}
	for (int i = 0; i < NumberOfFarSamples; i++)
	{
		for (int j = 0; j < NumberOfFeatures; j++)
			mTrainingData(i+NumberOfNearSamples, j) = farintensitities[i][j];

		mTrainingData(i + NumberOfNearSamples,NumberOfFeatures) = TRAINING_LABEL_FAR;
	}
}


VariableSizeMatrixType FeatureExtractionClass::FormulateTestData(std::vector< std::vector< double > > &testdata)
{
	int NumberOfFeatures = testdata[0].size();
	int NumberOfSamples = testdata.size();

	mTestData.SetSize(NumberOfSamples, NumberOfFeatures+1);

	for (int i = 0; i < NumberOfSamples; i++)
	{
		for (int j = 0; j < NumberOfFeatures;j++)
			mTestData(i,j) = testdata[i][j];
		mTestData(i, NumberOfFeatures) = TRAINING_LABEL_FAR;
	}
	
	return mTestData;
}
