///////////////////////////////////////////////////////////////////////////////////////
// FeatureExtractionClass.h
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CBICA_Viewer.h"

class  FeatureExtractionClass
{
public:
	VariableSizeMatrixType mTrainingData;
	VariableSizeMatrixType mTestData;

	VariableSizeMatrixType GetTrainingData()
	{
		return mTrainingData;
	}

	void SetTrainingData(VariableSizeMatrixType &inputTrainingData)
	{
		mTrainingData = inputTrainingData;
	}

	VariableSizeMatrixType GetTestData()
	{
		return mTestData;
	}

	void SetTestData(VariableSizeMatrixType &inputTestData)
	{
		mTestData = inputTestData;
	}


	FeatureExtractionClass();
	void FormulateTrainingData(std::vector< std::vector< double > > &nearintensitities, std::vector< std::vector< double > > &farintensitities);
	VariableSizeMatrixType FormulateTestData(std::vector< std::vector< double > > &testdata);
	VariableSizeMatrixType ResampleTrainingData(VariableSizeMatrixType &trainingdata, int nearsamples, int farsamples);
};
