///////////////////////////////////////////////////////////////////////////////////////
// FeatureReductionClass.h
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

#include "iostream"
#include "CBICA_Viewer.h"

using namespace std;

class  FeatureReductionClass
{
private:
	VariableSizeMatrixType PCATransformationMatrix;
	VariableLengthVectorType mPMeanvector;

public:
	FeatureReductionClass();
	~FeatureReductionClass();
	vtkSmartPointer<vtkTable> GetDiscerningPerfusionTimePoints(VectorVectorDouble &intensities);
	VectorVectorDouble ApplyPCAOnTestData(VectorVectorDouble &intensities);
	VariableSizeMatrixType MatrixTranspose(VariableSizeMatrixType &inputmatrix);
	VariableLengthVectorType ComputeMeanOfGivenFeatureVectors(vtkSmartPointer< vtkTable > &inputdata);
	VariableLengthVectorType ComputeMeanOfGivenFeatureVectors(VectorVectorDouble &inputdata);


	VariableSizeMatrixType GetPCATransformationMatrix()
	{
		return PCATransformationMatrix;
	}

	VariableLengthVectorType GetPerfusionMeanVector()
	{
		return mPMeanvector;
	}

	void SetParameters(VariableSizeMatrixType &pcaMatrix, VariableLengthVectorType &pcaMean)
	{
		PCATransformationMatrix = pcaMatrix;
		mPMeanvector = pcaMean;
	}

	void ResetParameters()
	{
		PCATransformationMatrix.SetSize(0, 0);
		mPMeanvector.SetSize(0);
		PCATransformationMatrix.SetSize(NO_OF_PCA_FEATURES, NO_OF_PCA_FEATURES);
		mPMeanvector.SetSize(NO_OF_PCA_FEATURES);
	}
};
