///////////////////////////////////////////////////////////////////////////////////////
// FeatureScalingClass.h
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "iostream"
#include "CBICA_Viewer.h"

using namespace std;

class  FeatureScalingClass
{
private:
	VariableLengthVectorType mMeanVector;
	VariableLengthVectorType mStdVector;

public:
	FeatureScalingClass();
	~FeatureScalingClass();
	VariableSizeMatrixType ScaleGivenTrainingFeatures(VariableSizeMatrixType &inputdata);
	VariableSizeMatrixType ScaleGivenTestingFeatures(VariableSizeMatrixType &inputdata);


	VariableLengthVectorType GetMeanVector()
	{
		return mMeanVector;
	}

	VariableLengthVectorType GetStdVector()
	{
		return mStdVector;
	}

	void SetParameters(VariableLengthVectorType &meanvector, VariableLengthVectorType &stdvector)
	{
		mMeanVector = meanvector;
		mStdVector = stdvector;
	}

	void ResetParameters()
	{
		mMeanVector.SetSize(0);
		mStdVector.SetSize(0);
		mMeanVector.SetSize(NO_OF_FEATURES);
		mStdVector.SetSize(NO_OF_FEATURES);
	}


	double GetMeanForGivenFeatureIndex(int index)
	{
		return mMeanVector[index];
	}

	double GetStdForGivenFeatureIndex(int index)
	{
		return mStdVector[index];
	}

	double GetZScore(double mean, double variance, double featureval);
};
