#include "NiftiDataManager.h"


NiftiDataManager::NiftiDataManager()
{
  //std::string filename = "Z:/RecurrenceTesting/MatlabWork/Heterogeneity/SpatialMaps/C2_Intermediate.nii.gz";
  //std::string outputFilename = "Z:/RecurrenceTesting/MatlabWork/Heterogeneity/SpatialMaps/C2.nii.gz";
  //typedef itk::Image<float, 3> ImageType;
  //ImageType::Pointer image;
  //itk::ImageIOBase::Pointer reader = itk::ImageIOFactory::CreateImageIO(filename.c_str(), itk::ImageIOFactory::ReadMode);
  //if (!reader)
  //{
  //  /*	mLastError = "Unable to read file.";
  //  return false;*/
  //}

  //reader->SetFileName(filename);
  //reader->ReadImageInformation();
  //std::string InputPixelType = reader->GetComponentTypeAsString(reader->GetComponentType());
  //image = ReadImageWithDim<float, 3>(filename, InputPixelType);


  //typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
  //IteratorType LabelImageIt(image, image->GetLargestPossibleRegion());


  //LabelImageIt.GoToBegin();

  //while (!LabelImageIt.IsAtEnd())
  //{
  //  LabelImageIt.Set(LabelImageIt.Get() / 33);
  //  ++LabelImageIt;
  //}
  //itk::ImageFileWriter<ImageType>::Pointer writer1 = itk::ImageFileWriter<ImageType>::New();
  //writer1->SetFileName(outputFilename);
  //writer1->SetInput(image);
  //writer1->Update();
  //return;

}

NiftiDataManager::~NiftiDataManager()
{
}
itk::Image<float,3>::Pointer NiftiDataManager::ReadNiftiImage(std::string filename)
{
	itk::Image<float,3>::Pointer image;
	itk::ImageIOBase::Pointer reader = itk::ImageIOFactory::CreateImageIO(filename.c_str(), itk::ImageIOFactory::ReadMode);
	if (!reader)
	{
		/*	mLastError = "Unable to read file.";
			return false;*/
	}

	reader->SetFileName(filename);
	reader->ReadImageInformation();
	std::string InputPixelType = reader->GetComponentTypeAsString(reader->GetComponentType());
	// unsigned int VImageDimension = reader->GetNumberOfDimensions();

		image = ReadImageWithDim<float, 3>(filename, InputPixelType);
	return image;
}

itk::Image<float, 4>::Pointer NiftiDataManager::Read4DNiftiImage(std::string filename)
{
	itk::Image<float, 4>::Pointer image;
	itk::ImageIOBase::Pointer reader = itk::ImageIOFactory::CreateImageIO(filename.c_str(), itk::ImageIOFactory::ReadMode);
	if (!reader)
	{
		/*	mLastError = "Unable to read file.";
		return false;*/
	}
	reader->SetFileName(filename);
	reader->ReadImageInformation();
	std::string InputPixelType = reader->GetComponentTypeAsString(reader->GetComponentType());
	// unsigned int VImageDimension = reader->GetNumberOfDimensions();
	image = ReadImageWithDim<float, 4>(filename, InputPixelType);
	return image;
}

void NiftiDataManager::LoadTrainingData(itk::Image<float, 3>::Pointer labelImagePointer,
	itk::Image<float, 3>::Pointer recurrenceMaskImage,
	itk::Image<float, 3>::Pointer nonrecurrenceMaskImage,
	itk::Image<float, 3>::Pointer t1ceImagePointer,
	itk::Image<float, 3>::Pointer t2flairImagePointer,
	itk::Image<float, 3>::Pointer t1ImagePointer,
	itk::Image<float, 3>::Pointer t2ImagePointer,
	itk::Image<float, 4>::Pointer perfImagePointerNifti,
	std::vector<itk::Image<float, 3>::Pointer> perfImagePointerDicom,
	itk::Image<float, 3>::Pointer axImagePointer,
	itk::Image<float, 3>::Pointer faImagePointer,
	itk::Image<float, 3>::Pointer radImagePointer,
	itk::Image<float, 3>::Pointer trImagePointer,
	VectorVectorDouble &pNearIntensities, 
  VectorVectorDouble &pFarIntensities, 
  VectorVectorDouble &mNearIntensities, 
  VectorVectorDouble &mFarIntensities, 
	std::vector< double > &tNearIntensities, 
	std::vector< double > &tFarIntensities, 
	int imagetype,
	bool useT1Data, bool useT2Data,bool useT1CEData,bool useT2FlairData,bool useDTIData,bool usePerfData,bool useDistData)
{
		typedef itk::Image<float, 3> ImageType;
		typedef itk::Image<float, 4> PerfusionImageType;
		std::vector<ImageType::IndexType> recurIndices;
		std::vector<ImageType::IndexType> nonrecurIndices;
		std::vector<ImageType::IndexType> tumorIndices;

    typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
    IteratorType LabelImageIt(labelImagePointer, labelImagePointer->GetLargestPossibleRegion());
    IteratorType RecMaskIt(recurrenceMaskImage, recurrenceMaskImage->GetLargestPossibleRegion());
    IteratorType NonRecMaskIt(nonrecurrenceMaskImage, nonrecurrenceMaskImage->GetLargestPossibleRegion());

    LabelImageIt.GoToBegin();
    RecMaskIt.GoToBegin();
    NonRecMaskIt.GoToBegin();

    while (!LabelImageIt.IsAtEnd())
    {
      if (LabelImageIt.Get() == 175 || LabelImageIt.Get() == 200)
        tumorIndices.push_back(LabelImageIt.GetIndex());
      if (RecMaskIt.Get() != 0)
        recurIndices.push_back(RecMaskIt.GetIndex());
      if (NonRecMaskIt.Get() != 0)
        nonrecurIndices.push_back(NonRecMaskIt.GetIndex());

      ++LabelImageIt;
      ++RecMaskIt;
      ++NonRecMaskIt;
    }
		int recurSize = recurIndices.size();
		int nonrecurSize = nonrecurIndices.size();
		//--------------------perfusion intensities---------------------
		FILE* p;
		p = fopen("p.txt", "w");
		FILE* o;
		o = fopen("o.txt", "w");
		FILE* t;
		t = fopen("t.txt", "w");
		if (usePerfData)
		{
			for (int i = 0; i < recurSize; i++)
			{
				std::vector<double> perfusionIntensitiesPerVoxel;
				PerfusionImageType::IndexType perfVoxelIndex;

				perfVoxelIndex[0] = recurIndices[i][0];
				perfVoxelIndex[1] = recurIndices[i][1];
				perfVoxelIndex[2] = recurIndices[i][2];

				for (int j = 0; j < 45; j++)
				{
					perfVoxelIndex[3] = j;
					perfusionIntensitiesPerVoxel.push_back(std::round(perfImagePointerNifti.GetPointer()->GetPixel(perfVoxelIndex)));
				}
				//fprintf(p, "%li %li %li %li ---- %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d \n", perfVoxelIndex[0], perfVoxelIndex[1], perfVoxelIndex[2], perfVoxelIndex[3], std::round(perfusionIntensitiesPerVoxel[0]), std::round(perfusionIntensitiesPerVoxel[1]), std::round(perfusionIntensitiesPerVoxel[2]),
				//	std::round(perfusionIntensitiesPerVoxel[3]), std::round(perfusionIntensitiesPerVoxel[4]), std::round(perfusionIntensitiesPerVoxel[5]),
				//	std::round(perfusionIntensitiesPerVoxel[6]), std::round(perfusionIntensitiesPerVoxel[7]), std::round(perfusionIntensitiesPerVoxel[8]), std::round(perfusionIntensitiesPerVoxel[9]), std::round(perfusionIntensitiesPerVoxel[10]),
				//	std::round(perfusionIntensitiesPerVoxel[11]), std::round(perfusionIntensitiesPerVoxel[12]), std::round(perfusionIntensitiesPerVoxel[13]), std::round(perfusionIntensitiesPerVoxel[14]), std::round(perfusionIntensitiesPerVoxel[15]),
				//	std::round(perfusionIntensitiesPerVoxel[16]), std::round(perfusionIntensitiesPerVoxel[17]), std::round(perfusionIntensitiesPerVoxel[18]), std::round(perfusionIntensitiesPerVoxel[19]), std::round(perfusionIntensitiesPerVoxel[20]),
				//	std::round(perfusionIntensitiesPerVoxel[21]), std::round(perfusionIntensitiesPerVoxel[22]), std::round(perfusionIntensitiesPerVoxel[23]), std::round(perfusionIntensitiesPerVoxel[24]), std::round(perfusionIntensitiesPerVoxel[25]),
				//	std::round(perfusionIntensitiesPerVoxel[26]), std::round(perfusionIntensitiesPerVoxel[27]), std::round(perfusionIntensitiesPerVoxel[28]), std::round(perfusionIntensitiesPerVoxel[29]), std::round(perfusionIntensitiesPerVoxel[30]),
				//	std::round(perfusionIntensitiesPerVoxel[31]), std::round(perfusionIntensitiesPerVoxel[32]), std::round(perfusionIntensitiesPerVoxel[33]), std::round(perfusionIntensitiesPerVoxel[34]), std::round(perfusionIntensitiesPerVoxel[35]),
				//	std::round(perfusionIntensitiesPerVoxel[36]), std::round(perfusionIntensitiesPerVoxel[37]), std::round(perfusionIntensitiesPerVoxel[38]), std::round(perfusionIntensitiesPerVoxel[39]), std::round(perfusionIntensitiesPerVoxel[40]),
				//	std::round(perfusionIntensitiesPerVoxel[41]), std::round(perfusionIntensitiesPerVoxel[42]), std::round(perfusionIntensitiesPerVoxel[43]), std::round(perfusionIntensitiesPerVoxel[44]));
				pNearIntensities.push_back(perfusionIntensitiesPerVoxel);
			}
			for (int i = 0; i < nonrecurSize; i++)
			{
				std::vector<double> perfusionIntensitiesPerVoxel;
				PerfusionImageType::IndexType perfVoxelIndex;

				perfVoxelIndex[0] = nonrecurIndices[i][0];
				perfVoxelIndex[1] = nonrecurIndices[i][1];
				perfVoxelIndex[2] = nonrecurIndices[i][2];
				for (int j = 0; j < 45; j++)
				{
					perfVoxelIndex[3] = j;
					perfusionIntensitiesPerVoxel.push_back(std::round(perfImagePointerNifti.GetPointer()->GetPixel(perfVoxelIndex)));
				}
				//fprintf(p, "%li %li %li %li ---- %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d \n", perfVoxelIndex[0], perfVoxelIndex[1], perfVoxelIndex[2], perfVoxelIndex[3], std::round(perfusionIntensitiesPerVoxel[0]), std::round(perfusionIntensitiesPerVoxel[1]), std::round(perfusionIntensitiesPerVoxel[2]),
				//	std::round(perfusionIntensitiesPerVoxel[3]), std::round(perfusionIntensitiesPerVoxel[4]), std::round(perfusionIntensitiesPerVoxel[5]),
				//	std::round(perfusionIntensitiesPerVoxel[6]), std::round(perfusionIntensitiesPerVoxel[7]), std::round(perfusionIntensitiesPerVoxel[8]), std::round(perfusionIntensitiesPerVoxel[9]), std::round(perfusionIntensitiesPerVoxel[10]),
				//	std::round(perfusionIntensitiesPerVoxel[11]), std::round(perfusionIntensitiesPerVoxel[12]), std::round(perfusionIntensitiesPerVoxel[13]), std::round(perfusionIntensitiesPerVoxel[14]), std::round(perfusionIntensitiesPerVoxel[15]),
				//	std::round(perfusionIntensitiesPerVoxel[16]), std::round(perfusionIntensitiesPerVoxel[17]), std::round(perfusionIntensitiesPerVoxel[18]), std::round(perfusionIntensitiesPerVoxel[19]), std::round(perfusionIntensitiesPerVoxel[20]),
				//	std::round(perfusionIntensitiesPerVoxel[21]), std::round(perfusionIntensitiesPerVoxel[22]), std::round(perfusionIntensitiesPerVoxel[23]), std::round(perfusionIntensitiesPerVoxel[24]), std::round(perfusionIntensitiesPerVoxel[25]),
				//	std::round(perfusionIntensitiesPerVoxel[26]), std::round(perfusionIntensitiesPerVoxel[27]), std::round(perfusionIntensitiesPerVoxel[28]), std::round(perfusionIntensitiesPerVoxel[29]), std::round(perfusionIntensitiesPerVoxel[30]),
				//	std::round(perfusionIntensitiesPerVoxel[31]), std::round(perfusionIntensitiesPerVoxel[32]), std::round(perfusionIntensitiesPerVoxel[33]), std::round(perfusionIntensitiesPerVoxel[34]), std::round(perfusionIntensitiesPerVoxel[35]),
				//	std::round(perfusionIntensitiesPerVoxel[36]), std::round(perfusionIntensitiesPerVoxel[37]), std::round(perfusionIntensitiesPerVoxel[38]), std::round(perfusionIntensitiesPerVoxel[39]), std::round(perfusionIntensitiesPerVoxel[40]),
				//	std::round(perfusionIntensitiesPerVoxel[41]), std::round(perfusionIntensitiesPerVoxel[42]), std::round(perfusionIntensitiesPerVoxel[43]), std::round(perfusionIntensitiesPerVoxel[44]));
				pFarIntensities.push_back(perfusionIntensitiesPerVoxel);
			}
		}
		//--------------------remaining intensities---------------------
		VectorVectorDouble mIntensitiesNearPoints;
		VectorVectorDouble mIntensitiesFarPoints;
		for (int i = 0; i < recurSize; i++)
		{
			std::vector<double> otherIntensitiesPerVoxel;
			if (useT1Data)
				otherIntensitiesPerVoxel.push_back(std::round(t1ImagePointer.GetPointer()->GetPixel(recurIndices[i])));
			if (useT1CEData)
				otherIntensitiesPerVoxel.push_back(std::round(t1ceImagePointer.GetPointer()->GetPixel(recurIndices[i])));
			if (useT2Data)
				otherIntensitiesPerVoxel.push_back(std::round(t2ImagePointer.GetPointer()->GetPixel(recurIndices[i])));
			if (useT2FlairData)
				otherIntensitiesPerVoxel.push_back(std::round(t2flairImagePointer.GetPointer()->GetPixel(recurIndices[i])));
			if (useDTIData)
			{
				otherIntensitiesPerVoxel.push_back(std::round(faImagePointer.GetPointer()->GetPixel(recurIndices[i])));
				otherIntensitiesPerVoxel.push_back(std::round(radImagePointer.GetPointer()->GetPixel(recurIndices[i])));
				otherIntensitiesPerVoxel.push_back(std::round(trImagePointer.GetPointer()->GetPixel(recurIndices[i])));
				otherIntensitiesPerVoxel.push_back(std::round(axImagePointer.GetPointer()->GetPixel(recurIndices[i])));
			}
			//ImageType::IndexType index = recurIndicesFinal[i];
			//int a = index[0];
			//int b = index[1];
			//int c = index[2];
			//fprintf(o, "%d %d %d                 %f %f %f %f       %f %f %f %f \n", a,b,c, std::round(otherIntensitiesPerVoxel[0]), std::round(otherIntensitiesPerVoxel[1]), std::round(otherIntensitiesPerVoxel[2]),
			//	std::round(otherIntensitiesPerVoxel[3]), std::round(otherIntensitiesPerVoxel[4]), std::round(otherIntensitiesPerVoxel[5]), std::round(otherIntensitiesPerVoxel[6]), std::round(otherIntensitiesPerVoxel[7]));
			mNearIntensities.push_back(otherIntensitiesPerVoxel);
		}
		for (int i = 0; i < nonrecurSize; i++)
		{
			std::vector<double> otherIntensitiesPerVoxel;
			if (useT1Data)
				otherIntensitiesPerVoxel.push_back(std::round(t1ImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
			if (useT1CEData)
				otherIntensitiesPerVoxel.push_back(std::round(t1ceImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
			if (useT2Data)
				otherIntensitiesPerVoxel.push_back(std::round(t2ImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
			if (useT2FlairData)
				otherIntensitiesPerVoxel.push_back(std::round(t2flairImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
			if (useDTIData)
			{
				otherIntensitiesPerVoxel.push_back(std::round(faImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
				otherIntensitiesPerVoxel.push_back(std::round(radImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
				otherIntensitiesPerVoxel.push_back(std::round(trImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
				otherIntensitiesPerVoxel.push_back(std::round(axImagePointer.GetPointer()->GetPixel(nonrecurIndices[i])));
			}
			//ImageType::IndexType index = nonrecurIndicesFinal[i];
			//int a = index[0];
			//int b = index[1];
			//int c = index[2];
			//fprintf(o, "%d %d %d                 %f %f %f %f       %f %f %f %f \n", a, b, c, otherIntensitiesPerVoxel[0], otherIntensitiesPerVoxel[1], otherIntensitiesPerVoxel[2],
			//	otherIntensitiesPerVoxel[3], otherIntensitiesPerVoxel[4], otherIntensitiesPerVoxel[5], otherIntensitiesPerVoxel[6], otherIntensitiesPerVoxel[7]);
			mFarIntensities.push_back(otherIntensitiesPerVoxel);
		}

		//---------------------------distance metric------------------------------------
    if (useDistData)
    {
      for (int i = 0; i < recurSize; i++)
      {
        ImageType::IndexType recurIndex = recurIndices[i];
        double distance = 0;
        double min = 100000000;

        for (unsigned int j = 0; j < tumorIndices.size(); j++)
        {
          ImageType::IndexType tumorIndex = tumorIndices[j];
          distance = std::sqrt(std::pow(recurIndex[0] - tumorIndex[0], 2) + std::pow(recurIndex[1] - tumorIndex[1], 2) + std::pow(recurIndex[2] - tumorIndex[2], 2));
          if (distance < min)
            min = distance;
        }
        tNearIntensities.push_back(min);
        //fprintf(t, "%d %d %d                 %f\n", recurIndex[0], recurIndex[1], recurIndex[2],min);
      }
      for (int i = 0; i < nonrecurSize; i++)
      {
        ImageType::IndexType nonrecurIndex = nonrecurIndices[i];
        double distance = 0;
        double min = 100000000;
        for (unsigned int j = 0; j < tumorIndices.size(); j++)
        {
          ImageType::IndexType tumorIndex = tumorIndices[j];
          distance = std::sqrt(std::pow(nonrecurIndex[0] - tumorIndex[0], 2) + std::pow(nonrecurIndex[1] - tumorIndex[1], 2) + std::pow(nonrecurIndex[2] - tumorIndex[2], 2));
          if (distance < min)
            min = distance;
        }
        tFarIntensities.push_back(min);
        //fprintf(t, "%d %d %d                 %f\n", nonrecurIndex[0], nonrecurIndex[1], nonrecurIndex[2], min);
      }
    }
		//------------------------------------------------------------------------------
		fclose(p);
		fclose(o);
		fclose(t);
}


std::vector<itk::Image<float,3>::IndexType> NiftiDataManager::LoadTestData(itk::Image<float, 3>::Pointer t1ceImagePointer,
	itk::Image<float, 3>::Pointer t2flairImagePointer,
	itk::Image<float, 3>::Pointer t1ImagePointer,
	itk::Image<float, 3>::Pointer t2ImagePointer,
	itk::Image<float, 4>::Pointer perfImagePointerNifti,
	std::vector<itk::Image<float, 3>::Pointer> perfImagePointerDicom,
	itk::Image<float, 3>::Pointer axImagePointer,
	itk::Image<float, 3>::Pointer faImagePointer,
	itk::Image<float, 3>::Pointer radImagePointer,
	itk::Image<float, 3>::Pointer trImagePointer,
	itk::Image<float, 3>::Pointer labelImagePointer,
	itk::Image<float, 3>::Pointer dilatedEdemaPointer,
	VectorVectorDouble & pIntensities,
	VectorVectorDouble & mIntensities,
	std::vector<double> & tIntensities, 
	int imagetype,
	bool useT1Data, bool useT2Data, bool useT1CEData, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData)
{
	typedef itk::Image<float, 3> ImageType;
	typedef itk::Image<float, 4> PerfusionImageType;
	FILE* p;
	p = fopen("p-test.txt", "w");
	FILE* o;
	o = fopen("o-test.txt", "w");
	FILE* t;
	t = fopen("t-test.txt", "w");
	FILE* ti;
	ti = fopen("ti-test.txt", "w");


	//-----------------------get edema and tumor pixels-----------------------
	std::vector<ImageType::IndexType> testIndices;
	std::vector<ImageType::IndexType> tumorIndices;
	typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
	IteratorType EdeIt(dilatedEdemaPointer, dilatedEdemaPointer->GetLargestPossibleRegion());

	EdeIt.GoToBegin();

	while (!EdeIt.IsAtEnd())
	{
		if (EdeIt.Get() == 100 || EdeIt.Get() == 255)
			testIndices.push_back(EdeIt.GetIndex());

		++EdeIt;
	}
	if (useDistData)
	{		
		IteratorType TumIt(labelImagePointer, labelImagePointer->GetLargestPossibleRegion());
		TumIt.GoToBegin();
		if (TumIt.Get() == 175 || TumIt.Get() == 200)
			tumorIndices.push_back(TumIt.GetIndex());
		++TumIt;
	}
	//--------------------perfusion intensities---------------------
	if (usePerfData)
	{
		PerfusionImageType::RegionType regionperf = perfImagePointerNifti->GetLargestPossibleRegion();
		for (unsigned int i = 0; i < testIndices.size(); i++)
		{
			std::vector<double> perfusionIntensitiesPerVoxel;
			PerfusionImageType::IndexType perfVoxelIndex;

			perfVoxelIndex[0] = testIndices[i][0];
			perfVoxelIndex[1] = testIndices[i][1];
			perfVoxelIndex[2] = testIndices[i][2];

			for (int j = 0; j < 45; j++)
			{
				perfVoxelIndex[3] = j;
				perfusionIntensitiesPerVoxel.push_back(perfImagePointerNifti.GetPointer()->GetPixel(perfVoxelIndex));
			}
			pIntensities.push_back(perfusionIntensitiesPerVoxel);
			//fprintf(p, "%d %d %d %d ---- %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f \n", perfVoxelIndex[0], perfVoxelIndex[1], perfVoxelIndex[2], perfVoxelIndex[3], std::round(perfusionIntensitiesPerVoxel[0]), std::round(perfusionIntensitiesPerVoxel[1]), std::round(perfusionIntensitiesPerVoxel[2]),
			//	std::round(perfusionIntensitiesPerVoxel[3]), std::round(perfusionIntensitiesPerVoxel[4]), std::round(perfusionIntensitiesPerVoxel[5]),
			//	std::round(perfusionIntensitiesPerVoxel[6]), std::round(perfusionIntensitiesPerVoxel[7]), std::round(perfusionIntensitiesPerVoxel[8]), std::round(perfusionIntensitiesPerVoxel[9]), std::round(perfusionIntensitiesPerVoxel[10]),
			//	std::round(perfusionIntensitiesPerVoxel[11]), std::round(perfusionIntensitiesPerVoxel[12]), std::round(perfusionIntensitiesPerVoxel[13]), std::round(perfusionIntensitiesPerVoxel[14]), std::round(perfusionIntensitiesPerVoxel[15]),
			//	std::round(perfusionIntensitiesPerVoxel[16]), std::round(perfusionIntensitiesPerVoxel[17]), std::round(perfusionIntensitiesPerVoxel[18]), std::round(perfusionIntensitiesPerVoxel[19]), std::round(perfusionIntensitiesPerVoxel[20]),
			//	std::round(perfusionIntensitiesPerVoxel[21]), std::round(perfusionIntensitiesPerVoxel[22]), std::round(perfusionIntensitiesPerVoxel[23]), std::round(perfusionIntensitiesPerVoxel[24]), std::round(perfusionIntensitiesPerVoxel[25]),
			//	std::round(perfusionIntensitiesPerVoxel[26]), std::round(perfusionIntensitiesPerVoxel[27]), std::round(perfusionIntensitiesPerVoxel[28]), std::round(perfusionIntensitiesPerVoxel[29]), std::round(perfusionIntensitiesPerVoxel[30]),
			//	std::round(perfusionIntensitiesPerVoxel[31]), std::round(perfusionIntensitiesPerVoxel[32]), std::round(perfusionIntensitiesPerVoxel[33]), std::round(perfusionIntensitiesPerVoxel[34]), std::round(perfusionIntensitiesPerVoxel[35]),
			//	std::round(perfusionIntensitiesPerVoxel[36]), std::round(perfusionIntensitiesPerVoxel[37]), std::round(perfusionIntensitiesPerVoxel[38]), std::round(perfusionIntensitiesPerVoxel[39]), std::round(perfusionIntensitiesPerVoxel[40]),
			//	std::round(perfusionIntensitiesPerVoxel[41]), std::round(perfusionIntensitiesPerVoxel[42]), std::round(perfusionIntensitiesPerVoxel[43]), std::round(perfusionIntensitiesPerVoxel[44]));
		}
	}
	//--------------------remaining intensities---------------------
	for (unsigned int i = 0; i < testIndices.size(); i++)
	{
		std::vector<double> otherIntensitiesPerVoxel;
		if (useT1Data)
			otherIntensitiesPerVoxel.push_back(t1ImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useT1CEData)
			otherIntensitiesPerVoxel.push_back(t1ceImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useT2Data)
			otherIntensitiesPerVoxel.push_back(t2ImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useT2FlairData)
			otherIntensitiesPerVoxel.push_back(t2flairImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useDTIData)
		{
			otherIntensitiesPerVoxel.push_back(faImagePointer.GetPointer()->GetPixel(testIndices[i]));
			otherIntensitiesPerVoxel.push_back(radImagePointer.GetPointer()->GetPixel(testIndices[i]));
			otherIntensitiesPerVoxel.push_back(trImagePointer.GetPointer()->GetPixel(testIndices[i]));
			otherIntensitiesPerVoxel.push_back(axImagePointer.GetPointer()->GetPixel(testIndices[i]));
		}
		if (otherIntensitiesPerVoxel.size()>0)
			mIntensities.push_back(otherIntensitiesPerVoxel);
		//ImageType::IndexType index = testIndices[i];
		//int a = index[0];
		//int b = index[1];
		//int c = index[2];
		//fprintf(o, "%d %d %d                 %f %f %f %f       %f %f %f %f \n", a,b,c, std::round(otherIntensitiesPerVoxel[0]), std::round(otherIntensitiesPerVoxel[1]), std::round(otherIntensitiesPerVoxel[2]),
		//	std::round(otherIntensitiesPerVoxel[3]), std::round(otherIntensitiesPerVoxel[4]), std::round(otherIntensitiesPerVoxel[5]), std::round(otherIntensitiesPerVoxel[6]), std::round(otherIntensitiesPerVoxel[7]));

	}
	//---------------------------distance metric------------------------------------
	if (useDistData)
	{
		for (unsigned int i = 0; i < testIndices.size(); i++)
		{
			ImageType::IndexType testIndex = testIndices[i];
			double min = 0;

			for (unsigned int j = 0; j < tumorIndices.size(); j++)
			{
				ImageType::IndexType tumorIndex = tumorIndices[j];
				double distance = std::sqrt(std::pow(testIndex[0] - tumorIndex[0], 2) + std::pow(testIndex[1] - tumorIndex[1], 2) + std::pow(testIndex[2] - tumorIndex[2], 2));
				if (j == 0)
					min = distance;
				else
				{
					if (distance < min)
						min = distance;
				}

			}
			tIntensities.push_back(min);
			//fprintf(t, "%d %d %d                 %f\n", testIndex[0], testIndex[1], testIndex[2], min);

		}
	}
	fclose(p);
	fclose(o);
	fclose(t);
	fclose(ti);
	return testIndices;
}

void NiftiDataManager::LoadTrainingData(itk::Image<float, 3>::Pointer labelImagePointer,
	VectorVectorDouble nearPoints,
	VectorVectorDouble farPoints,
	itk::Image<float, 3>::Pointer t1ceImagePointer,
	itk::Image<float, 3>::Pointer t2flairImagePointer,
	itk::Image<float, 3>::Pointer t1ImagePointer,
	itk::Image<float, 3>::Pointer t2ImagePointer,
	std::vector<itk::Image<float, 3>::Pointer> perfImagePointer,
	std::vector<itk::Image<float, 3>::Pointer> dtiImagePointer,
	VectorVectorDouble & pNearIntensities,
	VectorVectorDouble & pFarIntensities,
	VectorVectorDouble & mNearIntensities,
	VectorVectorDouble & mFarIntensities,
	std::vector< double > & tNearIntensities,
	std::vector< double > & tFarIntensities,
	int imagetype,
	bool useT1Data, bool useT2Data, bool useT1CEData, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData)
{
	typedef itk::Image<float, 3> ImageType;
	// typedef itk::Image<float, 4> PerfusionImageType;
	std::vector<ImageType::IndexType> recurIndices;
	std::vector<ImageType::IndexType> nonrecurIndices;
	std::vector<ImageType::IndexType> tumorIndices;

	typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
	IteratorType TumIt(labelImagePointer, labelImagePointer->GetLargestPossibleRegion());
	TumIt.GoToBegin();
	while (!TumIt.IsAtEnd())
	{
		if (TumIt.Get() == 175 || TumIt.Get() == 200)
			tumorIndices.push_back(TumIt.GetIndex());
		++TumIt;
	}
	std::vector<ImageType::IndexType> nearIndices;
	std::vector<ImageType::IndexType> farIndices;
	for (unsigned int i = 0; i < nearPoints.size(); i++)
	{
		ImageType::IndexType voxelIndex;
		voxelIndex[0] = nearPoints[i][0];
		voxelIndex[1] = nearPoints[i][1];
		voxelIndex[2] = nearPoints[i][2];
		nearIndices.push_back(voxelIndex);
	}
	for (unsigned int i = 0; i < farPoints.size(); i++)
	{
		ImageType::IndexType voxelIndex;
		voxelIndex[0] = farPoints[i][0];
		voxelIndex[1] = farPoints[i][1];
		voxelIndex[2] = farPoints[i][2];
		farIndices.push_back(voxelIndex);
	}
	//--------------------perfusion intensities---------------------
	if (usePerfData)
	{
		for (unsigned int i = 0; i < nearIndices.size(); i++)
		{
			std::vector<double> perfusionIntensitiesPerVoxel;
			for (int j = 0; j < 45; j++)
				perfusionIntensitiesPerVoxel.push_back(std::round(perfImagePointer[j].GetPointer()->GetPixel(nearIndices[i])));
			pNearIntensities.push_back(perfusionIntensitiesPerVoxel);
		}
		for (unsigned int i = 0; i < farIndices.size(); i++)
		{
			std::vector<double> perfusionIntensitiesPerVoxel;
			for (int j = 0; j < 45; j++)
				perfusionIntensitiesPerVoxel.push_back(std::round(perfImagePointer[j].GetPointer()->GetPixel(farIndices[i])));
			pFarIntensities.push_back(perfusionIntensitiesPerVoxel);
		}

	}
	//--------------------remaining intensities---------------------
	VectorVectorDouble mIntensitiesNearPoints, 
    mIntensitiesFarPoints;
	for (unsigned int i = 0; i < nearIndices.size(); i++)
	{
		std::vector<double> otherIntensitiesPerVoxel;

		if (useT1Data)
			otherIntensitiesPerVoxel.push_back(std::round(t1ImagePointer.GetPointer()->GetPixel(nearIndices[i])));
		if (useT1CEData)
			otherIntensitiesPerVoxel.push_back(std::round(t1ceImagePointer.GetPointer()->GetPixel(nearIndices[i])));
		if (useT2Data)
			otherIntensitiesPerVoxel.push_back(std::round(t2ImagePointer.GetPointer()->GetPixel(nearIndices[i])));
		if (useT2FlairData)
			otherIntensitiesPerVoxel.push_back(std::round(t2flairImagePointer.GetPointer()->GetPixel(nearIndices[i])));
		if (useDTIData)
		{
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[0].GetPointer()->GetPixel(nearIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[1].GetPointer()->GetPixel(nearIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[2].GetPointer()->GetPixel(nearIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[3].GetPointer()->GetPixel(nearIndices[i])));
		}
		mNearIntensities.push_back(otherIntensitiesPerVoxel);
	}
	for (unsigned int i = 0; i < farIndices.size(); i++)
	{
		std::vector<double> otherIntensitiesPerVoxel;
		if (useT1Data)
			otherIntensitiesPerVoxel.push_back(std::round(t1ImagePointer.GetPointer()->GetPixel(farIndices[i])));
		if (useT1CEData)
			otherIntensitiesPerVoxel.push_back(std::round(t1ceImagePointer.GetPointer()->GetPixel(farIndices[i])));
		if (useT2Data)
			otherIntensitiesPerVoxel.push_back(std::round(t2ImagePointer.GetPointer()->GetPixel(farIndices[i])));
		if (useT2FlairData)
			otherIntensitiesPerVoxel.push_back(std::round(t2flairImagePointer.GetPointer()->GetPixel(farIndices[i])));
		if (useDTIData)
		{
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[0].GetPointer()->GetPixel(farIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[1].GetPointer()->GetPixel(farIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[2].GetPointer()->GetPixel(farIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[3].GetPointer()->GetPixel(farIndices[i])));
		}
		mFarIntensities.push_back(otherIntensitiesPerVoxel);
	}

	//---------------------------distance metric------------------------------------
	if (useDistData)
	{
		for (unsigned int i = 0; i < nearIndices.size(); i++)
		{
			VariableLengthVectorType distances;
			distances.SetSize(tumorIndices.size());

			for (unsigned int j = 0; j < distances.Size(); j++)
				distances[j] = std::sqrt(std::pow(nearIndices[i][0] - tumorIndices[j][0], 2) + std::pow(nearIndices[i][1] - tumorIndices[j][1], 2) + std::pow(nearIndices[i][2] - tumorIndices[j][2], 2));

			double min = distances[0];
			for (unsigned int j = 1; j < distances.Size(); j++)
			{
				if (distances[j] < min)
					min = distances[j];
			}
			tNearIntensities.push_back(min);
		}
		for (unsigned int i = 0; i < farIndices.size(); i++)
		{
			VariableLengthVectorType distances;
			distances.SetSize(tumorIndices.size());

			for (unsigned int j = 0; j < distances.Size(); j++)
				distances[j] = std::sqrt(std::pow(farIndices[i][0] - tumorIndices[j][0], 2) + std::pow(farIndices[i][1] - tumorIndices[j][1], 2) + std::pow(farIndices[i][2] - tumorIndices[j][2], 2));

			double min = distances[0];
			for (unsigned int j = 1; j < distances.Size(); j++)
			{
				if (distances[j] < min)
					min = distances[j];
			}
			tFarIntensities.push_back(min);
		}
	}
}
std::vector<itk::Image<float, 3>::IndexType> NiftiDataManager::LoadTestData(itk::Image<float, 3>::Pointer t1ceImagePointer,
	itk::Image<float, 3>::Pointer t2flairImagePointer,
	itk::Image<float, 3>::Pointer t1ImagePointer,
	itk::Image<float, 3>::Pointer t2ImagePointer,
	std::vector<itk::Image<float, 3>::Pointer> perfImagePointer,
	std::vector<itk::Image<float, 3>::Pointer> dtiImagePointer,
	itk::Image<float, 3>::Pointer labelImagePointer,
	itk::Image<float, 3>::Pointer dilatedEdemaPointer,
	VectorVectorDouble & pIntensities,
	VectorVectorDouble & mIntensities,
	std::vector<double> & tIntensities,
	int imagetype,
	bool useT1Data, bool useT2Data, bool useT1CEData, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData)
{
	typedef itk::Image<float, 3> ImageType;
	////-----------------------get edema and tumor pixels-----------------------
	std::vector<ImageType::IndexType> testIndices;		
	typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
	IteratorType EdeIt(dilatedEdemaPointer, dilatedEdemaPointer->GetLargestPossibleRegion());
	EdeIt.GoToBegin();
	while (!EdeIt.IsAtEnd())
	{
		if (EdeIt.Get() == 100 || EdeIt.Get() == 255)
			testIndices.push_back(EdeIt.GetIndex());
		++EdeIt;
	}
	std::vector<ImageType::IndexType> tumorIndices;
	if (useDistData)
	{
		typedef itk::ImageRegionIteratorWithIndex <ImageType> IteratorType;
		IteratorType TumIt(labelImagePointer, labelImagePointer->GetLargestPossibleRegion());
		TumIt.GoToBegin();
		while (!EdeIt.IsAtEnd())
		{
			if (TumIt.Get() == 175 || TumIt.Get() == 200)
				tumorIndices.push_back(TumIt.GetIndex());
			++TumIt;
		}
	}

	//--------------------perfusion intensities---------------------
	if (usePerfData)
	{
		for (unsigned int i = 0; i < testIndices.size(); i++)
		{
			std::vector<double> perfusionIntensitiesPerVoxel;
			for (int j = 0; j < 45; j++)
				perfusionIntensitiesPerVoxel.push_back(perfImagePointer[j].GetPointer()->GetPixel(testIndices[i]));
			pIntensities.push_back(perfusionIntensitiesPerVoxel);
		}
	}
	//--------------------remaining intensities---------------------
	for (unsigned int i = 0; i < testIndices.size(); i++)
	{
		std::vector<double> otherIntensitiesPerVoxel;
		if (useT1Data)
			otherIntensitiesPerVoxel.push_back(t1ImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useT1CEData)
			otherIntensitiesPerVoxel.push_back(t1ceImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useT2Data)
			otherIntensitiesPerVoxel.push_back(t2ImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useT2FlairData)
			otherIntensitiesPerVoxel.push_back(t2flairImagePointer.GetPointer()->GetPixel(testIndices[i]));
		if (useDTIData)
		{
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[0].GetPointer()->GetPixel(testIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[1].GetPointer()->GetPixel(testIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[2].GetPointer()->GetPixel(testIndices[i])));
			otherIntensitiesPerVoxel.push_back(std::round(dtiImagePointer[3].GetPointer()->GetPixel(testIndices[i])));
		}
		if (otherIntensitiesPerVoxel.size()>0)
			mIntensities.push_back(otherIntensitiesPerVoxel);
	}
	//---------------------------distance metric------------------------------------
	if (useDistData)
	{
		for (unsigned int i = 0; i < testIndices.size(); i++)
		{
			ImageType::IndexType testIndex = testIndices[i];
			double min = 0;

			for (unsigned int j = 0; j < tumorIndices.size(); j++)
			{
				ImageType::IndexType tumorIndex = tumorIndices[j];
				double distance = std::sqrt(std::pow(testIndex[0] - tumorIndex[0], 2) + std::pow(testIndex[1] - tumorIndex[1], 2) + std::pow(testIndex[2] - tumorIndex[2], 2));
				if (j == 0)
					min = distance;
				else
				{
					if (distance < min)
						min = distance;
				}
			}
			tIntensities.push_back(min);
		}
	}
	return testIndices;
}