#ifndef _NiftiDataManager_h_
#define _NiftiDataManager_h_

#include "CBICA_Viewer.h"

class NiftiDataManager
{
public:
	NiftiDataManager();
	~NiftiDataManager();

	
	void LoadTrainingData(itk::Image<float, 3>::Pointer labelImagePointer,
		itk::Image<float, 3>::Pointer recurrenceMaskImage,
		itk::Image<float, 3>::Pointer nonrecurrenceMaskImage,
		itk::Image<float, 3>::Pointer t1ceImagePointer,
		itk::Image<float, 3>::Pointer t2flairImagePointer,
		itk::Image<float, 3>::Pointer t1ImagePointer,
		itk::Image<float, 3>::Pointer t2ImagePointer,
		itk::Image<float, 4>::Pointer perfImagePointerNifti,
		std::vector<itk::Image<float, 3>::Pointer> perfImagePointerDicom,
		itk::Image<float, 3>::Pointer axImagePointer,
		itk::Image<float, 3>::Pointer faImagePointer,
		itk::Image<float, 3>::Pointer radImagePointer,
		itk::Image<float, 3>::Pointer trImagePointer,
		VectorVectorDouble & pNearIntensities,
		VectorVectorDouble & pFarIntensities,
		VectorVectorDouble & mNearIntensities,
		VectorVectorDouble & mFarIntensities,
		std::vector< double > & tNearIntensities,
		std::vector< double > & tFarIntensities,
		int imagetype,
		bool useT1Data, bool useT2Data, bool useT1CEData, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData);

	void LoadTrainingData(itk::Image<float, 3>::Pointer labelImagePointer,
		VectorVectorDouble nearPoints,
		VectorVectorDouble farPoints,
		itk::Image<float, 3>::Pointer t1ceImagePointer,
		itk::Image<float, 3>::Pointer t2flairImagePointer,
		itk::Image<float, 3>::Pointer t1ImagePointer,
		itk::Image<float, 3>::Pointer t2ImagePointer,
		std::vector<itk::Image<float, 3>::Pointer> perfImagePointer,
		std::vector<itk::Image<float, 3>::Pointer> dtiImagePointer,
		VectorVectorDouble & pNearIntensities,
		VectorVectorDouble & pFarIntensities,
		VectorVectorDouble & mNearIntensities,
		VectorVectorDouble & mFarIntensities,
		std::vector< double > & tNearIntensities,
		std::vector< double > & tFarIntensities,
		int imagetype,
		bool useT1Data, bool useT2Data, bool useT1CEData, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData);

	std::vector<itk::Image<float, 3>::IndexType>  LoadTestData(itk::Image<float, 3>::Pointer t1ceImagePointer,
		itk::Image<float, 3>::Pointer t2flairImagePointer,
		itk::Image<float, 3>::Pointer t1ImagePointer,
		itk::Image<float, 3>::Pointer t2ImagePointer,
		itk::Image<float, 4>::Pointer perfImagePointerNifti,
		std::vector<itk::Image<float, 3>::Pointer> perfImagePointerDicom,
		itk::Image<float, 3>::Pointer axImagePointer,
		itk::Image<float, 3>::Pointer faImagePointer,
		itk::Image<float, 3>::Pointer radImagePointer,
		itk::Image<float, 3>::Pointer trImagePointer,
		itk::Image<float, 3>::Pointer labelImagePointer,
		itk::Image<float, 3>::Pointer dilatedEdemaPointer,
		VectorVectorDouble & pIntensities,
		VectorVectorDouble & mIntensities,
		std::vector< double > & tIntensities,
		int imagetype,
		bool useT1Data, bool useT2Data, bool useT1CEData, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData);

	std::vector<itk::Image<float, 3>::IndexType> LoadTestData(itk::Image<float, 3>::Pointer t1ceImagePointer,
		itk::Image<float, 3>::Pointer t2flairImagePointer,
		itk::Image<float, 3>::Pointer t1ImagePointer,
		itk::Image<float, 3>::Pointer t2ImagePointer,
		std::vector<itk::Image<float, 3>::Pointer> perfImagePointer,
		std::vector<itk::Image<float, 3>::Pointer> dtiImagePointer,
		itk::Image<float, 3>::Pointer labelImagePointer,
		itk::Image<float, 3>::Pointer dilatedEdemaPointer,
		VectorVectorDouble & pIntensities,
		VectorVectorDouble & mIntensities,
		std::vector<double> & tIntensities,
		int imagetype,
		bool useT1Data, bool useT2Data, bool useT1CEData, bool useT2FlairData, bool useDTIData, bool usePerfData, bool useDistData);



	itk::Image<float, 3>::Pointer ReadNiftiImage(std::string filename);
	itk::Image<float, 4>::Pointer Read4DNiftiImage(std::string filename);


	template<class InputPixelType, class OutputPixelType, unsigned int VImageDimension>
	typename itk::Image<float, VImageDimension>::Pointer  ReadImageWithDimAndInputPixelType(std::string filename);

	template<class OutputPixelType, unsigned int VImageDimension>
	typename itk::Image<float, VImageDimension>::Pointer  ReadImageWithDim(std::string filename, std::string InputPixelType);

};
template<class OutputPixelType, unsigned int VImageDimension>
typename itk::Image<float, VImageDimension>::Pointer  NiftiDataManager::ReadImageWithDim(std::string filename, std::string InputPixelType)
{
	if (InputPixelType == "short") 
	{
		return ReadImageWithDimAndInputPixelType<short, OutputPixelType, VImageDimension>(filename);
	}
	else if (InputPixelType == "unsigned_short") 
	{
		return ReadImageWithDimAndInputPixelType<unsigned short, OutputPixelType, VImageDimension>(filename);
	}
	else if (InputPixelType == "char") 
	{
		return ReadImageWithDimAndInputPixelType<char, OutputPixelType, VImageDimension>(filename);
	}
	else if (InputPixelType == "unsigned_char") 
	{
		return ReadImageWithDimAndInputPixelType<unsigned char, OutputPixelType, VImageDimension>(filename);
	}
	else if (InputPixelType == "int") 
	{
		return ReadImageWithDimAndInputPixelType<int, OutputPixelType, VImageDimension>(filename);
	}
	else if (InputPixelType == "unsigned_int") 
	{
		return ReadImageWithDimAndInputPixelType<unsigned int, OutputPixelType, VImageDimension>(filename);
	}
	else if (InputPixelType == "double") 
	{
		return ReadImageWithDimAndInputPixelType<double, OutputPixelType, VImageDimension>(filename);
	}
	else if (InputPixelType == "float") 
	{
		return ReadImageWithDimAndInputPixelType<float, OutputPixelType, VImageDimension>(filename);
	}
	else return NULL;
}
template<class InputPixelType, class OutputPixelType, unsigned int VImageDimension>
typename itk::Image<float, VImageDimension>::Pointer  NiftiDataManager::ReadImageWithDimAndInputPixelType(std::string filename)
{

	typedef itk::Image<InputPixelType, VImageDimension> InputImageType;
	typedef itk::Image<OutputPixelType, VImageDimension> OutputImageType;
	typedef itk::ImageFileReader<InputImageType> ReaderType;
	typename ReaderType::Pointer reader = ReaderType::New();
	typename OutputImageType::Pointer outputImage;
	try 
	{

		reader->SetFileName(filename);
		reader->ReleaseDataFlagOn();
		typename InputImageType::Pointer inputImage = reader->GetOutput();
		inputImage->Update();
		typedef itk::CastImageFilter< InputImageType, OutputImageType > CastFilterType;
		typename CastFilterType::Pointer castFilter = CastFilterType::New();
		castFilter->SetInput(inputImage);
		outputImage = castFilter->GetOutput();
		outputImage->Update();
	}
	catch (itk::ExceptionObject & err) 
	{
		std::cerr << "Error while reading " << filename.c_str() << " " << err << std::endl;
		std::stringstream error;
		error << err;
//		mLastError = error.str();
//		return;
	}
	return outputImage;
}
#endif
