///////////////////////////////////////////////////////////////////////////////////////
// SVMClassificationClass.h
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////
#pragma once

#include "stdio.h"
#include "SVMTrain.h"
#include "SVMTest.h"
#include "CBICA_Viewer.h"

class SVMClassificationClass
{
public:
	SVMTrain * mTrainingClassObject;
	SVMTest *  mTestingClassObject;
	svm_model * mTrainedModel;
	std::string mModelFile;
	std::string mLastEncounteredError;

	std::string GetLastEncounteredError()
	{
		return mLastEncounteredError;
	}
	std::string GetModelFileName()
	{
		return mModelFile;
	}
	void SetModelFileName(std::string filename)
	{
		mModelFile = filename;
	}
	SVMClassificationClass();
	~SVMClassificationClass();

	int Training(VariableSizeMatrixType &trainingdata, std::string &outputDirectory);
	VectorVectorDouble Testing(VariableSizeMatrixType &testdata, bool classmethod, std::string modelFileName);
};
