///////////////////////////////////////////////////////////////////////////////////////
// SVMTest.h
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////


//#include "stdafx.h"
#include "svm.h"
#include "CBICA_Viewer.h"

class SVMTest
{
public:
	struct svm_node *x;
	struct svm_model* model;
	int max_nr_attr;
	int predict_probability;
	char *line;
	int max_line_len;
	std::string mModelFileName;


	SVMTest()
  {    
	  max_nr_attr = 200;
	  predict_probability = 1;
  }

#if defined(__MSC_VER__)
  int(*info)(const char *fmt, ...) = &printf; // GCC handles c++11 tag in weird way
#endif

	void exit_input_error(int line_num);
	VectorVectorDouble predict(FILE *output, VariableSizeMatrixType &testdata);
  VectorVectorDouble main_test(VariableSizeMatrixType &testdata, bool existing, std::string &modelFileName);

	void SetModelFileName(std::string &filename)
	{
		mModelFileName = filename;
	}
};
