#ifndef _InteractorStyleNavigator_h_
#define _InteractorStyleNavigator_h_


#include "CBICA_Viewer.h"


#define VTKIS_WINDOW_LEVEL 1024
#define VTKIS_PICK         1025


class InteractorStyleNavigator : public vtkInteractorStyle
{
public:
	static InteractorStyleNavigator *New();
	vtkTypeRevisionMacro(InteractorStyleNavigator, vtkInteractorStyle);

	vtkGetVector2Macro(WindowLevelStartPosition, int);
	vtkGetVector2Macro(WindowLevelCurrentPosition, int);

	virtual void OnMouseMove();
	virtual void OnLeftButtonDown();
	virtual void OnLeftButtonUp();
	virtual void OnRightButtonDown();
	virtual void OnRightButtonUp();
	virtual void OnMiddleButtonDown();
	virtual void OnMiddleButtonUp();
	virtual void OnEnter();
	virtual void OnLeave();
	virtual void OnMouseWheelForward();
	virtual void OnMouseWheelBackward();
	virtual void OnChar();
	virtual void WindowLevel();
	virtual void Pick();
	virtual void StartWindowLevel();
	virtual void EndWindowLevel();
	virtual void StartPick();
	virtual void EndPick();
	virtual void Dolly();
	virtual void Pan();
	virtual void FindPokedRenderer(int, int);

protected:
	InteractorStyleNavigator();
	~InteractorStyleNavigator();

	static void ProcessEvents(vtkObject* object,
		unsigned long event,
		void* clientdata,
		void* calldata);

	double MotionFactor;

	virtual void Dolly(double factor);

	int WindowLevelStartPosition[2];
	int WindowLevelCurrentPosition[2];

private:
	InteractorStyleNavigator(const InteractorStyleNavigator&);
	void operator=(const InteractorStyleNavigator&);
};


#endif
