///////////////////////////////////////////////////////////////////////////////////////
// Landmarks.h
//
// Copyright (c) 2015. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: sbia-software@uphs.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _Landmarks_h_
#define _Landmarks_h_


#include "CBICA_Viewer.h"


#define LANDMARK_TYPE_NONE -1
#define LANDMARK_TYPE_LANDMARKS 0
#define LANDMARK_TYPE_SEED_POINTS 1
#define LANDMARK_TYPE_TISSUE_POINTS 2

#define LANDMARK_MAX_LANDMARKS 200
#define LANDMARK_MAX_SEED_POINTS 10
//#define LANDMARK_MAX_TISSUE_POINTS 11
#define LANDMARK_MAX_TISSUE_POINTS 300

#define MaxNumberOFTumorSeeds	10
#define MaxNumberOFPoints		100

//#define NumberOfPriorChannels_GLISTR 10
//static const char label_GLISTR[NumberOfPriorChannels_GLISTR][32] = { "BG", "CSF", "GM", "WM", "VS", "ED", "NCR", "TU", "NE", "CB" };
//#define NumberOfPriorChannels_PORTRPre 9
//static const char label_PORTRPre[NumberOfPriorChannels_PORTRPre][32] = { "BG", "CSF", "VT", "GM", "WM", "VS", "ED", "NCR", "TU" };
//static const char label2_PORTRPre[NumberOfPriorChannels_PORTRPre][32] = { "BG", "CSF", "VT", "GM", "WM", "VEIN", "ED", "NCR", "TU" };
//static const char label3_PORTRPre[NumberOfPriorChannels_PORTRPre][32] = { "BG", "CSF", "VT", "GM", "WM", "VEINS", "ED", "NCR", "TU" };
//#define NumberOfPriorChannels_PORTRPost 11
//static const char label_PORTRPost[NumberOfPriorChannels_PORTRPost][32] = { "BG", "CSF", "VT", "GM", "WM", "VS", "ED", "CAN", "CAE", "RTN", "RTE" };
//static const char label2_PORTRPost[NumberOfPriorChannels_PORTRPost][32] = { "BG", "CSF", "VT", "GM", "WM", "VEIN", "ED", "NCR", "TU", "RTN", "RTE" };
//static const char label3_PORTRPost[NumberOfPriorChannels_PORTRPost][32] = { "BG", "CSF", "VT", "GM", "WM", "VEINS", "ED", "NCR", "TU", "RTN", "RTE" };


#define NumberOfPriorChannels 15
static const char labels[NumberOfPriorChannels][32] = { "BG", "CSF", "GM", "WM", "VS", "ED", "NCR", "TU", "NE", "CB","VT","CAN","CAE","RTN","RTE"};



struct sLandmark {
	bool bValid;
	//
	float coordinates[3];
	float image_coordinates[3];
	double pixel_value;
	float radius;
	int id;
};


class Landmarks
{
public :
	Landmarks(int type);
	~Landmarks();
	bool AddLandmark(float x, float y, float z, float r, double value, int id);
	bool SetLandmark(int index, float x, float y, float z, float r, double value, int id);
	bool RemoveLastLandmark();
	bool RemoveLandmark(int index);
	unsigned int GetNumberOfPoints() { return (unsigned int) mLandmarks.size(); }
	void UpdateData();
	void Clear();

	int mType;
	std::vector<sLandmark> mLandmarks;
	vtkPoints* mPoint;
	vtkFloatArray* mRadius;
	vtkFloatArray* mLandID;
	vtkPolyData* mLandDataWithID;
	vtkPolyData* mLandDataWithRadius;
};


#endif
