///////////////////////////////////////////////////////////////////////////////////////
// SimpleImageManager.cpp
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////

#include "SimpleImageManager.h"
#include "NiftiDataManager.h"

SimpleImageManager::SimpleImageManager()
{
	mPathFileName = "";
	mFileName = "";
	mBaseFileName = "";
	mLastEncounteredError = "";
	mDTIObject = new cbica::DTIProcessingManager();
	mImageType = IMAGE_TYPE_UNDEFINED;
	mImageSubType = IMAGE_TYPE_UNDEFINED;
	mLoadingType = IMAGE_TYPE_UNDEFINED;
}

SimpleImageManager::~SimpleImageManager()
{
}

bool SimpleImageManager::ReadGivenNonViewingNiftiImage(std::string directoryname, int subimagetype)
{
	itk::Image<float, 3>::Pointer image;
	itk::ImageIOBase::Pointer reader = itk::ImageIOFactory::CreateImageIO(directoryname.c_str(), itk::ImageIOFactory::ReadMode);
	if (!reader)
		return false;

	reader->SetFileName(directoryname);
	reader->ReadImageInformation();
	std::string InputPixelType = reader->GetComponentTypeAsString(reader->GetComponentType());
	// unsigned int VImageDimension = reader->GetNumberOfDimensions();

	NiftiDataManager * obj = new NiftiDataManager();
	if (subimagetype == IMAGE_TYPE_DTI)
		this->mNVImageSeriesReaderPointer.push_back(obj->ReadNiftiImage(directoryname));
	if (subimagetype == IMAGE_TYPE_PERFUSION)
		this->mPerfusionImagePointer = obj->Read4DNiftiImage(directoryname);
	return true;
}


bool SimpleImageManager::ReadGivenNonViewingDicomImage(std::string directoryname,int imagetype)
{
	std::string FileName = GetFileNameInADicomDirectory(QString::fromStdString(directoryname));
	unsigned int VImageDimension = 0;
	std::string InputPixelType = "";
	std::string OutputPixelType = "";

	itk::ImageIOBase::Pointer reader = itk::ImageIOFactory::CreateImageIO(FileName.c_str(), itk::ImageIOFactory::ReadMode);
	if (!reader) 
	{
		mLastEncounteredError = "Unable to read given file.";
		return false;
	}
	reader->SetFileName(FileName);
	reader->ReadImageInformation();
	InputPixelType = reader->GetComponentTypeAsString(reader->GetComponentType());
	OutputPixelType = reader->GetComponentTypeAsString(reader->GetComponentType());
	VImageDimension = reader->GetNumberOfDimensions();

	if (VImageDimension == 2)
		ReadImageWithGivenDimensionValue<2>(directoryname, InputPixelType, imagetype);
	else
		ReadImageWithGivenDimensionValue<3>(directoryname, InputPixelType, imagetype);

	return true;
}
std::string SimpleImageManager::GetFileNameInADicomDirectory(QString directoryname)
{
	std::string FirstFileName = "";
	QDirIterator directoryIterator(directoryname, QStringList() << "*.dcm", QDir::Files, QDirIterator::Subdirectories);
	while (directoryIterator.hasNext())
	{
		FirstFileName = directoryIterator.next().toStdString();
		break;
	}
	return FirstFileName;
}


