

///////////////////////////////////////////////////////////////////////////////////////
// Slicer.h
//
// Copyright (c) 2015. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: sbia-software@uphs.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _Slicer_h_
#define _Slicer_h_


#include "CBICA_Viewer.h"
#include "Landmarks.h"
#include "QBorderWidget.h"

class Slicer : public vtkImageViewer2
{
public:
	Slicer();
	~Slicer();

	static Slicer *New();
	vtkTypeRevisionMacro(Slicer, vtkImageViewer2);

	void SetImage(vtkImageData* image, vtkTransform* transform);
	vtkImageData* GetImage() {
		return mImage;
	}
	vtkTransform* GetTransform() {
		return mTransform;
	}
	void SetOverlay(vtkImageData* overlay);
	vtkImageData* GetOverlay()
	{
		return mOverlay;
	}
	void SetOverlayOpacity(double opacity);
	void RemoveOverlay();
	void SetMask(vtkImageData* mask);
	vtkImageData* GetMask()
	{
		return mMask;
	}
	void SetMaskOpacity(double opacity);
	void RemoveMask();

	void SetLandmarks(Landmarks* landmarks, int type);
	void SetSliceOrientation(int orientation);
	void SetSlice(int s);

	void SetOpacity(double s);
	void SetRenderWindow(int orientation, vtkRenderWindow * rw);
	void SetDisplayMode(bool i);
	void FlipHorizontalView();
	void FlipVerticalView();
	static double GetScalarComponentAsDouble(vtkImageData *image, double X, double Y, double Z, int &ix, int &iy, int &iz, int component = 0);
	void Render();
	void ResetCamera();

	void SetInitPosition();
	void SetCurrentPosition(double x, double y, double z);
	double* GetCurrentPosition() {
		return mCurrent;
	}
	double* GetCursorPosition() {
		return mCursor;
	}
	void UpdateCursorPosition();
	void SetCursorVisibility(bool s);
	bool GetCursorVisibility();
	void SetActive(bool active);
	bool GetActive();
	void SetCursorColor(double r, double g, double b);
	void SetCornerAnnotationVisibility(bool s);
	bool GetCornerAnnotationVisibility();
	void SetLandmarksVisibility(bool s);
	bool GetLandmarksVisibility();

	void UpdateLandmarks();
	void ForceUpdateDisplayExtent();

	virtual void SetColorWindow(double s);
	virtual void SetColorLevel(double s);

	int* GetDisplayExtent();
	int GetOrientation();
	void UpdateOrientation();
	void UpdateDisplayExtent();

	void AdjustResliceToSliceOrientation(vtkImageReslice *reslice);
	void ConvertImageToImageDisplayExtent(vtkImageData *sourceImage, const int sourceExtent[6], vtkImageData *targetImage, int targetExtent[6]);
	void ClipDisplayedExtent(int extent[6], int refExtent[6]);

	bool mActive;

	int mCursorVisibility;
	int mCornerAnnotationVisibility;
	int mLandmarksVisibility;

	vtkSmartPointer<vtkImageData> mImage;
	vtkSmartPointer<vtkImageData> mOverlay;
	vtkSmartPointer<vtkImageData> mMask;
	vtkSmartPointer<vtkTransform> mTransform;
	Landmarks* mLandmarks;
	int mLandmarksType;

	vtkSmartPointer<vtkImageReslice> mImageReslice;
	vtkSmartPointer<vtkCornerAnnotation> ca;
	vtkSmartPointer<vtkCursor2D> crossCursor;
	vtkSmartPointer<vtkPolyDataMapper2D> pdm;
	vtkSmartPointer<vtkActor2D> pdmA;
	//
	vtkSmartPointer<vtkImageReslice> mOverlayReslice;
	vtkSmartPointer<vtkImageActor> mOverlayActor;
	vtkSmartPointer<vtkImageMapToWindowLevelColors> mOverlayMapper;
	double mOverlayOpacity;
	//
	vtkSmartPointer<vtkImageReslice> mMaskReslice;
	vtkSmartPointer<vtkImageActor> mMaskActor;
	vtkSmartPointer<vtkImageMapToColors> mMaskMapper;
	double mMaskOpacity;
	//
	vtkSmartPointer<vtkBox> mClipBox;
	//
	vtkSmartPointer<vtkCursor3D> mCross;
	vtkSmartPointer<vtkGlyph3D> mLandGlyph;
	vtkSmartPointer<vtkClipPolyData> mLandClipper;
	vtkSmartPointer<vtkPolyDataMapper> mLandMapper;
	vtkSmartPointer<vtkActor> mLandActor;
	//
	vtkSmartPointer<vtkVertexGlyphFilter> mLandLabelGlyph;
	vtkSmartPointer<vtkClipPolyData> mLandLabelClipper;
	vtkSmartPointer<vtkLabeledDataMapper> mLandLabelMapper;
	vtkSmartPointer<vtkActor2D> mLandLabelActor;
	//
	vtkSmartPointer<vtkRegularPolygonSource> mCircle;
	vtkSmartPointer<vtkGlyph3D> mLandRadiusGlyph;
	vtkSmartPointer<vtkClipPolyData> mLandRadiusClipper;
	vtkSmartPointer<vtkPolyDataMapper> mLandRadiusMapper;
	vtkSmartPointer<vtkActor> mLandRadiusActor;

	double mCurrent[3];
	double mCursor[3];

	vtkSmartPointer<vtkBorderWidget> borderWidget;
	vtkBorderCallback * borderCallback;

};


#endif
