///////////////////////////////////////////////////////////////////////////////////////
// fBottomImageInfoTip.cpp
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////


#include "fBottomImageInfoTip.h"

fBottomImageInfoTip::fBottomImageInfoTip(QWidget * parent):QWidget(parent)
{
	setupUi(this);

	imageLabel->setText("                                                                                  ");
	originLabel->setText("                                                                                  ");
	spacingLabel->setText("                                                                                  ");
	sizePixelLabel->setText("                                                                                  ");

	connect(pixelPosButton, SIGNAL(clicked()), this, SLOT(pixelPosButtonClicked()));
	connect(worldPosButton, SIGNAL(clicked()), this, SLOT(worldPosButtonClicked()));
	connect(worldPos2Button, SIGNAL(clicked()), this, SLOT(worldPos2ButtonClicked()));
}

void fBottomImageInfoTip::setFileName(QString text)
{
	imageLabel->setText(text);
}

void fBottomImageInfoTip::setSizePixel(double x, double y, double z)
{
	QString text = "";
	text += QString::number((int)x) + "  ";
	text += QString::number((int)y) + "  ";
	text += QString::number((int)z) + "  ";
	sizePixelLabel->setText(text);
}

void fBottomImageInfoTip::setOrigin(double x, double y, double z)
{
	QString text = "";
	text += QString::number(x,'f',3) + "  ";
	text += QString::number(y,'f',3) + "  ";
	text += QString::number(z,'f',3) + "  ";
	originLabel->setText(text);
}

void fBottomImageInfoTip::setSpacing(double x, double y, double z)
{
	QString text = "";
	text += QString::number(x,'f',3) + "  ";
	text += QString::number(y,'f',3) + "  ";
	text += QString::number(z,'f',3) + "  ";
	spacingLabel->setText(text);
}

void fBottomImageInfoTip::setCurrentInfo(int visibility, double x, double y, double z, double X, double Y, double Z, double value)
{
	visibility = 1;
	//
	if (visibility) {
		worldPosX->setText(QString::number(x, 'f', 3));
		worldPosY->setText(QString::number(y, 'f', 3));
		worldPosZ->setText(QString::number(z, 'f', 3));

		worldPos2X->setText(QString::number(-x, 'f', 3));
		worldPos2Y->setText(QString::number(-y, 'f', 3));
		worldPos2Z->setText(QString::number(z, 'f', 3));

		pixelPosX->setText(QString::number((int)X));
		pixelPosY->setText(QString::number((int)Y));
		pixelPosZ->setText(QString::number((int)Z));

		valueLabel->setText(QString::number(value));
	}
	else 
	{
		worldPosX->setText(QString(""));
		worldPosY->setText(QString(""));
		worldPosZ->setText(QString(""));

		worldPos2X->setText(QString(""));
		worldPos2Y->setText(QString(""));
		worldPos2Z->setText(QString(""));

		pixelPosX->setText(QString(""));
		pixelPosY->setText(QString(""));
		pixelPosZ->setText(QString(""));

		valueLabel->setText(QString(""));
	}
}

void fBottomImageInfoTip::pixelPosButtonClicked()
{
	double X, Y, Z;
	X = pixelPosX->text().toDouble();
	Y = pixelPosY->text().toDouble();
	Z = pixelPosZ->text().toDouble();
	emit MoveSlicerCursor(X, Y, Z, 1);
}
void fBottomImageInfoTip::worldPosButtonClicked()
{
	double x, y, z;
	x = worldPosX->text().toDouble();
	y = worldPosY->text().toDouble();
	z = worldPosZ->text().toDouble();
	emit MoveSlicerCursor(x, y, z, 0);
}
void fBottomImageInfoTip::worldPos2ButtonClicked()
{
	double x, y, z;
	x = -worldPos2X->text().toDouble();
	y = -worldPos2Y->text().toDouble();
	z = worldPos2Z->text().toDouble();
	emit MoveSlicerCursor(x, y, z, 0);
}
