///////////////////////////////////////////////////////////////////////////////////////
// fDrawingPanel.cxx
// Copyright (c) 2015. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
// Contact details: sbia-software@uphs.upenn.edu
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#include "fDrawingPanel.h"
#include "CBICA_Viewer.h"
#include "fMainWindow.h"
#include "SlicerManager.h"
#include "Landmarks.h"
#include <QtSvg>
#include "qimage.h"

//static fMainWindow* getMainWindow()
//{
//	QWidgetList widgets = qApp->topLevelWidgets();
//	for (QWidgetList::iterator i = widgets.begin(); i != widgets.end(); ++i)
//	{
//		if ((*i)->objectName() == "MainWindow")
//		{
//			return qobject_cast<fMainWindow*>(*i);
//		}
//	}
//	return qobject_cast<fMainWindow*>(qApp->activeWindow());
//}
/*
inline QIcon makeQIconFromSVGFile(const QString &inputSVGFile)
{
  QSvgRenderer svgRenderer(inputSVGFile);
  Q_ASSERT(svgRenderer.isValid());
  QPixmap pix(svgRenderer.defaultSize());
  QPainter pixPainter(&pix);
  svgRenderer.render(&pixPainter);
  return QIcon(pix);
}
*/
fDrawingPanel::fDrawingPanel(QWidget * parent) : QWidget(parent)
{
	setupUi(this);
	sizeComboBox->insertItem(0, "   1x1");
	sizeComboBox->insertItem(1, "   2x2");
	sizeComboBox->insertItem(2, "   3x3");
	sizeComboBox->insertItem(3, "   4x4");
	sizeComboBox->insertItem(4, "   5x5");
	sizeComboBox->insertItem(5, "   6x6");
	sizeComboBox->insertItem(6, "   7x7");
	sizeComboBox->insertItem(7, "   8x8");
	sizeComboBox->insertItem(8, "   9x9");
  
  drawNearButton->setText(QString("Near ROI"));
  drawNearButton->setToolTip(QString("Draw near ROI points in the image"));

  drawFarButton->setText(QString("Far ROI"));
  drawFarButton->setToolTip(QString("Draw far ROI points in the image"));

  escapeButton->setText(QString("View Mode"));
  escapeButton->setToolTip(QString("Escape from current view"));

  eraseSelectedDrawingButton->setText(QString("Individual voxels"));
  eraseSelectedDrawingButton->setToolTip(QString("Erase selected drawing from the image"));
  
  eraseNearDrawingButton->setText(QString("Near ROI"));
  eraseNearDrawingButton->setToolTip(QString("Erase near drawing from the image"));
  
  eraseFarDrawingButton->setText(QString("Far ROI"));
  eraseFarDrawingButton->setToolTip(QString("Erase far drawing from the image"));
  
  //eraseInitDrawingButton->setText(QString("EraseINITDrawing"));
  //eraseInitDrawingButton->setToolTip(QString("Erase initialization drawing from the image"));
  
  //saveDrawingButton->setText(QString("SaveDrawing"));
  //saveDrawingButton->setToolTip(QString("Save drawing as an image"));
  //
  //loadDrawingButton->setText(QString("LoadDrawing"));
  //loadDrawingButton->setToolTip(QString("Load previously saved drawing - needs to be in same image space"));
  
  //saveSeedDrawingButton->setText(QString("SaveSeedDrawing"));
  //saveSeedDrawingButton->setToolTip(QString("Save seed drawing"));
  //
  //loadSeedDrawingButton->setText(QString("LoadSeedDrawing"));
  //loadSeedDrawingButton->setToolTip(QString("Load seed drawing"));
  //drawNearButton->setIcon(            makeQIconFromSVGFile(QString(ICON_DIR) + "/DrawNearIcon.png"     ));
  //drawFarButton->setIcon(             makeQIconFromSVGFile(QString(ICON_DIR) + "/DrawFarIcon.svg"));
  //drawInitButton->setIcon(            makeQIconFromSVGFile(QString(ICON_DIR) + "/DrawInitIcon.jpg"     ));
  //escapeButton->setIcon(              makeQIconFromSVGFile(QString(ICON_DIR) + "/EscapeIcon.png"       ));
  //eraseDrawingButton->setIcon(        makeQIconFromSVGFile(QString(ICON_DIR) + "/EraseIcon.png"        ));
  //eraseSelectedDrawingButton->setIcon(makeQIconFromSVGFile(QString(ICON_DIR) + "/eraseSelectedIcon.png"));
  //eraseNearDrawingButton->setIcon(    makeQIconFromSVGFile(QString(ICON_DIR) + "/EraseNearIcon.png"    ));
  //eraseFarDrawingButton->setIcon(     makeQIconFromSVGFile(QString(ICON_DIR) + "/EraseFarIcon.png"     ));
  //eraseInitDrawingButton->setIcon(    makeQIconFromSVGFile(QString(ICON_DIR) + "/EraseInitIcon.png"    ));
  //saveDrawingButton->setIcon(         makeQIconFromSVGFile(QString(ICON_DIR) + "/SaveDrawingIcon.png"  ));
  //loadDrawingButton->setIcon(         makeQIconFromSVGFile(QString(ICON_DIR) + "/LoadDrawingIcon.png"  ));
  //saveSeedDrawingButton->setIcon(     makeQIconFromSVGFile(QString(ICON_DIR) + "/RegisterIcon.png"     ));
  //loadSeedDrawingButton->setIcon(     makeQIconFromSVGFile(QString(ICON_DIR) + "/LoadDrawingIcon.png"  ));

	connect(drawNearButton,				SIGNAL(clicked()), this, SLOT(DrawNearButton()));
	connect(drawFarButton,				SIGNAL(clicked()), this, SLOT(DrawFarButton()));
	//connect(drawInitButton,				SIGNAL(clicked()), this, SLOT(DrawInitButton()));
	connect(escapeButton,				SIGNAL(clicked()), this, SLOT(EscapeButton()));
	//connect(eraseDrawingButton,			SIGNAL(clicked()), this, SLOT(EraseAllButton()));
	connect(eraseSelectedDrawingButton, SIGNAL(clicked()), this, SLOT(EraseSelectedButton()));
	connect(eraseNearDrawingButton,		SIGNAL(clicked()), this, SLOT(EraseNearButton()));
	connect(eraseFarDrawingButton,		SIGNAL(clicked()), this, SLOT(EraseFarButton()));
	//connect(eraseInitDrawingButton,		SIGNAL(clicked()), this, SLOT(EraseInitButton()));
	//connect(saveDrawingButton,			SIGNAL(clicked()), this, SLOT(SaveDrawingButton()));
	//connect(loadDrawingButton,			SIGNAL(clicked()), this, SLOT(LoadDrawingButton()));
	//connect(saveSeedDrawingButton,		SIGNAL(clicked()), this, SLOT(SaveSeedDrawingButton()));
	//connect(loadSeedDrawingButton,		SIGNAL(clicked()), this, SLOT(LoadSeedDrawingButton()));
	connect(sizeComboBox, SIGNAL(currentIndexChanged(int)), this, SLOT(CurrentSizeChanged(int)));
}

void fDrawingPanel::DrawNearButton()
{
	emit DrawNearButtonClicked();
}
void fDrawingPanel::DrawFarButton()
{
	emit DrawFarButtonClicked();
}
//void fDrawingPanel::DrawInitButton()
//{
//	emit DrawInitButtonClicked();
//}
void fDrawingPanel::EscapeButton()
{
	emit EscapeButtonClicked();
}
//void fDrawingPanel::EraseAllButton()
//{
//	emit EraseAllButtonClicked();
//}
void fDrawingPanel::EraseSelectedButton()
{
	emit EraseSelectedButtonClicked();
}
void fDrawingPanel::EraseNearButton()
{
	emit EraseNearButtonClicked();
}
void fDrawingPanel::EraseFarButton()
{
	emit EraseFarButtonClicked();
}
//void fDrawingPanel::EraseInitButton()
//{
//	emit EraseInitButtonClicked();
//}
//void fDrawingPanel::SaveDrawingButton()
//{
//	emit SaveDrawingButtonClicked();
//}
//void fDrawingPanel::LoadDrawingButton()
//{
//	emit LoadDrawingButtonClicked();
//}

//void fDrawingPanel::SaveSeedDrawingButton()
//{
//	emit SaveSeedDrawingButtonClicked();
//}
//void fDrawingPanel::LoadSeedDrawingButton()
//{
//	emit LoadSeedDrawingButtonClicked();
//}



void fDrawingPanel::CurrentSizeChanged(int size)
{
	emit CurrentBrushSizeChanged(size);
}