///////////////////////////////////////////////////////////////////////////////////////
// fProgressDialog.cpp
// Developed by Saima Rathore
// Copyright (c) 2014 University of Pennsylvania. All rights reserved.
// See http://www.cbica.upenn.edu/sbia/software/license.html or COYPING file.
// Contact: SBIA Group <sbia-software at uphs.upenn.edu>
///////////////////////////////////////////////////////////////////////////////////////


#include "fProgressDialog.h"


fProgressDialog::fProgressDialog(std::string message, bool show_progress) 
{
	setupUi(this);
	textLabel->setText(message.c_str());
	if (show_progress) {
		progressBar->show();
	} else {
		progressBar->hide();
	}
	this->show();
}

void fProgressDialog::SetText(std::string message)
{
	textLabel->setText(message.c_str());
}

void fProgressDialog::AddToText(std::string message)
{
	textLabel->setText(QString("%1\n%2").arg(textLabel->text()).arg(message.c_str()));
}

void fProgressDialog::SetProgress(unsigned int current, unsigned int max)
{
	progressBar->setMaximum(max);
	progressBar->setValue(current);
}
