///////////////////////////////////////////////////////////////////////////////////////
// fRecurrenceDialog.h
//
// Copyright (c) 2015. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: sbia-software@uphs.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _fRecurrenceDialog_h_
#define _fRecurrenceDialog_h_


#include "CBICA_Viewer.h"
#include "ui_fRecurrenceDialog.h"

#define SUBJECT_CLASSIFICATION 0
#define EXISTING_CLASSIFICATION 1
#define TRAIN_MODEL 2

class fRecurrenceDialog : public QDialog, private Ui::fRecurrenceDialog
{
	Q_OBJECT

public:
	fRecurrenceDialog();
	~fRecurrenceDialog();
	int mode;


public slots:
	void CancelButtonPressed();
	void ConfirmButtonPressed();
	void OpenSVMModelFile();
	void OpenExistingMasksDirectory();
	void SelectOutputDirectory();
	void ExistingClassificationRadioButtonChecked();
	void NewModelRadioButtonChecked();
	void OpenTestSubjectsDirectory();
	void ShowMessage(std::string msg);

signals:
	void SubjectBasedRecurrenceEstimate(std::string outputdirectory, bool cbT1Data, bool cbT1ceData, bool cbT2Data, bool cbT2FlairData, bool cbDTIData, bool cbPerfData,bool cbDistanceData);
	void ExistingModelBasedRecurrenceEstimate(std::string modeldirectory,std::string inputdirectory, std::string outputdirectory, bool cbT1Data, bool cbT1ceData, bool cbT2Data, bool cbT2FlairData, bool cbDTIData, bool cbPerfData, bool cbDistanceData);
	void TrainNewModel(std::string directory, std::string outputdirectory, bool cbT1Data, bool cbT1ceData, bool cbT2Data, bool cbT2FlairData, bool cbDTIData, bool cbPerfData, bool cbDistanceData);
};


#endif





