///////////////////////////////////////////////////////////////////////////////////////
// fTumorPanel.h
//
// Copyright (c) 2015. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: sbia-software@uphs.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _fTumorPanel_h_
#define _fTumorPanel_h_

#include "CBICA_Viewer.h"
#include "Landmarks.h"
#include "ui_fTumorPanel.h"


class fTumorPanel : public QWidget, private Ui::fTumorPanel
{
	Q_OBJECT

public:
	fTumorPanel(QWidget * parent = 0);
	~fTumorPanel() {}
	void SetCurrentSPoints(Landmarks *lm);
	void SetCurrentTPoints(Landmarks *lm);
	void SetCurrentSelectedTissueType();
	void SetCurrentPath(std::string path)
	{
		mCurrentPath = path;
	}
	void Clear();
//	void CheckAndUncehckButtons(int checkType, int uncheckType);


	void HandleKeyPressingEventTTable();
	void HandleDownKeyEventTTable();
	void HandleUpKeyEventTTable();
	void HandleDeleteKeyEventTTable();

	void HandleKeyPressingEventSTable();
	void HandleDownKeyEventSTable();
	void HandleUpKeyEventSTable();
	void HandleDeleteKeyEventSTable();


	public slots:
	void HighlightCurrentSelctedPoints(double x, double y, double z, double X, double Y, double Z, double value);
	void sLoad();
	void sSave();
	void tLoad();
	void tSave();
	void sRemoveSelectedPoints();
	void tRemoveSelectedPoints();
	void tRemoveCurrentIndexPoint(unsigned int rowIndex);
	void sRemoveCurrentIndexPoint(unsigned int rowIndex);
	void sAddPoint();
	void sAddPoint(int landmarksIndex,bool update);
	void tAddPoint(int rowIndex);
	void sTableClicked(int row, int col);
	void tTableClicked(int row, int col);
	void sTableDoubleClicked(int row, int col);
	void tTableDoubleClicked(int row, int col);
	void sTableFocused(bool bFocused);
	void tTableFocused(bool bFocused);
	void tRemoveAllPoints();
	void sRemoveAllPoints();

	void SetTissueType1();
	void SetTissueType2();
	void SetTissueType3();
	void SetTissueType4();
	void SetTissueType5();
	void SetTissueType6();
	void SetTissueType7();
	void SetTissueType8();
	void SetTissueType9();
	void SetTissueType10();
	void SetTissueType11();
	void SetTissueType12();
	void SetTissueType13();
	void SetTissueType14();
	void SetSeedType();
	void SetTissueType();
	void UpdateCurrentPoints();

signals:
	void UpdateRenderWindows();
	void SetActiveLandmarksType(int, int, int);
	void MoveSlicerCursor(double, double, double);
	void UpdatePointsRequestByTumorPanel(int, std::vector<double>);
	void SetTissueCounter(int type);
	void SetTissueTableIndex(int row);

public:
	int mType;
	int mTissueType;
	Landmarks* mCurrentSPoints;
	Landmarks* mCurrentTPoints;
	std::string mCurrentPath;
};


#endif
