/*******************************************************

This program performs image registration.

last modified : Apr 7 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program transfers one image into another one according to the input transformation field.\n");
  printf("\n%s input.img deformation.field output.img -d X,Y,Z [-D X,Y,Z] -m(smooth) [-S] [-F] [-i b|u|f] [-o b|u|f] [-p] [-a]\n\n", filename);
  printf("-d \t: size of deformation.field, the output.img also has the same size\n");
  printf("-D \t: size of input.img, optional, default values are the same with -d\n");
  printf("-F \t : forward transformation : deformationfield is defined in the inputimage space; default is backward transformation, where deformationfield is defined in the outputimage domain\n");
  printf("-p \t : no linear interpolation, this option is not useful for forward transform\n");
  printf("-S \t : switch X,Y of deformationfield, use -S to be compatible with HAMMER's deformationfield (Y,X,Z)\n");
  printf("-a \t : deformation is absolute value, otherwise deformation is offset value\n");
  printf("-i \t : input image format, default is byte\n");
  printf("-o \t : output image format, default is byte\n");
  printf("-m \t : smoothing before transformation\n");
  printf("\n");
}

main(int argc, char *argv[])
{
  char inputfile[80], deformationfield[80], outputfile[80];

  int XX,YY,ZZ;
  int x,y,z;
  int oXX,oYY,oZZ;
  int c;
  int smooth;
  int usemodel;
  int sw;
  int normal;
  int have_od;
  int absolute_field;
  int do_interpolation;
  char iformat;
  char oformat;

  Deformation_Field *df;

  DBox *simg, *oimg;

  smooth = 0;
  sw = 0;
  normal = 1;
  have_od = 0;

  iformat = 'b';
  oformat = 'b';

  do_interpolation = 1;
  absolute_field = 0;

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfile, argv[1]); 
      strcpy(deformationfield, argv[2]);
      strcpy(outputfile, argv[3]);

      c=getopt(argc-3,argv+3,"d:mSFD:i:o:pa");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'D':
	      sscanf(optarg, "%d,%d,%d", &oXX, &oYY, &oZZ);
	      have_od = 1;
	      break;
	    case 'm':
	      smooth = 1;
	      break;
	    case 'S':
	      sw = 1;
	      break;
	    case 'i':
	      sscanf(optarg, "%c", &iformat);
	      break;
	    case 'o':
	      sscanf(optarg, "%c", &oformat);
	      break;
	    case 'F':
	      normal = 0;
	      break;
	    case 'p':
	      do_interpolation = 0;
	      break;
	    case 'a':
	      absolute_field = 1;
	      break;
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-3,argv+3,"d:mSFD:i:o:pa");
	}
    }

  if (!have_od)
    {
      oXX = XX;
      oYY = YY;
      oZZ = ZZ;
    }

  printf("filenames: %s %s %s\n", inputfile, deformationfield, outputfile);

  simg = new_dbox(oXX,oYY,oZZ);

  switch(iformat)
    {
    case 'b':
      read_dbox(simg, inputfile, "byte");
      break;
    case 'u':
      read_dbox(simg, inputfile, "unshort");
      break;
    case 'f':
      read_dbox(simg, inputfile, "float");
      break;
    default:
      printf("-i b|u|f\n");
      break;
    }

  df = new_deformationfield(XX,YY,ZZ);

  read_deformationfield_with_switch(df, deformationfield, sw);

  if (absolute_field)
    {
      for (z=0;z<df->Z;z++)
	for (y=0;y<df->Y;y++)
	  for (x=0;x<df->X;x++)
	    {
	      df->point[z][y][x].X = df->point[z][y][x].X - x;
	      df->point[z][y][x].Y = df->point[z][y][x].Y - y;
	      df->point[z][y][x].Z = df->point[z][y][x].Z - z;
	    }
    }

  //  write_deformationfield(df, "test.field");
  //  read_deformationfield(df, deformationfield);

  if (smooth)
    Smooth_DeformationField(df,.5);

  if (normal)
    {
      if (do_interpolation)
	oimg = volume_transform(simg, df);
      else
	{
	  oimg = new_dbox(XX,YY,ZZ);
	  volume_transform_nointerpolation(simg, df, oimg);
	}
    }
  else
    {
      // do forward transformation;
      oimg = volume_transform_forward_bilge_simple(simg, df, 0);    
    }

  switch(oformat)
    {
    case 'b':
      write_dbox(oimg, outputfile, "byte", 1);
      break;
    case 'u':
      write_dbox(oimg, outputfile, "unshort", 0);
      break;
    case 'f':
      write_dbox(oimg, outputfile, "float", 0);
      break;
    default:
      printf("-o b|u|f\n");
      break;
    }
  
  free_dbox(oimg);
  free_dbox(simg);
  free_deformationfield(df);

  printf("fine, end\n");
}




