#!/usr/bin/perl

use Getopt::Std;

#get arguments list
$argc=@ARGV;

if ($argc < 6){
   &showUsage ;
}

my $opt_string = 'T:t:M:F:f:O:o:S:L:l:JQh';

getopts( "$opt_string");

if($opt_h){
  &showUsage;
  }

$quick=0;
if ($opt_Q){
    $quick = 1;
}

$jump=0;
if ($opt_J){
    $jump = 1;
}

if ($opt_T){
    $templateimage = $opt_T;
    $have_templateimage = 1;
}
else
{
    print "No template image input, use -T please\n";
    print "I am using my default name from the summary file\n";
    $have_templateimage = 0;
}

if ($opt_t){
    $templateseg = $opt_t;
    $have_templateseg = 1;
}
else
{
    print "No template segmentation input, use -t please\n";
    print "I am using my default name from the summary file\n";
    $have_templateseg = 0;
}

if ($opt_M){
    $ModelName = $opt_M;
    $have_ModelName = 1;
}
else
{
    print "You have to input base name of the Model, use -M Model_Name please\n";
    print "I am using default\n";
    $have_ModelName = 0;
}    

if ($opt_F){
    $OutField = $opt_F;
}
else
{
    print "-F is a must, it indicates the output field name\n";
    exit(1);
}

if ($opt_f){
    $OutInvField = $opt_f;
    $DoOutInvField = 1;
}
else
{
    $DoOutInvField = 0;
}    

if ($opt_O){
    $OutImage = $opt_O;
    $DoOutImage = 1;
}
else
{
    $DoOutImage = 0;
}

if ($opt_o){
    $OutSegmentation = $opt_o;
    $DoOutSegmentation = 1;
}
else
{
    $DoOutSegmentation = 0;
}

if ($opt_S){
    $summary_file = $opt_S;
}
else
{
    print "No summary file! use -S please\n";
    exit (1);
}

if ($opt_L){
    $template_landmark = $opt_L;
}
else
{
    print "Please input the template landmark file -L\n";
    exit(0);
}

if ($opt_l){
    $subject_landmark = $opt_l;
}
else
{
    print "Please input the subject landmark file -l\n";
    exit(0);
}

print "The program is generating a deformation field and its respective image.\n";

open(SUMMARY, "<$summary_file")||die("could not write file $summary_file\n");
$filenames = "";
$index = 1;

while($line = <SUMMARY>)
{
    chop($line);
    if (($index == 4)||($index==6)||($index==8)||($index==10)||($index==12)){
	if ($index==4)
	{
	    $filenames = "$line";
	}
	else
	{
	    $filenames = "$filenames"."&"."$line";
	}
    }

    #template name
    if ($index==18){  
	if ($have_templateimage==0){
	    $templateimage = "$line";
	}
    }
    
    #template size
    if ($index==20){
	$OSize = $line;
    # current do nothing;
    }

    #cut size
    if ($index==22){
	$cutsize = $line;
    }

    #small size
    if ($index==24){
    # do nothing
    }

    #small template
    if ($index==26){
	$small_template=$line;
    }

    #Switch
    if ($index==27)
    {
	$Switch=$line;
    }

    $index = $index + 1;
}
close(SUMMARY);

($filenamelist, $fieldfilenamelist, $wptfilenamelist, $jakfilenamelist, $jakwptfilenamelist) = split('&', $filenames);

open(FILE, "<$wptfilenamelist")||die("could not read file $wptfilenamelist\n");
$index = 1;
while (($line = <FILE>)&&($index<3)){
    chop($line);
    $fieldwptfile = $line;
    $index = $index + 1;
}
close(FILE);

$fieldwptinforfile = "$fieldwptfile".".infor";
$OutFieldInfor = "$OutField".".wpt.infor";
#print "cp $fieldwptinforfile $OutFieldInfor\n";
system("cp -f $fieldwptinforfile $OutFieldInfor");
$OutJakInfor = "$OutField".".jak.wpt.infor";
system("cp -f $fieldwptinforfile $OutJakInfor");

open(FILE, "<$fieldwptinforfile")||die("could not read file $fieldwptinforfile\n");
$index = 1;
while ($line=<FILE>){
    chop($line);
    if ($index == 2){
	$data = $line;
	@strings = split(' ', $data);
	($nXX, $nYY, $nZZ) = split(',', $strings[2]);
    }
    if ($index == 4){
	$data = $line;
	@strings = split(' ', $data);
	($XX, $YY, $ZZ) = split(',', $strings[2]);	
    }
    $index = $index + 1;
}
close(FILE);

# Note, the codes from here to the end of this program should be iteratively performed, however here we only use one iteration

print "\n1. Generate randomly a deformationfield based on the W-PCA model of deformations:\n\n";

print "LinuxCutPTS $template_landmark temp_template_landmark.pts -s $cutsize\n";
system("LinuxCutPTS $template_landmark temp_template_landmark.pts -s $cutsize >> /dev/null");

print "LinuxCutPTS $subject_landmark temp_subject_landmark.pts -s $cutsize\n";
system("LinuxCutPTS $subject_landmark temp_subject_landmark.pts -s $cutsize >> /dev/null");

if ($jump==1)
{
    print "LinuxPCAWPTsSimulateLandmarkConstrain $wptfilenamelist $ModelName -M temp_template_landmark.pts -S temp_subject_landmark.pts -o temp.v.data -j -P -l 0.0001 -e 100\n";
    system("LinuxPCAWPTsSimulateLandmarkConstrain $wptfilenamelist $ModelName -M temp_template_landmark.pts -S temp_subject_landmark.pts -o temp.v.data -j -P -l 0.0001 -e 100 >> /dev/null");
}
else
{
      print "LinuxPCAWPTsSimulateLandmarkConstrain $wptfilenamelist $ModelName -M temp_template_landmark.pts -S temp_subject_landmark.pts -o temp.v.data -l 0.0001 -e 100\n";
    system("LinuxPCAWPTsSimulateLandmarkConstrain $wptfilenamelist $ModelName -M temp_template_landmark.pts -S temp_subject_landmark.pts -o temp.v.data -l 0.0001 -e 100 >> /dev/null");  
}

print "LinuxPCAWPTsSimulate $wptfilenamelist $ModelName -o ${OutField}.wpt -p 1 -v temp.v.data\n";
system("LinuxPCAWPTsSimulate $wptfilenamelist $ModelName -o ${OutField}.wpt -p 1 -v temp.v.data>> /dev/null");

system("rm -f temp.v.data");
system("rm -f temp_template_landmark.pts");
system("rm -f temp_subject_landmark.pts");

print "LinuxInverseWaveletPacketTransformOfDeformation ${OutField}.wpt ${OutField}\n";
system("LinuxInverseWaveletPacketTransformOfDeformation ${OutField}.wpt ${OutField} >> /dev/null");

print "LinuxSmoothDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ -m .7\n";
system("LinuxSmoothDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ -m .7 >> /dev/null");
print "One more time: LinuxSmoothDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ -m .7\n";
system("LinuxSmoothDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ -m .7 >> /dev/null");

if ($quick==0){

print "\nThe deformation field ${OutField} is generated.\n";
print "\n2. Perform topology regularization on the deformation field:\n\n";

print "Topology regularization:\n\n";

print "LinuxRegularizeDeformationField.sh ${OutField} ${OutField}.jak ${OutField} $XX $YY $ZZ\n";
system("LinuxRegularizeDeformationField.sh ${OutField} ${OutField}.jak ${OutField} $XX $YY $ZZ >> /dev/null");

print "\nCalculate and regularize the Jacobian determinants of the deformation field:\n\n";

print "LinuxWaveletPacketTransformOfImage ${OutField}.jak ${OutField}.jak.wpt -d $XX,$YY,$ZZ -f\n";
system("LinuxWaveletPacketTransformOfImage ${OutField}.jak ${OutField}.jak.wpt -d $XX,$YY,$ZZ -f  >> /dev/null");

print "LinuxPCAImageWPTsSimulate $jakwptfilenamelist JAK$ModelName -i ${OutField}.jak.wpt -o ${OutField}.jak.wpt\n";
system("LinuxPCAImageWPTsSimulate $jakwptfilenamelist JAK$ModelName -i ${OutField}.jak.wpt -o ${OutField}.jak.wpt >> /dev/null");

print "LinuxInverseWaveletPacketTransformOfImage ${OutField}.jak.wpt ${OutField}.jak -f\n";
system("LinuxInverseWaveletPacketTransformOfImage ${OutField}.jak.wpt ${OutField}.jak -f >> /dev/null");

print "\nCalculate a new deformation field that matches the Jacobian determinant:\n\n";

print "LinuxDeformationFieldOffsetAbsoluteShift ${OutField} ${OutField} -d $XX,$YY,$ZZ -id\n";
system("LinuxDeformationFieldOffsetAbsoluteShift ${OutField} ${OutField} -d $XX,$YY,$ZZ -id >> /dev/null");

print "LinuxResaveDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ\n";
system("LinuxResaveDeformationField ${OutField} ${OutField} -d $XX,$YY,$ZZ >> /dev/null");

print "LinuxResaveJacobian ${OutField}.jak temp.target.volume -d $XX,$YY,$ZZ -S\n";
system("LinuxResaveJacobian ${OutField}.jak temp.target.volume -d $XX,$YY,$ZZ -S >> /dev/null");

print "LinuxVolumeMatching3D -d ${OutField} -o ${OutField}.target -v temp.target.volume -r $XX -c $YY -s $ZZ -I 50\n";
system("LinuxVolumeMatching3D -d ${OutField} -o ${OutField}.target -v temp.target.volume -r $XX -c $YY -s $ZZ -I 50 >> /dev/null");

system("rm -f temp.target.volume");

print "LinuxResaveDeformationField ${OutField}.target ${OutField}.target -d $XX,$YY,$ZZ\n";
system("LinuxResaveDeformationField ${OutField}.target ${OutField}.target -d $XX,$YY,$ZZ >> /dev/null");

print "LinuxDeformationFieldOffsetAbsoluteShift ${OutField}.target ${OutField}.target -d $XX,$YY,$ZZ -ia\n";
system("LinuxDeformationFieldOffsetAbsoluteShift ${OutField}.target ${OutField}.target -d $XX,$YY,$ZZ -ia >> /dev/null");

print "LinuxSmoothDeformationField ${OutField}.target ${OutField}.target -d $XX,$YY,$ZZ -m .7\n";
system("LinuxSmoothDeformationField ${OutField}.target ${OutField}.target -d $XX,$YY,$ZZ -m .7 >> /dev/null");

print "mv ${OutField}.target ${OutField}\n";
system("mv ${OutField}.target ${OutField}");

}

print "LinuxRecoverDeformationField ${OutField} ${OutField} -d $OSize -s $cutsize\n";
system("LinuxRecoverDeformationField ${OutField} ${OutField} -d $OSize -s $cutsize >> /dev/null");

print "\n3. Now ${OutField} is the simulated deformation field, its size is $OSize\n\n";
if ($DoOutImage==1)
{
    print "LinuxInverseDeformationField ${OutField} ${OutField}.inv -d $OSize\n";
    system("LinuxInverseDeformationField ${OutField} ${OutField}.inv -d $OSize >> /dev/null");
    print "LinuxImageTransformation $templateimage ${OutField}.inv $OutImage -d $OSize\n";
    system("LinuxImageTransformation $templateimage ${OutField}.inv $OutImage -d $OSize >> /dev/null");
    print "$OutImage is the warped template image\n";
}

if (($DoOutSegmentation==1)&&($have_templateseg==1))
{
    print "LinuxImageTransformation $templateseg ${OutField}.inv $OutSegmentation -d $OSize -p\n";
    system("LinuxImageTransformation $templateseg ${OutField}.inv $OutSegmentation -d $OSize -p >> /dev/null");
    print "$OutSegmentation is the warped segmentation of template\n";
}

if ($DoOutInvField == 0)
{
    system("rm -f ${OutField}.inv");
}
else
{
    system("mv ${OutField}.inv ${OutInvField}");
    if ($Switch=="SW=1"){
	print "resave deformation field\n";
	system("LinuxResaveDeformationField ${OutInvField} ${OutInvField} -d $OSize >> /dev/null");    
	print "${OutInvField} is the inverse of simulated field\n";
    }
}

if ($Switch=="SW=1")
{
    print "resave deformation field\n";
    system("LinuxResaveDeformationField ${OutField} ${OutField} -d $OSize >> /dev/null");    
}


system("rm -f ${OutField}.jak");
system("rm -f ${OutField}.jak.wpt");
system("rm -f ${OutField}.jak.wpt.infor");
system("rm -f ${OutField}.wpt");
system("rm -f ${OutField}.wpt.infor");

print "done, contact: zhong.xue@uphs.upenn.edu\n\n";

sub showUsage{
    print "This program simulates one new deformation and its respective image using the Landmark-Constrained SSD\n\n";
    print "Notice that the statistical models have to be trained using LinuxTrainSSD.pl prior to using this program\n\n";
    print "Usage: $0 [options]\n\n";

    print "-h                    : print this help\n\n";

    print "Inputs:\n\n";

    print "-T tempalte_image     : the template image\n";
    print "-t template_segment   : the segmented image of the template image\n";
    print "-M basename for Model : the base(prefix) filename of WPCA models\n";
    print "-S summary_file       : the summary file generated by LinuxTrainSSD\n\n";

    print "-L template landmark  : landmark file of template image\n";
    print "-l subject landmark   : landmark file of subject image (or the image to be simulated)\n\n";
 
    print "Outputs:\n\n";

    print "-F simulated_field    : the output simulated deformation field\n";
    print "-f inverse_field      : the inverse deformation field of the simulated deformation field (optional)\n";
    print "-O simulated_image    : the output simulated image\n";
    print "-o simulated_seg      : the output simulated segmention image (optional)\n\n";

    print "Other options:\n\n";
    print "-J                    : skip the process to calculate matrix (can not use for the first run)\n";
    print "-Q                    : skip the Jacobian regularization process\n";

    exit(1);
} 
