#!/usr/bin/perl

use Getopt::Std;

#get arguments list
$argc=@ARGV;

if ($argc < 2){
   &showUsage ;
}

my $opt_string = 'T:L:D:M:hSP:O:J';

getopts( "$opt_string");

$Switch = 0;
if ($opt_S){
    $Switch = 1;
}

if ($opt_P){
    $percent = $opt_P;
}
else
{
    $percent = .98;
}

if($opt_h){
  &showUsage;
  }

if ($opt_T)
{
    $template_image = $opt_T;
}
else
{
    &showUsage ;
    exit(1);
}

if ($opt_L)
{
    $filenamelist = $opt_L;
}
else
{
    &showUsage ;
    exit (1);
}


if ($opt_D)
{
    $OSize=$opt_D;
}
else
{
    &showUsage ;
    exit(1);
}

if ($opt_M)
{
    $WPCAName = $opt_M;
}
else
{
    &showUsage ;
    exit(1);
}

if ($opt_O){
    $summarize_file = $opt_O;
}
else
{
    &showUsage;
    print "You dont have -O option\n";
    exit(1);
}    

$jump = 0;
if ($opt_J){
    $jump = 1;
}

@OldSize = split(',', $OSize);

# 0. Cut the template image and all the deformation fields into smaller size to save space and memory
# 1. Correct Topology if the Jacobian determinants of input deformation fields are not possitive
# 2. Calculate Jacobian Determinants of the input deformation fields
# 3. Calculate WPT of deformation fields
# 4. Calculate WPT of Jacobians


print "LinuxGetSmallImageSize ${template_image} -d $OldSize[0],$OldSize[1],$OldSize[2]\n";

#system("LinuxGetSmallImageSize ${template_image} -d $OldSize[0],$OldSize[1],$OldSize[2]");
open(OUTPUT, "LinuxGetSmallImageSize ${template_image} -d $OldSize[0],$OldSize[1],$OldSize[2]|"); 
print "$OUTPUT\n";
$SIZE=<OUTPUT>;
($BX,$EX,$BY,$EY,$BZ,$EZ)=split(',', $SIZE);
close(OUTPUT);
print "$BX,$EX,$BY,$EY,$BZ,$EZ\n";

$NX=$EX-$BX+1;
$NY=$EY-$BY+1;
$NZ=$EZ-$BZ+1;

print "$NX,$NY,$NZ\n";

$new_template_image = "small"."$template_image";
print "$new_template_image\n"; 

print "LinuxResizeImage $template_image $new_template_image -d $OldSize[0],$OldSize[1],$OldSize[2] -s $SIZE -C\n";
system("LinuxResizeImage $template_image $new_template_image -d $OldSize[0],$OldSize[1],$OldSize[2] -s $SIZE -C >> /dev/null");

$fieldfilenamelist = "smallfield"."$filenamelist";
$jakfilenamelist = "smalljak"."$filenamelist";
$wptfilenamelist = "wpt"."$fieldfilenamelist";
$jakwptfilenamelist = "jak"."$wptfilenamelist";

open(SUMMARY, ">$summarize_file")||die("could not write file $summarize_file\n");

open(OUTPUT, "date|"); 
$line=<OUTPUT>;
close(OUTPUT);
chop($line);
print SUMMARY "This file was generated on $line, by using LinuxTrainSSD.pl\n";
print SUMMARY "The following filename lists are used and generated\n";
print SUMMARY "The filename list of the sample deformation fields:\n";
print SUMMARY "$filenamelist\n";
print SUMMARY "The filename list of the smaller deformation fields:\n";
print SUMMARY "$fieldfilenamelist\n";
print SUMMARY "The filename list of the WPT files of the smaller deformation fields:\n";
print SUMMARY "$wptfilenamelist\n";
print SUMMARY "The filename list of the Jacobian Determinants of the smaller deformation fields:\n";
print SUMMARY "$jakfilenamelist\n";
print SUMMARY "The filename list of the WPT of Jacobian determinants of the smaller deformation fields:\n";
print SUMMARY "$jakwptfilenamelist\n";
print SUMMARY "The base name of the WPCA model of deformation fields:\n";
print SUMMARY "$WPCAName\n";
print SUMMARY "The base name of the WPCA model of Jacobian determinants:\n";
print SUMMARY "JAK$WPCAName\n";
print SUMMARY "The template image filename:\n";
print SUMMARY "$template_image\n";
print SUMMARY "The size of original template image (or original deformation fields):\n";
print SUMMARY "$OldSize[0],$OldSize[1],$OldSize[2]\n";
print SUMMARY "The begining and ending X,Y,Z for cutting bigger image/fields into smaller image/fields:\n";
print SUMMARY "$SIZE\n";
print SUMMARY "The new small size:\n";
print SUMMARY "$NX,$NY,$NZ\n";
print SUMMARY "The new small template image filename:\n";
print SUMMARY "$new_template_image\n"; 
if ($Switch == 1){
    print SUMMARY "SW=1\n";
}
else
{
    print SUMMARY "SW=0\n";
}
print SUMMARY "Please dont modify this file, it will be used by LinuxPerformSSD.pl\n";
close(SUMMARY);

open(FILE, "<$filenamelist")||die("could not open file $filenamelist\n");
open(SMALLFIELDFILE, ">$fieldfilenamelist")||die("could not write file $fieldfilenamelist\n");
open(SMALLJAKFILE, ">$jakfilenamelist")||die("could not write file $fieldfilenamelist\n");
open(WPTFILE, ">$wptfilenamelist")||die("could not write file $wptfilenamelist\n");
open(JAKWPTFILE, ">$jakwptfilenamelist")||die("could not write file $jakwptfilenamelist\n");

$No=1;
while ($line = <FILE>)
{
    if ($No==1)
    {
	$NUMBER=$line;

	print SMALLFIELDFILE $NUMBER;
	print SMALLJAKFILE $NUMBER;
	print WPTFILE $NUMBER;
	print JAKWPTFILE $NUMBER;

	chop($NUMBER);
    }
    else
    {
	$fieldfilename=$line;
	chop($fieldfilename);
	$fieldfilename =~ s/\s//sg;

	$smoothedfieldfilename="smooth"."$fieldfilename";
	$outputfieldfilename = "small"."$fieldfilename";
	$outputjakfilename = "small"."$fieldfilename".".jak";
	$outputwptfilename = "$outputfieldfilename".".wpt";
	$jakwptfilename = "$outputjakfilename".".wpt";

	print SMALLFIELDFILE "$outputfieldfilename\n";
	print SMALLJAKFILE "$outputjakfilename\n";
	print WPTFILE "$outputwptfilename\n";
	print JAKWPTFILE "$jakwptfilename\n";

	if ($jump==0){

	    if ($Switch == 1){
		print "LinuxSmoothDeformationField $fieldfilename $smoothedfieldfilename -d $OldSize[0],$OldSize[1],$OldSize[2] -S -T 100 -w 2 -m .3\n";
		system("LinuxSmoothDeformationField $fieldfilename $smoothedfieldfilename -d $OldSize[0],$OldSize[1],$OldSize[2] -S -T 100 -w 2 -m .3 >> /dev/null");
		print "Resave Deformation Field\n";
		system("LinuxResaveDeformationField $smoothedfieldfilename $smoothedfieldfilename -d $OldSize[0],$OldSize[1],$OldSize[2] >> /dev/null");
	    }
	    else
	    {
		print "LinuxSmoothDeformationField $fieldfilename $smoothedfieldfilename -d $OldSize[0],$OldSize[1],$OldSize[2] -T 100 -w 3 -m .3\n";
		system("LinuxSmoothDeformationField $fieldfilename $smoothedfieldfilename -d $OldSize[0],$OldSize[1],$OldSize[2] -T 100 -w 3 -m .3 >> /dev/null");
	    }
	    
	    print "LinuxCutDeformationField $smoothedfieldfilename $outputfieldfilename -d $OldSize[0],$OldSize[1],$OldSize[2] -s $SIZE\n";		
	    system("LinuxCutDeformationField $smoothedfieldfilename $outputfieldfilename -d $OldSize[0],$OldSize[1],$OldSize[2] -s $SIZE >> /dev/null");
	    
	    print "rm -f $smoothedfieldfilename\n";
	    system("rm -f $smoothedfieldfilename");
	    print "now smoothing again\n";
	    
	    print "LinuxSmoothDeformationField $outputfieldfilename $outputfieldfilename -d $NX,$NY,$NZ -m .7\n";
	    system("LinuxSmoothDeformationField $outputfieldfilename $outputfieldfilename -d $NX,$NY,$NZ -m .7 >> /dev/null");
	    
	    print "LinuxRegularizeDeformationField.sh $outputfieldfilename $outputjakfilename $outputfieldfilename $NX $NY $NZ\n";
	    system("LinuxRegularizeDeformationField.sh $outputfieldfilename $outputjakfilename $outputfieldfilename $NX $NY $NZ");
	    
	    print "LinuxCalculateJacobian $outputfieldfilename $outputjakfilename -d $NX,$NY,$NZ\n";
	    system("LinuxCalculateJacobian $outputfieldfilename $outputjakfilename -d $NX,$NY,$NZ >> /dev/null");
	    
	    print "LinuxWaveletPacketTransformOfDeformation $outputfieldfilename $outputwptfilename -d $NX,$NY,$NZ -l 2\n";
	    system("LinuxWaveletPacketTransformOfDeformation $outputfieldfilename $outputwptfilename -d $NX,$NY,$NZ -l 2 >> /dev/null");
	    print "LinuxWaveletPacketTransformOfImage $outputjakfilename $jakwptfilename -d $NX,$NY,$NZ -l 2 -f\n";
	    system("LinuxWaveletPacketTransformOfImage $outputjakfilename $jakwptfilename -d $NX,$NY,$NZ -l 2 -f >> /dev/null");
	    
	    print "delete temp files\n";
	    system("rm -f $outputjakfilename");
	    system("rm -f $outputfieldfilename");
	}
    }
    $No = $No +1;    
}
close(FILE);
close(SMALLFIELDFILE);
close(SMALLJAKFILE);
close(WPTFILE);
close(JAKWPTFILE);



# 5. Construct W-PCA model of deformation fields

print "The following process is slow, please wait...\nLinuxPCAofWPTs $wptfilenamelist $WPCAName -p $percent\n";
system("LinuxPCAofWPTs $wptfilenamelist $WPCAName -p $percent >> /dev/null");

# 6. Construct W-PCA model of Jacobians

print "The following process is relatively slow, please wait...\nLinuxPCAofImageWPTs $jakwptfilenamelist JAK$WPCAName -p $percent\n";
system("LinuxPCAofImageWPTs $jakwptfilenamelist JAK$WPCAName -p $percent >> /dev/null");

print "Fine end\n\n";

print "contact zhong.xue@uphs.upenn.edu\n";
# 7. Exit


sub showUsage{
    print "This program trains the statistical models of SSD, including W-PCA model of deformations and W-PCA model of Jacobians\n\n";
    print "Usage: $0 [options]\n\n";

    print "-h                   : help\n\n";

    print "-T tempalte          : the template image\n";
    print "-L filenamelist      : the text file that list all the filenames of all the sample deformation fields.\n";
    print "-D X,Y,Z             : the size of input template image, or the size of all the training deformation fields\n";
    print "-M WPCAName          : the base(prefix) name of the output W-PCA models\n";
    print "-S                   : use this only if the input deformation fields are generated by HAMMER\n";
    print "-P percent           : the percentage of the total variance to be used to determine the principal components\n\n";
    print "-O summarize_file    : output the summarize file that will be used by LinuxPerformSSD.pl\n\n";

    print "-J                   : optional, use this option if you already calculated the Wavelet-Packet-Transform of deformation fields and Jacobian determinants.\n";
    exit(1);
} 
