/* this program generates the multi-resolution images

Jon Z. Xue

Jan 10 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s inputdeformationfield outputdeformationfield [options]\n", filename);
  printf("-d <int,int,int>\n");
  printf("-s <int,int,int,int,int,int>\n");
  
  printf("\n");
}

main(int argc, char *argv[])
{
  char  inputfilename[180], outputfilename[180];

  Deformation_Field *odf, *tdf;

  char ch1, ch2, ch, chs;
  int direction,ok;
  int use_original;
  int value;
  int XX,YY,ZZ,x,y,z;
  int bx,by,bz,ex,ey,ez;

  int do_newsize, newsize;

  int one, two, vary;
  int change, reverse;
  int c;
  int threshold;

  ok = 0;
  change = 0;
  reverse = 0;
  do_newsize = 0;

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilename, argv[1]); 
      strcpy(outputfilename, argv[2]); 

      c=getopt(argc-2,argv+2,"d:s:");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 's':
	      sscanf(optarg, "%d,%d,%d,%d,%d,%d", &bx,&ex,&by,&ey,&bz,&ez);
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:s:");
	}
    }
  
  printf("[%d,%d,%d]\n", XX,YY,ZZ);

  odf = new_deformationfield(XX,YY,ZZ);
  read_deformationfield(odf, inputfilename);

  tdf = new_deformationfield(ex-bx+1,ey-by+1,ez-bz+1);

  for (z=bz;z<bz+tdf->Z;z++)
    for (y=by;y<by+tdf->Y;y++)
      for (x=bx;x<bx+tdf->X;x++)
	if ((x>=0)&&(y>=0)&&(z>=0)&&(x<odf->X)&&(y<odf->Y)&&(z<odf->Z))
	  {
	    tdf->point[z-bz][y-by][x-bx].X = odf->point[z][y][x].X;
	    tdf->point[z-bz][y-by][x-bx].Y = odf->point[z][y][x].Y;
	    tdf->point[z-bz][y-by][x-bx].Z = odf->point[z][y][x].Z;
	  }

  write_deformationfield(tdf, outputfilename);
}








