/*this program calculates the av of each image

Jon Z. Xue

April 10 2001;
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s input_fav_deformation outputdeformation [options]\n", filename);
  printf("\n");
  printf("file : outputwaveletdeformation.infor will be automatically generated\n");
}

main(int argc, char *argv[])
{
  char filename[200], *basefilename, outfilename[200], tempfilename[200];

  Deformation_Field *df, *odf;
  DBox *dfx, *dfy, *dfz;
  FILE *fp;

  int c;
  int x,y,z;
  int need_output;
  int level;
  int XX,YY,ZZ;
  int oXX,oYY,oZZ;
  int i, number;
  int lx, ly, lz;
  int szx, szy, szz;
  int ch;

  level = 3;
  need_output = 0;
  
  basefilename = (char *) calloc (200, sizeof(char));

  if (argc<3)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(filename, argv[1]); 
      strcpy(basefilename, argv[2]);

      c=getopt(argc-2,argv+2,"");
      while(c!= -1)
	{
	  switch(c)
	    {
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"");
	}
    }

  sprintf(tempfilename, "%s.infor", filename);
  fp = fopen(tempfilename, "rt");
  if (fp==NULL)
    {
      printf("file %s does not exist\n", tempfilename);
      exit(0);
    }
  fscanf(fp, "favname: %s\n", tempfilename);
  fscanf(fp, "size   : %d,%d,%d\n", &XX,&YY,&ZZ);
  fscanf(fp, "step   : %d,%d,%d\n", &szx, &szy, &szz);
  fscanf(fp, "osize  : %d,%d,%d\n", &oXX,&oYY,&oZZ);
  fclose(fp);
  
  df = new_deformationfield(XX,YY,ZZ);
  odf = new_deformationfield(oXX,oYY,oZZ);

  read_deformationfield(df, filename);

  dfx = new_dbox(XX,YY,ZZ);
  dfz = new_dbox(XX,YY,ZZ);
  dfy = new_dbox(XX,YY,ZZ);

  for (z=0;z<dfx->Z;z++)
    for (y=0;y<dfx->Y;y++)
      for (x=0;x<dfx->X;x++)
	{
	  dfx->box[z][y][x] = df->point[z][y][x].X;
	  dfy->box[z][y][x] = df->point[z][y][x].Y;
	  dfz->box[z][y][x] = df->point[z][y][x].Z;
	}

  while(szx<=XX)
    {
      printf("level: step %d %d %d\n", szx, szy, szz);
      for (lx=0;lx<df->X;lx+=szx)
	for (ly=0;ly<df->Y;ly+=szy)
	  for (lz=0;lz<df->Z;lz+=szz)
	    {
	      printf("%d %d %d %d %d %d\n", lx, lx+szx, ly, ly+szy, lz, lz+szz);
	      iwt_3d_base_same(dfx, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	      iwt_3d_base_same(dfy, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	      iwt_3d_base_same(dfz, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	    }
      szx = szx * 2;
      szy = szy * 2;
      szz = szz * 2;
    }

  for (z=0;z<dfx->Z;z++)
    for (y=0;y<dfx->Y;y++)
      for (x=0;x<dfx->X;x++)
	{
	  df->point[z][y][x].X = dfx->box[z][y][x];
	  df->point[z][y][x].Y = dfy->box[z][y][x];
	  df->point[z][y][x].Z = dfz->box[z][y][x];
	}

  for (z=0;z<odf->Z;z++)
    for (y=0;y<odf->Y;y++)
      for (x=0;x<odf->X;x++)
	{
	  odf->point[z][y][x].X = df->point[z][y][x].X;
	  odf->point[z][y][x].Y = df->point[z][y][x].Y;
	  odf->point[z][y][x].Z = df->point[z][y][x].Z;	  
	}

  write_deformationfield(odf, basefilename);

  printf("this is ok the end, fine!! --- zxue@rad.upenn.edu\n");
}

