/*this program calculates the av of each image

Jon Z. Xue

April 10 2001;
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s input_wpt_image outputimage [options]\n", filename);
  printf("\n");
  printf("-b|f  : outputimage format, default is byte\n");
  printf("file : outputwaveletdeformation.infor will be automatically used\n");
}

main(int argc, char *argv[])
{
  char filename[200], *basefilename, outfilename[200], tempfilename[200];

  DBox *dfx, *oimg;
  FILE *fp;
  char format[20];

  int c;
  int x,y,z;
  int need_output;
  int level;
  int XX,YY,ZZ;
  int i, number;
  int lx, ly, lz;
  int szx, szy, szz;
  int oXX,oYY,oZZ;
  int ch;

  level = 3;
  need_output = 0;
  
  basefilename = (char *) calloc (200, sizeof(char));

  strcpy(format, "byte");
  if (argc<3)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(filename, argv[1]); 
      strcpy(basefilename, argv[2]);

      c=getopt(argc-2,argv+2,"bf");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'b':
	      strcpy(format, "byte");
	      break;
	    case 'f':
	      strcpy(format, "float");
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"bf");
	}
    }

  sprintf(tempfilename, "%s.infor", filename);
  fp = fopen(tempfilename, "rt");
  if (fp==NULL)
    {
      printf("file %s does not exist\n", tempfilename);
      exit(0);
    }
  fscanf(fp, "favname: %s\n", tempfilename);
  fscanf(fp, "size   : %d,%d,%d\n", &XX,&YY,&ZZ);
  fscanf(fp, "step   : %d,%d,%d\n", &szx, &szy, &szz);
  fscanf(fp, "osize  : %d,%d,%d\n", &oXX,&oYY,&oZZ);
  fclose(fp);

  dfx = new_dbox(XX,YY,ZZ);
  read_dbox(dfx, filename, "float");

  while(szx<=XX)
    {
      printf("level: step %d %d %d\n", szx, szy, szz);
      for (lx=0;lx<dfx->X;lx+=szx)
	for (ly=0;ly<dfx->Y;ly+=szy)
	  for (lz=0;lz<dfx->Z;lz+=szz)
	    {
	      printf("%d %d %d %d %d %d\n", lx, lx+szx, ly, ly+szy, lz, lz+szz);
	      iwt_3d_base_same(dfx, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	    }
      szx = szx * 2;
      szy = szy * 2;
      szz = szz * 2;
    }

  oimg = new_dbox(oXX,oYY,oZZ);
  for (x=0;x<oXX;x++)
    for (y=0;y<oYY;y++)
      for (z=0;z<oZZ;z++)
	{
	  oimg->box[z][y][x] = dfx->box[z][y][x];
	}

  write_dbox(oimg, basefilename, format, 1);

  printf("this is ok the end, fine!! --- zxue@rad.upenn.edu\n");
}

