/* this program generates the multi-resolution images

Jon Z. Xue

Jan 10 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("This program transfers voxelwise jacobian file to box-wise jacobian file or inverse\n");
  printf("\nusage: %s inputimagefile outputimagefile [options]\n\n", filename);
  printf("-d <int,int,int>  : size of input Jacbian\n");
  printf("-S                : optional, if use this option, the output will be 1-voxel smaller then input, otherwise output is 1-voxel larget than input.\n");
  printf("\n");
}

main(int argc, char *argv[])
{
  char  inputfilename[180], outputfilename[180];
  DBox *oimg, *timg, *ntimg;

  char ch1, ch2, ch, chs;
  char format[20];
  int direction,ok;
  int use_original;
  float value;
  int XX,YY,ZZ,x,y,z;
  int bx,by,bz,ex,ey,ez;
  int lx,ly,lz,ux,uy,uz;
  int do_newsize, newsize;

  int do_smaller;

  int one, two, vary;
  int change, reverse;
  int c;
  int threshold;

  int number;

  ok = 0;
  change = 0;
  reverse = 0;
  do_newsize = 0;

  do_smaller = 0;

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputfilename, argv[1]); 
      strcpy(outputfilename, argv[2]); 

      c=getopt(argc-2,argv+2,"d:S");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'S':
	      do_smaller = 1;
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:S");
	}
    }
  
  if (do_smaller == 0)
    {
      oimg = new_dbox(XX,YY,ZZ);
      timg = new_dbox(XX+1, YY+1, ZZ+1);
      read_dbox(oimg, inputfilename, "float");
      
      for (z=0;z<timg->Z;z++)
	for (y=0;y<timg->Y;y++)
	  for (x=0;x<timg->X;x++)
	    {
	      ux = x;
	      uy = y;
	      uz = z;
	      lx = x-1;
	      ly = y-1;
	      lz = z-1;
	      
	      number = 0;
	      
	      if ((lx>=0)&&(ly>=0)&&(lz>=0)&&(lx<XX)&&(ly<YY)&&(lz<ZZ))
		{
		  value = oimg->box[lz][ly][lx];
		  number ++;
		}
	      if ((ux>=0)&&(ly>=0)&&(lz>=0)&&(ux<XX)&&(ly<YY)&&(lz<ZZ))
		{
		  value += oimg->box[lz][ly][ux];
		  number ++;
		}
	      if ((lx>=0)&&(uy>=0)&&(lz>=0)&&(lx<XX)&&(uy<YY)&&(lz<ZZ))
		{
		  value += oimg->box[lz][uy][lx];
		  number ++;
		}
	      if ((ux>=0)&&(uy>=0)&&(lz>=0)&&(ux<XX)&&(uy<YY)&&(lz<ZZ))
		{
		  value += oimg->box[lz][uy][ux];
		  number ++;
		}
	      if ((lx>=0)&&(ly>=0)&&(uz>=0)&&(lx<XX)&&(ly<YY)&&(uz<ZZ))
		{
		  value += oimg->box[uz][ly][lx];
		  number ++;
		}
	      if ((ux>=0)&&(ly>=0)&&(uz>=0)&&(ux<XX)&&(ly<YY)&&(uz<ZZ))
		{
		  value += oimg->box[uz][ly][ux];
		  number ++;
		}
	      if ((lx>=0)&&(uy>=0)&&(uz>=0)&&(lx<XX)&&(uy<YY)&&(uz<ZZ))
		{
		  value += oimg->box[uz][uy][lx];
		  number ++;
		}
	      if ((ux>=0)&&(uy>=0)&&(uz>=0)&&(ux<XX)&&(uy<YY)&&(uz<ZZ))
		{
		  value += oimg->box[uz][uy][ux];
		  number ++;
		}	  
	      value = value / number;
	      
	      timg->box[z][y][x] = value;
	    }
      
    }
  else if (do_smaller==1)
    {
      oimg = new_dbox(XX,YY,ZZ);
      timg = new_dbox(XX-1, YY-1, ZZ-1);
      read_dbox(oimg, inputfilename, "float");
      
      for (z=0;z<oimg->Z-1;z++)
	for (y=0;y<oimg->Y-1;y++)
	  for (x=0;x<oimg->X-1;x++)
	    {
	      lx = x;
	      ly = y;
	      lz = z;
	      ux = x+1;
	      uy = y+1;
	      uz = z+1;
	      timg->box[z][y][x] = (oimg->box[lz][ly][lx] +
				    oimg->box[lz][ly][ux] +
				    oimg->box[lz][uy][lx] +
				    oimg->box[lz][uy][ux] +
				    oimg->box[uz][ly][lx] +
				    oimg->box[uz][ly][ux] +
				    oimg->box[uz][uy][lx] +
				    oimg->box[uz][uy][ux]) / 8.0;
	    }
    }
  
  write_dbox(timg, outputfilename, "float", 1);

  free_dbox(timg);
  free_dbox(oimg);
}








