/*******************************************************


This program performs image registration.

last modified : Apr 7 2003

*******************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>
//#include <unistd.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("this program change x,y.\n");
  printf("\n%s inputdeformationfield outputdeformationfield -d X,Y,Z -S [-T threshold -w width] [-m lambda] [-G|W]\n", filename);
  printf("\n");
  printf("lambda = 0, no smooth, lambda = 1, strong smooth\n");
}

main(int argc, char *argv[])
{
  char inputdeformationfield[180], outputdeformationfield[180];

  Deformation_Field *idf, *odf;  

  float original_distance, threshold;
  float lambda;
  
  int x, y, z, c, XX, YY, ZZ, k, xx, yy, zz, sw;
  int do_smooth;
  int have_threshold;

  float ok, okok, maxv;

  FPoint FP, zero;
  Points *hood;

  int width = 10;

  sw = 0;
  have_threshold = 0;
  threshold = 100.0;
  do_smooth = 0;

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(inputdeformationfield, argv[1]); 
      strcpy(outputdeformationfield, argv[2]);

      c=getopt(argc-2,argv+2,"d:T:w:Sm:");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'T':
	      sscanf(optarg, "%f", &threshold);
	      have_threshold = 1;
	      break;
	    case 'w':
	      sscanf(optarg, "%d", &width);
	      break;
	    case 'S':
	      sw = 1;
	      break;
	    case 'm':
	      do_smooth = 1;
	      sscanf(optarg, "%f", &lambda);
	      break;
	    default:
	      printf("option error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:T:w:Sm:");
	}
    }

  printf("begin program\n");
  printf("%d %d %d\n", XX, YY, ZZ);

  idf = new_deformationfield(XX,YY,ZZ);
  odf = new_deformationfield(XX,YY,ZZ);

  read_deformationfield_with_switch(idf, inputdeformationfield, sw);

  zero.X = 0.0;
  zero.Y = 0.0;
  zero.Z = 0.0;

  if (have_threshold)
    {
      hood = generate_hood_byIncreasingRadius(width*2, 1.,1.,1.);
      
      for (z=0;z<idf->Z;z++)
	{
	  //      printf("z = %d\n",z);
	  for (y=0;y<idf->Y;y++)
	    for (x=0;x<idf->X;x++)
	      {
		ok = distance_3d_f(idf->point[z][y][x],zero);
		if (ok>threshold)
		  {
		    for (k=0;k<hood->Num;k++)
		      {
			xx = x+hood->point[k].X;
			yy = y+hood->point[k].Y;
			zz = z+hood->point[k].Z;
			
			xx = (xx<0)?0:xx;
			xx = (xx>=XX)?XX-1:xx;
			yy = (yy<0)?0:yy;
			yy = (yy>=YY)?YY-1:yy;
			zz = (zz<0)?0:zz;
			zz = (zz>=ZZ)?ZZ-1:zz;
			
			okok = distance_3d_f(idf->point[zz][yy][xx],zero);
			if (okok<threshold)
			  {
			    //			      printf("here %d %d, %d %d\n", l, m, yy, xx);
			    odf->point[z][y][x].X = idf->point[zz][yy][xx].X;
			    odf->point[z][y][x].Y = idf->point[zz][yy][xx].Y;			      
			    odf->point[z][y][x].Z = idf->point[zz][yy][xx].Z;
			    break;
			  }			
		      }		  
		  }
		else
		  {
		    odf->point[z][y][x].X = idf->point[z][y][x].X;
		    odf->point[z][y][x].Y = idf->point[z][y][x].Y;			      
		    odf->point[z][y][x].Z = idf->point[z][y][x].Z;
		    
		    if (maxv<ok)
		      maxv = ok;
		  }		  
	      } 
	}      

      free_points(hood);
    }
  else
    {
      for (z=0;z<idf->Z;z++)
	for (y=0;y<idf->Y;y++)
	  for (x=0;x<idf->X;x++)
	    {
	      odf->point[z][y][x].X = idf->point[z][y][x].X;
	      odf->point[z][y][x].Y = idf->point[z][y][x].Y;			      
	      odf->point[z][y][x].Z = idf->point[z][y][x].Z;
	    }		        
    }

  if (do_smooth)
    Smooth_DeformationField(odf, lambda);

  write_deformationfield_with_switch(odf, outputdeformationfield, sw);

  free_deformationfield(idf);
  free_deformationfield(odf);
}

