/*this program calculates the av of each image

Jon Z. Xue

April 10 2001;
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s inputdeformation outputwaveletdeformation [options]\n", filename);
  printf("\n");
  printf("-d X,Y,Z      -- X,Y,Z are the size of images (no default value)\n\n");
  printf("-l level      -- wavelet levels (default = 3)\n"); 
  printf("-R recon_name -- create the reconstructed deformation also\n");
  printf("-S            -- switch, use if the deformation field is from HAMMER\n");
  printf("file : outputwaveletdeformation.infor will be automatically generated\n");
}

main(int argc, char *argv[])
{
  char filename[200], *basefilename, outfilename[200], tempfilename[200];

  Deformation_Field *df, *odf, *rdf;
  DBox *dfx, *dfy, *dfz;
  FILE *fp;

  int c;
  int x,y,z;
  int need_output;
  int level;
  int XX,YY,ZZ;
  int i, number;
  int lx, ly, lz;
  int szx, szy, szz;
  int ch;

  level = 3;
  need_output = 0;
  
  basefilename = (char *) calloc (200, sizeof(char));

  ch = 0;
  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(filename, argv[1]); 
      strcpy(basefilename, argv[2]);

      c=getopt(argc-2,argv+2,"d:R:l:S");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'l':
	      level = atoi(optarg);
	      break;
	    case 'R':
	      sscanf(optarg, "%s", outfilename);
	      need_output = 1;
	      break;
	    case 'S':
	      ch = 1;
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:l:R:S");
	}
    }
  
  szx = XX;
  szy = YY;
  szz = ZZ;

  for (i=0;i<level;i++)
    {
      if (szx%2!=0) szx = szx+1;
      if (szy%2!=0) szy = szy+1;
      if (szz%2!=0) szz = szz+1;

      szx = szx/2;
      szy = szy/2;
      szz = szz/2;
      //      printf("%d %d %d %d\n", i, szx, szy, szz);
    }

  for (i=0;i<level;i++)
    {
      szx = szx*2;
      szy = szy*2;
      szz = szz*2;
      //      printf("%d %d %d %d\n", i, szx, szy, szz);
    }

  rdf = new_deformationfield(XX,YY,ZZ);

  df = new_deformationfield(szx,szy,szz);
  clear_deformationfield(df);
  dfx = new_dbox(szx,szy,szz);
  dfy = new_dbox(szx,szy,szz);
  dfz = new_dbox(szx,szy,szz);

  read_deformationfield_with_switch(rdf, filename, ch);

  for (z=0;z<ZZ;z++)
    for (y=0;y<YY;y++)
      for (x=0;x<XX;x++)
	{
	  df->point[z][y][x].X = rdf->point[z][y][x].X;
	  df->point[z][y][x].Y = rdf->point[z][y][x].Y;
	  df->point[z][y][x].Z = rdf->point[z][y][x].Z;
	} 

  for (x=XX;x<szx;x++)
    for (z=0;z<ZZ;z++)
      for (y=0;y<YY;y++)
	{
	  df->point[z][y][x].X = df->point[z][y][x-1].X;
	  df->point[z][y][x].Y = df->point[z][y][x-1].Y;
	  df->point[z][y][x].Z = df->point[z][y][x-1].Z;
	}

  for (y=YY;y<szy;y++)
    for (z=0;z<ZZ;z++)
      for (x=0;x<szx;x++)
	{
	  df->point[z][y][x].X = df->point[z][y-1][x].X;
	  df->point[z][y][x].Y = df->point[z][y-1][x].Y;
	  df->point[z][y][x].Z = df->point[z][y-1][x].Z;
	}

  for (z=ZZ;z<szz;z++)
    for (y=0;y<szy;y++)
      for (x=0;x<szx;x++)
	{
	  df->point[z][y][x].X = df->point[z-1][y][x].X;
	  df->point[z][y][x].Y = df->point[z-1][y][x].Y;
	  df->point[z][y][x].Z = df->point[z-1][y][x].Z;
	}      

  for (z=0;z<df->Z;z++)
    for (y=0;y<df->Y;y++)
      for (x=0;x<df->X;x++)
	{
	  dfx->box[z][y][x] = df->point[z][y][x].X;
	  dfy->box[z][y][x] = df->point[z][y][x].Y;
	  dfz->box[z][y][x] = df->point[z][y][x].Z;
	}

  //  write_dbox(dfx, "test1.dfx", "float", 1);
  //  write_dbox(dfx, "otest.dfx", "float", 1);
  //  write_dbox(dfy, "otest.dfy", "float", 1);
  //  write_dbox(dfz, "otest.dfz", "float", 1);

  for (i=0;i<level;i++)
    {
      printf("level %d : step %d %d %d\n", i, szx, szy, szz);
      for (lx=0;lx<df->X;lx+=szx)
	for (ly=0;ly<df->Y;ly+=szy)
	  for (lz=0;lz<df->Z;lz+=szz)
	    {
	      //	      printf("%d %d %d %d %d %d\n", lx, lx+szx, ly, ly+szy, lz, lz+szz);
	      wt_3d_base_same(dfx, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	      wt_3d_base_same(dfy, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	      wt_3d_base_same(dfz, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	    }
      szx = szx/2;
      szy = szy/2;
      szz = szz/2;
    }
  szx = szx * 2;
  szy = szy * 2;
  szz = szz * 2;

  for (z=0;z<df->Z;z++)
    for (y=0;y<df->Y;y++)
      for (x=0;x<df->X;x++)
	{
	  df->point[z][y][x].X = dfx->box[z][y][x];
	  df->point[z][y][x].Y = dfy->box[z][y][x];
	  df->point[z][y][x].Z = dfz->box[z][y][x];
	}  

  write_deformationfield(df, basefilename);
  sprintf(tempfilename, "%s.infor", basefilename);
  fp = fopen(tempfilename, "wt");
  fprintf(fp, "favname: %s\n", basefilename);
  fprintf(fp, "size   : %d,%d,%d\n", df->X, df->Y, df->Z);
  fprintf(fp, "step   : %d,%d,%d\n", szx, szy, szz);
  fprintf(fp, "osize  : %d,%d,%d\n", XX,YY,ZZ);
  fclose(fp);

  //  write_dbox(dfx, "test.dfx", "float", 1);
  //  write_dbox(dfy, "test.dfy", "float", 1);
  //  write_dbox(dfz, "test.dfz", "float", 1);

  //  number = 2;
  //  dwt_h = (float *) calloc (number, sizeof(float));
  //  dwt_g = (float *) calloc (number, sizeof(float));
  //  select_filter(1);

  if (need_output)
    {
      for (i=0;i<level;i++)
	{
	  printf("level %d : step %d %d %d\n", i, szx, szy, szz);
	  for (lx=0;lx<df->X;lx+=szx)
	    for (ly=0;ly<df->Y;ly+=szy)
	      for (lz=0;lz<df->Z;lz+=szz)
		{
		  printf("%d %d %d %d %d %d\n", lx, lx+szx, ly, ly+szy, lz, lz+szz);
		  iwt_3d_base_same(dfx, lx, lx+szx, ly, ly+szy, lz, lz+szz);
		  iwt_3d_base_same(dfy, lx, lx+szx, ly, ly+szy, lz, lz+szz);
		  iwt_3d_base_same(dfz, lx, lx+szx, ly, ly+szy, lz, lz+szz);
		}
	  szx = szx * 2;
	  szy = szy * 2;
	  szz = szz * 2;
	}
      //      write_dbox(dfx, "itest.dfx", "float", 1);
      //      write_dbox(dfy, "itest.dfy", "float", 1);
      //      write_dbox(dfz, "itest.dfz", "float", 1);

      odf = new_deformationfield(XX, YY, ZZ);

      for (z=0;z<ZZ;z++)
	for (y=0;y<YY;y++)
	  for (x=0;x<XX;x++)
	    {
	      odf->point[z][y][x].X = dfx->box[z][y][x];
	      odf->point[z][y][x].Y = dfy->box[z][y][x];
	      odf->point[z][y][x].Z = dfz->box[z][y][x];
	    }
      
      write_deformationfield(odf, outfilename);
    }


  printf("this is ok the end, fine!! --- zxue@rad.upenn.edu\n");
}

