/*this program calculates the av of each image

Jon Z. Xue

April 10 2001;
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <matrixSHEN.h>

extern int optopt;
extern int optind;
extern char *optarg;
extern int opterr;

void showUsage(char *filename)
{
  printf("\nusage: %s inputimage outputwaveletimage [options]\n", filename);
  printf("\n");
  printf("-d X,Y,Z      -- X,Y,Z are the size of images (no default value)\n\n");
  printf("-l level      -- wavelet levels (default = 2)\n"); 
  printf("-b            -- input is byte format (default)\n");
  printf("-f            -- input is float format\n");
  printf("file : outputwaveletimage.infor will be automatically generated\n");
}

main(int argc, char *argv[])
{
  char filename[200], *basefilename, outfilename[200], tempfilename[200];
  char format[20];

  DBox *dfx, *dfy;
  FILE *fp;

  int c;
  int x,y,z;
  int level;
  int XX,YY,ZZ;
  int i, number;
  int lx, ly, lz;
  int szx, szy, szz;

  level = 2;  
  basefilename = (char *) calloc (200, sizeof(char));

  strcpy(format, "byte");

  if (argc<4)
    {
      showUsage(argv[0]);
      exit(1);
    }
  else
    {
      strcpy(filename, argv[1]); 
      strcpy(basefilename, argv[2]);

      c=getopt(argc-2,argv+2,"d:l:bf");
      while(c!= -1)
	{
	  switch(c)
	    {
	    case 'd':
	      sscanf(optarg, "%d,%d,%d", &XX, &YY, &ZZ);
	      break;
	    case 'l':
	      level = atoi(optarg);
	      break;
	    case 'b':
	      strcpy(format, "byte");
	      break;
	    case 'f':
	      strcpy(format, "float");
	      break;
	    default:
	      printf("error\n");
	      break;
	    }
	  c=getopt(argc-2,argv+2,"d:l:bf");
	}
    }
  
  szx = XX;
  szy = YY;
  szz = ZZ;

  for (i=0;i<level;i++)
    {
      if (szx%2!=0) szx = szx+1;
      if (szy%2!=0) szy = szy+1;
      if (szz%2!=0) szz = szz+1;

      szx = szx/2;
      szy = szy/2;
      szz = szz/2;
      //      printf("%d %d %d %d\n", i, szx, szy, szz);
    }

  for (i=0;i<level;i++)
    {
      szx = szx*2;
      szy = szy*2;
      szz = szz*2;
      printf("%d %d %d %d\n", i, szx, szy, szz);
    }

  dfx = new_dbox(XX,YY,ZZ);
  dfy = new_dbox(szx,szy,szz);
  clear_dbox(dfy);
  read_dbox(dfx, filename, format);

  for (z=0;z<ZZ;z++)
    for (y=0;y<YY;y++)
      for (x=0;x<XX;x++)
	{
	  dfy->box[z][y][x] = dfx->box[z][y][x];
	} 

  for (x=XX;x<szx;x++)
    for (z=0;z<ZZ;z++)
      for (y=0;y<YY;y++)
	{
	  dfy->box[z][y][x] = dfy->box[z][y][x-1];
	}

  for (y=YY;y<szy;y++)
    for (z=0;z<ZZ;z++)
      for (x=0;x<szx;x++)
	{
	  dfy->box[z][y][x] = dfy->box[z][y-1][x];
	}

  for (z=ZZ;z<szz;z++)
    for (y=0;y<szy;y++)
      for (x=0;x<szx;x++)
	{
	  dfy->box[z][y][x] = dfy->box[z-1][y][x];
	}      

  printf("size of data is %d,%d,%d\n", szx, szy, szz);

  for (i=0;i<level;i++)
    {
      printf("level %d : step %d %d %d\n", i, szx, szy, szz);
      for (lx=0;lx<dfy->X;lx+=szx)
	for (ly=0;ly<dfy->Y;ly+=szy)
	  for (lz=0;lz<dfy->Z;lz+=szz)
	    {
	      wt_3d_base_same(dfy, lx, lx+szx, ly, ly+szy, lz, lz+szz);
	    }
      szx = szx/2;
      szy = szy/2;
      szz = szz/2;
    }
  szx = szx * 2;
  szy = szy * 2;
  szz = szz * 2;

  write_dbox(dfy, basefilename, "float", 1);

  sprintf(tempfilename, "%s.infor", basefilename);
  fp = fopen(tempfilename, "wt");
  fprintf(fp, "favname: %s\n", basefilename);
  fprintf(fp, "size   : %d,%d,%d\n", dfy->X, dfy->Y, dfy->Z);
  fprintf(fp, "step   : %d,%d,%d\n", szx, szy, szz);
  fprintf(fp, "osize  : %d,%d,%d\n", XX,YY,ZZ);
  fclose(fp);

  printf("this is ok the end, fine!! --- zxue@rad.upenn.edu\n");
}

